/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.attribs.features.BalconyTerraceDirection;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexEnumAttrib<OptionType extends Enum>
extends ComplexAttrib<OptionType[]> {
    private static final long serialVersionUID = 277100687826491305L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexEnumAttrib.class);
    private OptionType[] value = null;

    public ComplexEnumAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    protected static Enum[] get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        try {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)estateImpl.getAttribute(openEstateAttrib);
            return complexEnumAttrib != null ? (Enum[])((AbstractAttribImpl)complexEnumAttrib).getValue() : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as Enum[]!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        return ComplexEnumAttrib.getAsString(estateImpl, openEstateAttrib, string, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, Locale locale) {
        try {
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(locale, string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public OptionType[] getDefaultValue() {
        return this.getOptionsArray(null);
    }

    @Override
    public String getFormattedValue(OptionType[] OptionTypeArray, Locale locale, String string) {
        AbstractSet abstractSet;
        if (ArrayUtils.isEmpty((Object[])OptionTypeArray)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = ", ";
        }
        ArrayList<BalconyTerraceDirection.Option> arrayList = new ArrayList<BalconyTerraceDirection.Option>();
        if (OpenEstateAttrib.FEATURES_BALCONY_TERRACE_DIRECTION.equals(this.getAttrib())) {
            abstractSet = new LinkedHashSet();
            if (ArrayUtils.contains((Object[])OptionTypeArray, (Object)BalconyTerraceDirection.Option.N)) {
                arrayList.add(BalconyTerraceDirection.Option.N);
            }
            if (ArrayUtils.contains((Object[])OptionTypeArray, (Object)BalconyTerraceDirection.Option.S)) {
                arrayList.add(BalconyTerraceDirection.Option.S);
            }
            if (ArrayUtils.contains((Object[])OptionTypeArray, (Object)BalconyTerraceDirection.Option.E)) {
                arrayList.add(BalconyTerraceDirection.Option.E);
            }
            if (ArrayUtils.contains((Object[])OptionTypeArray, (Object)BalconyTerraceDirection.Option.W)) {
                arrayList.add(BalconyTerraceDirection.Option.W);
            }
        } else {
            abstractSet = new TreeSet();
            arrayList.addAll(Arrays.asList(OptionTypeArray));
        }
        for (Enum enum_ : arrayList) {
            String string2 = this.getOptionTranslation(enum_, locale);
            abstractSet.add(!StringUtils.isBlank((CharSequence)string2) ? string2 : enum_.name());
        }
        return StringUtils.join(abstractSet, (String)string);
    }

    public abstract OptionType getOption(String var1);

    public final String getOptionTranslation(OptionType OptionType) {
        return this.getOptionTranslation(OptionType, null);
    }

    public final String getOptionTranslation(OptionType OptionType, Locale locale) {
        return OptionType instanceof Translatable ? ((Translatable)OptionType).getTranslation(locale) : (OptionType != null ? ((Enum)OptionType).name() : null);
    }

    public abstract OptionType[] getOptions();

    public abstract OptionType[] getOptionsArray(Collection<OptionType> var1);

    @Override
    public OptionType[] getValue() {
        return (Enum[])ArrayUtils.clone((Object[])this.value);
    }

    public List<OptionType> getValueList() {
        Object ObjectType = ((AbstractAttribImpl)this).getValue();
        return ObjectType != null ? Arrays.asList(ObjectType) : null;
    }

    @Override
    public boolean hasEmptyValue() {
        return ArrayUtils.isEmpty(((AbstractAttribImpl)this).getValue());
    }

    public boolean hasOption(OptionType OptionType) {
        return OptionType != null && ArrayUtils.contains(((AbstractAttribImpl)this).getValue(), OptionType);
    }

    protected static boolean hasOption(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Enum enum_) {
        ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)estateImpl.getAttribute(openEstateAttrib);
        return complexEnumAttrib != null && complexEnumAttrib.hasOption(enum_);
    }

    @Override
    protected OptionType[] parseNode(Element element) {
        if (element == null) {
            return null;
        }
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string = element.getStringValue();
            if (!StringUtils.isBlank((CharSequence)string)) {
                Object object = this.getOption(string);
                if (object == null) {
                    object = OpenEstateUtils.lookupAttribOption(this.getGroupName(), this.getAttribName(), string);
                }
                if (object != null) {
                    arrayList.add(object);
                }
            }
            for (Object e : element.selectNodes("@*")) {
                Node node = (Node)e;
                if (!Boolean.valueOf(node.getStringValue()).equals(Boolean.TRUE)) continue;
                String string2 = node.getName();
                Object object = this.getOption(string2);
                if (object == null) {
                    object = OpenEstateUtils.lookupAttribOption(this.getGroupName(), this.getAttribName(), string2);
                }
                if (object == null || arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            return this.getOptionsArray(arrayList);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse multiple-enum attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public OptionType[] parseValue(Object object) {
        ArrayList<OptionType> arrayList;
        block9: {
            block8: {
                arrayList = new ArrayList<OptionType>();
                if (!(object instanceof String)) break block8;
                Object object2 = this.getOption((String)object);
                if (object2 == null) {
                    object2 = OpenEstateUtils.lookupAttribOption(this.getGroupName(), this.getAttribName(), (String)object);
                }
                if (object2 == null) break block9;
                arrayList.add(object2);
                break block9;
            }
            if (object instanceof String[]) {
                for (String string : (String[])object) {
                    Object object3 = this.getOption(string);
                    if (object3 == null) {
                        object3 = OpenEstateUtils.lookupAttribOption(this.getGroupName(), this.getAttribName(), string);
                    }
                    if (object3 == null || arrayList.contains(object3)) continue;
                    arrayList.add(object3);
                }
            } else if (object instanceof List) {
                for (Object e : (List)object) {
                    String string = e instanceof Enum ? ((Enum)e).name() : e.toString();
                    Object object4 = this.getOption(string);
                    if (object4 == null) {
                        object4 = OpenEstateUtils.lookupAttribOption(this.getGroupName(), this.getAttribName(), string);
                    }
                    if (object4 == null || arrayList.contains(object4)) continue;
                    arrayList.add(object4);
                }
            }
        }
        return this.getOptionsArray(arrayList);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Enum[] enumArray) {
        if (ArrayUtils.isEmpty((Object[])enumArray)) {
            ComplexEnumAttrib.put(estateImpl, openEstateAttrib, (String[])null);
        } else {
            String[] stringArray = new String[enumArray.length];
            for (int i = 0; i < enumArray.length; ++i) {
                stringArray[i] = enumArray[i] != null ? enumArray[i].name() : null;
            }
            ComplexEnumAttrib.put(estateImpl, openEstateAttrib, stringArray);
        }
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        try {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)openEstateAttrib.createImpl();
            ArrayList<Enum> arrayList = new ArrayList<Enum>();
            if (!ArrayUtils.isEmpty((Object[])stringArray)) {
                for (Enum enum_ : complexEnumAttrib.getOptions()) {
                    if (!ArrayUtils.contains((Object[])stringArray, (Object)enum_.name())) continue;
                    arrayList.add(enum_);
                }
            }
            if (arrayList.isEmpty()) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ((AbstractAttribImpl)complexEnumAttrib).setValue(complexEnumAttrib.getOptionsArray(arrayList));
                estateImpl.putAttribute(complexEnumAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put enum[] attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void putOption(OptionType OptionType) {
        if (OptionType == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object ObjectType = ((AbstractAttribImpl)this).getValue();
        if (!ArrayUtils.isEmpty(ObjectType)) {
            arrayList.addAll(Arrays.asList(ObjectType));
        }
        if (!arrayList.contains(OptionType)) {
            arrayList.add(OptionType);
            ((AbstractAttribImpl)this).setValue(this.getOptionsArray(arrayList));
        }
    }

    protected static void putOption(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Enum enum_) {
        if (!estateImpl.hasAttribute(openEstateAttrib)) {
            Enum[] enumArray;
            if (enum_ != null) {
                Enum[] enumArray2 = new Enum[1];
                enumArray = enumArray2;
                enumArray2[0] = enum_;
            } else {
                enumArray = null;
            }
            ComplexEnumAttrib.put(estateImpl, openEstateAttrib, enumArray);
        } else {
            ComplexEnumAttrib.putOption(estateImpl, openEstateAttrib, enum_ != null ? enum_.name() : null);
        }
    }

    protected static void putOption(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        if (!estateImpl.hasAttribute(openEstateAttrib)) {
            String[] stringArray;
            if (string != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            } else {
                stringArray = null;
            }
            ComplexEnumAttrib.put(estateImpl, openEstateAttrib, stringArray);
        } else {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)estateImpl.getAttribute(openEstateAttrib);
            complexEnumAttrib.putOption(complexEnumAttrib.getOption(string));
        }
    }

    public void removeOption(OptionType OptionType) {
        if (OptionType == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Object ObjectType = ((AbstractAttribImpl)this).getValue();
        if (!ArrayUtils.isEmpty(ObjectType)) {
            arrayList.addAll(Arrays.asList(ObjectType));
        }
        if (arrayList.contains(OptionType)) {
            arrayList.remove(OptionType);
            ((AbstractAttribImpl)this).setValue(this.getOptionsArray(arrayList));
        }
    }

    protected static void removeOption(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Enum enum_) {
        if (estateImpl.hasAttribute(openEstateAttrib)) {
            ComplexEnumAttrib.removeOption(estateImpl, openEstateAttrib, enum_ != null ? enum_.name() : null);
        }
    }

    protected static void removeOption(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        if (estateImpl.hasAttribute(openEstateAttrib)) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)estateImpl.getAttribute(openEstateAttrib);
            complexEnumAttrib.removeOption(complexEnumAttrib.getOption(string));
        }
    }

    @Override
    public void setValue(OptionType[] OptionTypeArray) {
        this.value = (Enum[])ArrayUtils.clone((Object[])OptionTypeArray);
    }

    public void setValueList(List<OptionType> list) {
        this.value = list == null || !list.isEmpty() ? this.getOptionsArray(list) : null;
    }

    @Override
    protected void writeNode(Element element, OptionType[] OptionTypeArray) {
        if (element == null) {
            return;
        }
        try {
            ArrayList arrayList = OptionTypeArray != null ? Arrays.asList(OptionTypeArray) : new ArrayList();
            for (Enum enum_ : this.getOptions()) {
                element.addAttribute(enum_.name(), Boolean.toString(arrayList.contains(enum_)));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write multiple-enum attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

