/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.values.VolumeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexVolumeAttrib
extends ComplexAttrib<VolumeValue> {
    private static final long serialVersionUID = -4215032525994069587L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexVolumeAttrib.class);
    private static final String XML_ATTRIB_UNIT = "Unit";
    private VolumeValue value = null;

    public ComplexVolumeAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public VolumeValue getDefaultValue() {
        return new VolumeValue(BigDecimal.ZERO, null);
    }

    protected static VolumeValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, VolumeValue.Unit.getBaseUnit());
    }

    protected static VolumeValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        try {
            ComplexVolumeAttrib complexVolumeAttrib = (ComplexVolumeAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexVolumeAttrib == null) {
                return null;
            }
            VolumeValue volumeValue = complexVolumeAttrib.getValue();
            return unit == null || unit == volumeValue.getUnit() ? volumeValue : new VolumeValue(VolumeValue.convert(volumeValue, unit), unit);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as VolumeValue!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? volumeValue.getValue() : null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? volumeValue.getValue().toBigInteger() : null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? Double.valueOf(volumeValue.doubleValue()) : null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? Float.valueOf(volumeValue.floatValue()) : null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? Integer.valueOf(volumeValue.intValue()) : null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
        return volumeValue != null ? Long.valueOf(volumeValue.longValue()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit) {
        return ComplexVolumeAttrib.getAsString(estateImpl, openEstateAttrib, unit, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue.Unit unit, Locale locale) {
        try {
            VolumeValue volumeValue = ComplexVolumeAttrib.get(estateImpl, openEstateAttrib, unit);
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return volumeValue != null && abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(volumeValue, locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    @Override
    public String getFormattedValue(VolumeValue volumeValue, Locale locale, String string) {
        if (volumeValue == null) {
            return "";
        }
        String string2 = OpenEstateUtils.isApproximatedAttributes() ? OpenEstateConstant.APPROX.getTranslation(locale) + " " : "";
        return string2 + this.getFormat(locale).format(volumeValue.getValue()) + " " + volumeValue.getUnit().write();
    }

    @Override
    public VolumeValue getValue() {
        return this.value;
    }

    @Override
    protected VolumeValue parseNode(Element element) {
        VolumeValue.Unit unit;
        if (element == null) {
            return null;
        }
        Number number = OpenEstateUtils.parseNumber(element.getStringValue(), this.getFormat());
        Node node = element.selectSingleNode("@Unit");
        String string = StringUtils.trimToNull((String)(node != null ? node.getStringValue() : null));
        try {
            unit = string != null ? VolumeValue.Unit.valueOf(string.toUpperCase()) : VolumeValue.Unit.CUM;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse volume unit \"" + string + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        return number != null ? VolumeValue.parse(number, unit) : null;
    }

    @Override
    public VolumeValue parseValue(Object object) {
        return VolumeValue.parse(object);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, VolumeValue.Unit unit) {
        ComplexVolumeAttrib.put(estateImpl, openEstateAttrib, string != null ? VolumeValue.parse(string, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number, VolumeValue.Unit unit) {
        ComplexVolumeAttrib.put(estateImpl, openEstateAttrib, number != null ? VolumeValue.parse(number, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, VolumeValue volumeValue) {
        try {
            if (volumeValue == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexVolumeAttrib complexVolumeAttrib = (ComplexVolumeAttrib)openEstateAttrib.createImpl();
                complexVolumeAttrib.setValue(volumeValue);
                estateImpl.putAttribute(complexVolumeAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put volume attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(VolumeValue volumeValue) {
        this.value = volumeValue;
    }

    @Override
    protected void writeNode(Element element, VolumeValue volumeValue) {
        if (element == null || volumeValue == null || volumeValue.getValue() == null) {
            return;
        }
        try {
            element.setText(volumeValue.getValue().toString());
            element.addAttribute(XML_ATTRIB_UNIT, volumeValue.getUnit() != null ? volumeValue.getUnit().name() : VolumeValue.Unit.CUM.name());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write volume attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

