/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleTimeAttrib
extends SimpleAttrib<Date> {
    private static final long serialVersionUID = -4908846272214429531L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleTimeAttrib.class);
    public static final int TYPE_DATE = 0;
    public static final int TYPE_TIME = 1;
    public static final int TYPE_DATETIME = 2;
    private final int type;
    private Date value = null;

    public SimpleTimeAttrib(OpenEstateAttrib openEstateAttrib, int n, String[] stringArray) {
        super(openEstateAttrib, stringArray);
        this.type = n;
    }

    @Override
    public Date getDefaultValue() {
        return new Date();
    }

    protected static Date get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        try {
            SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)estateImpl.getAttribute(openEstateAttrib);
            return simpleTimeAttrib != null ? simpleTimeAttrib.getValue() : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as Date!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static Calendar getAsCalendar(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Date date = SimpleTimeAttrib.get(estateImpl, openEstateAttrib);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        Date date = SimpleTimeAttrib.get(estateImpl, openEstateAttrib);
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return SimpleTimeAttrib.getAsString(estateImpl, openEstateAttrib, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        try {
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final DateFormat getFormat() {
        return this.getFormat(null);
    }

    public final DateFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.isDate()) {
            return DateFormat.getDateInstance(2, locale);
        }
        if (this.isTime()) {
            return DateFormat.getTimeInstance(3, locale);
        }
        return DateFormat.getDateTimeInstance(2, 3, locale);
    }

    @Override
    public String getFormattedValue(Date date, Locale locale, String string) {
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = this.getFormat(locale);
        return dateFormat.format(date);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public Date getValue() {
        return this.value != null ? (Date)this.value.clone() : null;
    }

    public boolean isDate() {
        return this.getType() == 0;
    }

    public boolean isDateTime() {
        return this.getType() == 2;
    }

    public boolean isTime() {
        return this.getType() == 1;
    }

    @Override
    public final Date parseValue(String string) {
        if (!StringUtils.isBlank((CharSequence)string)) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    if (this.isDate()) {
                        return OpenEstateUtils.parseDate(string);
                    }
                    if (this.isTime()) {
                        return OpenEstateUtils.parseTime(string);
                    }
                    if (this.isDateTime()) {
                        return OpenEstateUtils.parseDateTime(string);
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Can't parse time from \"" + string + "\" for attribute \"" + this.getAttrib() + "\"!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
            }
        }
        return null;
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string) {
        SimpleTimeAttrib.put(estateImpl, openEstateAttrib, string != null ? ((SimpleTimeAttrib)openEstateAttrib.createImpl()).parseValue(string) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Long l) {
        SimpleTimeAttrib.put(estateImpl, openEstateAttrib, l != null ? new Date(l) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Calendar calendar) {
        SimpleTimeAttrib.put(estateImpl, openEstateAttrib, calendar != null ? calendar.getTime() : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Date date) {
        try {
            if (date == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)openEstateAttrib.createImpl();
                simpleTimeAttrib.setValue(date);
                estateImpl.putAttribute(simpleTimeAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put time attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(Date date) {
        this.value = date != null ? (Date)date.clone() : null;
    }

    @Override
    protected String writeValue(Date date) {
        if (date == null) {
            return "";
        }
        if (this.isDate()) {
            return OpenEstateUtils.getXsdDateFormat().format(date);
        }
        if (this.isTime()) {
            return OpenEstateUtils.getXsdTimeFormat().format(date);
        }
        if (this.isDateTime()) {
            return OpenEstateUtils.getXsdDateTimeFormat().format(date);
        }
        return "";
    }
}

