/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.condition;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class ConditionType
extends SimpleEnumAttrib<Option> {
    public ConditionType() {
        super(OpenEstateAttrib.CONDITION_CONDITION_TYPE, null);
    }

    public ConditionType(Option option) {
        this();
        if (option != null) {
            this.setValue(option);
        }
    }

    public static Option get(EstateImpl estateImpl) {
        return (Option)ConditionType.get(estateImpl, OpenEstateAttrib.CONDITION_CONDITION_TYPE);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option = ConditionType.get(estateImpl);
        if (option != null) {
            arrayList.add(option);
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl) {
        return ConditionType.getAsString(estateImpl, OpenEstateAttrib.CONDITION_CONDITION_TYPE);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return ConditionType.getAsString(estateImpl, OpenEstateAttrib.CONDITION_CONDITION_TYPE, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public static void put(EstateImpl estateImpl, Option option) {
        ConditionType.put(estateImpl, OpenEstateAttrib.CONDITION_CONDITION_TYPE, option);
    }

    public static void put(EstateImpl estateImpl, String string) {
        ConditionType.put(estateImpl, OpenEstateAttrib.CONDITION_CONDITION_TYPE, string);
    }

    public static enum Option implements Translatable
    {
        FULLY_REFURBISHED(I18n.marktr((String)"completely refurbished")),
        PARTIALLY_REFURBISHED(I18n.marktr((String)"partially refurbished")),
        COMPLETE_REFURBISHMENT_REQUIRED(I18n.marktr((String)"complete refurbishment required")),
        PARTIAL_REFURBISHMENT_REQUIRED(I18n.marktr((String)"partial refurbishment required")),
        FULLY_RENOVATED(I18n.marktr((String)"fully renovated")),
        PARTIALLY_RENOVATED(I18n.marktr((String)"partially renovated")),
        COMPLETE_RENOVATION_REQUIRED(I18n.marktr((String)"complete renovation required")),
        PARTIAL_RENOVATION_REQUIRED(I18n.marktr((String)"partial renovation required")),
        FIRST_OCCUPANCY(I18n.marktr((String)"first occupancy")),
        FIRST_OCCUPANCY_AFTER_REFURBISHMENT(I18n.marktr((String)"first occupancy after refurbishment")),
        AS_GOOD_AS_NEW(I18n.marktr((String)"as good as new")),
        DILAPIDATED(I18n.marktr((String)"dilapidated")),
        AS_APPOINTED(I18n.marktr((String)"by appointment")),
        MODERNIZED(I18n.marktr((String)"modernized")),
        SHELL_CONSTRUCTION(I18n.marktr((String)"shell construction")),
        GUTTED(I18n.marktr((String)"gutted")),
        CONDEMNED(I18n.marktr((String)"condemned")),
        PROJECTED(I18n.marktr((String)"projected")),
        WELL_TENDED(I18n.marktr((String)"well tended")),
        HABITABLE(I18n.marktr((String)"habitable")),
        FAIR(I18n.marktr((String)"fair")),
        GOOD(I18n.marktr((String)"good")),
        EXCELLENT(I18n.marktr((String)"excellent"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

