/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.prices;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Locale;

public final class VatValue
extends ComplexCurrencyAttrib {
    public VatValue() {
        super(OpenEstateAttrib.PRICES_VAT_VALUE, null);
    }

    public VatValue(CurrencyValue currencyValue) {
        this();
        this.setValue(currencyValue);
    }

    public VatValue(Number number, Currency currency) {
        this();
        if (number != null) {
            this.setValue(CurrencyValue.parse(number, currency));
        }
    }

    public static CurrencyValue get(EstateImpl estateImpl) {
        return VatValue.get(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static BigDecimal getAsBigDecimal(EstateImpl estateImpl) {
        return VatValue.getAsBigDecimal(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static BigInteger getAsBigInteger(EstateImpl estateImpl) {
        return VatValue.getAsBigInteger(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static Double getAsDouble(EstateImpl estateImpl) {
        return VatValue.getAsDouble(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static Float getAsFloat(EstateImpl estateImpl) {
        return VatValue.getAsFloat(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static Integer getAsInteger(EstateImpl estateImpl) {
        return VatValue.getAsInteger(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static Long getAsLong(EstateImpl estateImpl) {
        return VatValue.getAsLong(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static String getAsString(EstateImpl estateImpl) {
        return VatValue.getAsString(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return VatValue.getAsString(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE, locale);
    }

    public static void put(EstateImpl estateImpl, String string) {
        VatValue.put(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE, string);
    }

    public static void put(EstateImpl estateImpl, Number number) {
        VatValue.put(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE, number);
    }

    public static void put(EstateImpl estateImpl, CurrencyValue currencyValue) {
        VatValue.put(estateImpl, OpenEstateAttrib.PRICES_VAT_VALUE, currencyValue);
    }
}

