/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.utils.AbstractConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.openestate.io.core.CsvPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCsvWriter<Printer extends CsvPrinter>
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCsvWriter.class);

    protected abstract Printer createPrinter(OutputStream var1) throws IOException;

    protected abstract Printer createPrinter(Writer var1) throws IOException;

    public final void write(AgencyImpl agencyImpl, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.write(agencyImpl, (OutputStream)fileOutputStream);
        }
    }

    public final void write(AgencyImpl agencyImpl, OutputStream outputStream) throws IOException {
        try (Printer Printer = this.createPrinter(outputStream);){
            this.write(agencyImpl, Printer);
        }
    }

    public final void write(AgencyImpl agencyImpl, Writer writer) throws IOException {
        try (Printer Printer = this.createPrinter(writer);){
            this.write(agencyImpl, Printer);
        }
    }

    public abstract void write(AgencyImpl var1, Printer var2) throws IOException;

    public final String writeToString(AgencyImpl agencyImpl) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            this.write(agencyImpl, (Writer)stringWriter);
            String string = ((Object)stringWriter).toString();
            return string;
        }
    }

    public final void write(TransferImpl transferImpl, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.write(transferImpl, (OutputStream)fileOutputStream);
        }
    }

    public final void write(TransferImpl transferImpl, OutputStream outputStream) throws IOException {
        try (Printer Printer = this.createPrinter(outputStream);){
            this.write(transferImpl, Printer);
        }
    }

    public final void write(TransferImpl transferImpl, Writer writer) throws IOException {
        try (Printer Printer = this.createPrinter(writer);){
            this.write(transferImpl, Printer);
        }
    }

    public abstract void write(TransferImpl var1, Printer var2) throws IOException;

    public final String writeToString(TransferImpl transferImpl) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            this.write(transferImpl, (Writer)stringWriter);
            String string = ((Object)stringWriter).toString();
            return string;
        }
    }
}

