/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLFontDialog;

public class HTMLFontAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLFontAction() {
        super(i18n.str("font_"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLFontDialog hTMLFontDialog = this.createDialog(jEditorPane);
        hTMLFontDialog.setLocationRelativeTo(hTMLFontDialog.getParent());
        hTMLFontDialog.setVisible(true);
        if (!hTMLFontDialog.hasUserCancelled()) {
            jEditorPane.requestFocusInWindow();
            jEditorPane.replaceSelection(hTMLFontDialog.getHTML());
        }
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getCharacterElement(jEditorPane.getCaretPosition());
        AttributeSet attributeSet = element.getAttributes();
        HTMLFontDialog hTMLFontDialog = this.createDialog(jEditorPane);
        hTMLFontDialog.setBold(attributeSet.containsAttribute(StyleConstants.Bold, Boolean.TRUE));
        hTMLFontDialog.setItalic(attributeSet.containsAttribute(StyleConstants.Italic, Boolean.TRUE));
        hTMLFontDialog.setUnderline(attributeSet.containsAttribute(StyleConstants.Underline, Boolean.TRUE));
        Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
        if (object != null) {
            hTMLFontDialog.setFontName(object.toString());
        }
        if ((object = attributeSet.getAttribute(StyleConstants.FontSize)) != null) {
            try {
                hTMLFontDialog.setFontSize(Integer.parseInt(object.toString()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        hTMLFontDialog.setLocationRelativeTo(hTMLFontDialog.getParent());
        hTMLFontDialog.setVisible(true);
        if (!hTMLFontDialog.hasUserCancelled()) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, hTMLFontDialog.getFontName());
            simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(hTMLFontDialog.getFontSize()));
            simpleAttributeSet.addAttribute(StyleConstants.Bold, new Boolean(hTMLFontDialog.isBold()));
            simpleAttributeSet.addAttribute(StyleConstants.Italic, new Boolean(hTMLFontDialog.isItalic()));
            simpleAttributeSet.addAttribute(StyleConstants.Underline, new Boolean(hTMLFontDialog.isUnderline()));
            CompoundUndoManager.beginCompoundEdit(jEditorPane.getDocument());
            HTMLUtils.setCharacterAttributes(jEditorPane, simpleAttributeSet);
            CompoundUndoManager.endCompoundEdit(jEditorPane.getDocument());
        }
    }

    private HTMLFontDialog createDialog(JTextComponent jTextComponent) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        String string = "";
        if (jTextComponent.getSelectedText() != null) {
            string = jTextComponent.getSelectedText();
        }
        HTMLFontDialog hTMLFontDialog = null;
        if (window != null && window instanceof Frame) {
            hTMLFontDialog = new HTMLFontDialog((Frame)window, string);
        } else if (window != null && window instanceof Dialog) {
            hTMLFontDialog = new HTMLFontDialog((Dialog)window, string);
        }
        return hTMLFontDialog;
    }
}

