/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.NewTableDialog;

public class HTMLTableAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLTableAction() {
        super(i18n.str("table_"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("table_")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "table.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        NewTableDialog newTableDialog = this.createNewTableDialog(jEditorPane);
        if (newTableDialog == null) {
            return;
        }
        newTableDialog.setLocationRelativeTo(newTableDialog.getParent());
        newTableDialog.setVisible(true);
        if (newTableDialog.hasUserCancelled()) {
            return;
        }
        jEditorPane.replaceSelection(newTableDialog.getHTML());
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        NewTableDialog newTableDialog = this.createNewTableDialog(jEditorPane);
        if (newTableDialog == null) {
            return;
        }
        newTableDialog.setLocationRelativeTo(newTableDialog.getParent());
        newTableDialog.setVisible(true);
        if (newTableDialog.hasUserCancelled()) {
            return;
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        String string = newTableDialog.getHTML();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        try {
            if (HTMLUtils.isElementEmpty(element)) {
                hTMLDocument.setOuterHTML(element, string);
            } else if (element.getName().equals("p-implied")) {
                hTMLDocument.insertAfterEnd(element, string);
            } else {
                HTMLUtils.insertHTML(string, HTML.Tag.TABLE, jEditorPane);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    private NewTableDialog createNewTableDialog(JTextComponent jTextComponent) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        NewTableDialog newTableDialog = null;
        if (window != null && window instanceof Frame) {
            newTableDialog = new NewTableDialog((Frame)window);
        } else if (window != null && window instanceof Dialog) {
            newTableDialog = new NewTableDialog((Dialog)window);
        }
        return newTableDialog;
    }
}

