/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.atlanticbb.tantlinger.ui.text.AbstractToolBar;
import org.bushe.swing.action.ActionList;

public abstract class AbstractEditor {
    public void addCaretListener(CaretListener caretListener) {
    }

    public void addDocumentListener(DocumentListener documentListener) {
        Document document = this.getDocument();
        if (document != null) {
            document.addDocumentListener(documentListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public abstract int getCaretPosition();

    public abstract JComponent getComponent();

    public abstract Document getDocument();

    public abstract String getTabTitle();

    public abstract String getText();

    public AbstractToolBar getToolBar() {
        return null;
    }

    public void insertText(String string) {
        this.insertText(string, this.getCaretPosition());
    }

    public void insertText(String string, int n) {
        try {
            this.getDocument().insertString(n, string, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract void registerEditor(ActionList var1);

    public abstract void requestFocusInWindow();

    public void removeCaretListener(CaretListener caretListener) {
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        Document document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener(documentListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
    }

    public void removeMouseListener(MouseListener mouseListener) {
    }

    public abstract void setCaretPosition(int var1);

    public abstract void setDocument(Document var1);

    public abstract void setText(String var1);
}

