/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLHorizontalRuleAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLHorizontalRuleAction() {
        super(i18n.str("horizontal_rule"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("horizontal_rule")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "hrule.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        jEditorPane.replaceSelection("<hr>");
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        int n = jEditorPane.getCaretPosition();
        Element element = hTMLDocument.getParagraphElement(n);
        HTML.Tag tag = HTML.getTag(element.getName());
        if (element.getName().equals("p-implied")) {
            tag = HTML.Tag.IMPLIED;
        }
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("", "<hr>", tag, HTML.Tag.HR);
        insertHTMLTextAction.actionPerformed(actionEvent);
    }
}

