/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.ElementWriter;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class TableEditAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int INSERT_CELL = 0;
    public static final int DELETE_CELL = 1;
    public static final int INSERT_ROW = 2;
    public static final int DELETE_ROW = 3;
    public static final int INSERT_COL = 4;
    public static final int DELETE_COL = 5;
    private static final String[] NAMES = new String[]{i18n.str("insert_cell"), i18n.str("delete_cell"), i18n.str("insert_row"), i18n.str("delete_row"), i18n.str("insert_column"), i18n.str("delete_column")};
    private int type;

    public TableEditAction(int n) throws IllegalArgumentException {
        super("");
        if (n < 0 || n >= NAMES.length) {
            throw new IllegalArgumentException("Invalid type");
        }
        this.type = n;
        this.putValue("Name", NAMES[n]);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                return TableEditAction.this.getEditMode() != 1 && TableEditAction.this.isInTD(TableEditAction.this.getCurrentEditor());
            }
        });
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TD);
        Element element3 = HTMLUtils.getParent(element, HTML.Tag.TR);
        if (element2 == null || element3 == null || hTMLDocument == null) {
            return;
        }
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        try {
            if (this.type == 0) {
                hTMLDocument.insertAfterEnd(element2, "<td></td>");
            } else if (this.type == 1) {
                this.removeCell(element2);
            } else if (this.type == 2) {
                this.insertRowAfter(element3);
            } else if (this.type == 3) {
                this.removeRow(element3);
            } else if (this.type == 4) {
                this.insertColumnAfter(element2);
            } else if (this.type == 5) {
                this.removeColumn(element2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    private void removeCell(Element element) throws Exception {
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TR);
        if (element2 != null && element.getName().equals("td")) {
            if (element.getEndOffset() != element2.getEndOffset()) {
                this.remove(element);
            } else if (this.getRowCellCount(element2) <= 1) {
                this.remove(element2);
            } else {
                StringWriter stringWriter = new StringWriter();
                ElementWriter elementWriter = new ElementWriter((Writer)stringWriter, element2, element2.getStartOffset(), element.getStartOffset());
                elementWriter.write();
                HTMLDocument hTMLDocument = (HTMLDocument)element2.getDocument();
                hTMLDocument.setOuterHTML(element2, stringWriter.toString());
            }
        }
    }

    private void insertRowAfter(Element element) throws Exception {
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TABLE);
        if (element2 != null && element.getName().equals("tr")) {
            HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
            if (element.getEndOffset() != element2.getEndOffset()) {
                hTMLDocument.insertAfterEnd(element, this.getRowHTML(element));
            } else {
                AttributeSet attributeSet = element2.getAttributes();
                String string = HTMLUtils.getElementHTML(element2, false);
                string = string + this.getRowHTML(element);
                string = HTMLUtils.createTag(HTML.Tag.TABLE, attributeSet, string);
                hTMLDocument.setOuterHTML(element2, string);
            }
        }
    }

    private void removeRow(Element element) throws Exception {
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TABLE);
        if (element2 != null && element.getName().equals("tr")) {
            if (element.getEndOffset() != element2.getEndOffset()) {
                this.remove(element);
            } else if (this.getTableRowCount(element2) <= 1) {
                this.remove(element2);
            } else {
                StringWriter stringWriter = new StringWriter();
                ElementWriter elementWriter = new ElementWriter((Writer)stringWriter, element2, element2.getStartOffset(), element.getStartOffset());
                elementWriter.write();
                HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
                hTMLDocument.setOuterHTML(element2, stringWriter.toString());
            }
        }
    }

    private int getTableRowCount(Element element) {
        int n = 0;
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            if (!element2.getName().equals("tr")) continue;
            ++n;
        }
        return n;
    }

    private int getRowCellCount(Element element) {
        int n = 0;
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            if (!element2.getName().equals("td")) continue;
            ++n;
        }
        return n;
    }

    private void remove(Element element) throws BadLocationException {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset() - n;
        Document document = element.getDocument();
        if (element.getEndOffset() > document.getLength()) {
            n2 = document.getLength() - n;
        }
        document.remove(n, n2);
    }

    private int getCellIndex(Element element, Element element2) {
        int n = -1;
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element3 = element.getElement(i);
            if (element3.getStartOffset() != element2.getStartOffset()) continue;
            n = i;
            break;
        }
        return n;
    }

    private void removeColumn(Element element) throws Exception {
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TR);
        int n = this.getCellIndex(element2, element);
        if (n == -1) {
            return;
        }
        Element element3 = HTMLUtils.getParent(element2, HTML.Tag.TABLE);
        for (int i = 0; i < element3.getElementCount(); ++i) {
            Element element4;
            Element element5 = element3.getElement(i);
            if (!element5.getName().equals("tr") || (element4 = element5.getElement(n)) == null || !element4.getName().equals("td")) continue;
            this.removeCell(element4);
        }
    }

    private void insertColumnAfter(Element element) throws Exception {
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TR);
        HTMLDocument hTMLDocument = (HTMLDocument)element2.getDocument();
        int n = this.getCellIndex(element2, element);
        if (n == -1) {
            return;
        }
        Element element3 = HTMLUtils.getParent(element2, HTML.Tag.TABLE);
        for (int i = 0; i < element3.getElementCount(); ++i) {
            int n2;
            Element element4 = element3.getElement(i);
            if (!element4.getName().equals("tr")) continue;
            AttributeSet attributeSet = element4.getAttributes();
            int n3 = element4.getElementCount();
            String string = "";
            String string2 = "<td></td>";
            for (n2 = 0; n2 < n3; ++n2) {
                Element element5 = element4.getElement(n2);
                string = string + HTMLUtils.getElementHTML(element5, true);
                if (n2 != n) continue;
                string = string + string2;
            }
            n2 = element4.getElementCount() - 1;
            if (n2 < n) {
                while (n2 <= n) {
                    string = string + string2;
                    ++n2;
                }
            }
            string = HTMLUtils.createTag(HTML.Tag.TR, attributeSet, string);
            hTMLDocument.setOuterHTML(element4, string);
        }
    }

    private String getRowHTML(Element element) {
        String string = "<tr>";
        if (element.getName().equals("tr")) {
            for (int i = 0; i < element.getElementCount(); ++i) {
                if (!element.getElement(i).getName().equals("td")) continue;
                string = string + "<td></td>";
            }
        }
        string = string + "</tr>";
        return string;
    }

    private boolean isInTD(JEditorPane jEditorPane) {
        Element element = null;
        if (jEditorPane != null) {
            HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            try {
                Element element2 = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
                element = HTMLUtils.getParent(element2, HTML.Tag.TD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return element != null;
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        boolean bl = this.isInTD(jEditorPane);
        if (bl && !this.isEnabled() || this.isEnabled() && !bl) {
            this.updateEnabled();
        }
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
    }
}

