/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.HeaderPanel;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.Entities;

public class SpecialCharDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "copyright.png");
    private static String title = i18n.str("special_character");
    private static String desc = i18n.str("special_character_desc");
    private Font plainFont = new Font("Dialog", 0, 12);
    private Font rollFont = new Font("Dialog", 1, 14);
    private MouseListener mouseHandler = new MouseHandler();
    private ActionListener buttonHandler = new ButtonHandler();
    private boolean insertEntity;
    private JTextComponent editor;

    public SpecialCharDialog(Frame frame, JTextComponent jTextComponent) {
        super(frame, title);
        this.editor = jTextComponent;
        this.init();
    }

    public SpecialCharDialog(Dialog dialog, JTextComponent jTextComponent) {
        super(dialog, title);
        this.editor = jTextComponent;
        this.init();
    }

    private void init() {
        Object object;
        HeaderPanel headerPanel = new HeaderPanel(title, desc, icon);
        JPanel jPanel = new JPanel(new GridLayout(8, 12, 2, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (int i = 160; i <= 255; ++i) {
            object = "&#" + i + ";";
            JButton jButton = new JButton(Entities.HTML32.unescape((String)object));
            jButton.setFont(this.plainFont);
            jButton.setOpaque(true);
            jButton.setToolTipText((String)object);
            jButton.setBackground(Color.white);
            jButton.setHorizontalAlignment(0);
            jButton.setVerticalAlignment(0);
            jButton.addActionListener(this.buttonHandler);
            jButton.addMouseListener(this.mouseHandler);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add(jButton);
        }
        JButton jButton = new JButton(i18n.str("close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpecialCharDialog.this.setVisible(false);
            }
        });
        object = new JPanel(new FlowLayout(2));
        ((Container)object).add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)headerPanel, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object, "South");
        this.pack();
        this.setResizable(false);
    }

    public void setJTextComponent(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
    }

    public JTextComponent getJTextComponent() {
        return this.editor;
    }

    public boolean isInsertEntity() {
        return this.insertEntity;
    }

    public void setInsertEntity(boolean bl) {
        this.insertEntity = bl;
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (SpecialCharDialog.this.editor != null) {
                if (!SpecialCharDialog.this.editor.hasFocus()) {
                    SpecialCharDialog.this.editor.requestFocusInWindow();
                }
                if (SpecialCharDialog.this.insertEntity) {
                    SpecialCharDialog.this.editor.replaceSelection(jButton.getToolTipText());
                } else {
                    SpecialCharDialog.this.editor.replaceSelection(jButton.getText());
                }
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getComponent();
            jButton.setFont(SpecialCharDialog.this.rollFont);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getComponent();
            jButton.setFont(SpecialCharDialog.this.plainFont);
        }
    }
}

