/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.exception;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bushe.swing.exception.AWTExceptionHandler;
import org.jdesktop.jdic.desktop.Desktop;
import org.jdesktop.jdic.desktop.Message;

public class ExceptionDialog
extends JDialog {
    public static final int PREFERRED_WIDTH = 600;
    private Throwable throwable;
    private Component detailsComponent;
    private JSeparator separator;
    private String emailAddress;

    public ExceptionDialog(Frame ownerFrame, Throwable t, boolean modal) {
        this(ownerFrame, t, modal, null);
    }

    public ExceptionDialog(Frame ownerFrame, Throwable t, boolean modal, String emailAddress) {
        super(ownerFrame, "Application Error", modal);
        this.throwable = t;
        this.emailAddress = emailAddress;
        this.setupClose();
        this.initUI(t);
    }

    protected void initUI(Throwable t) {
        this.detailsComponent = this.createDetailsComponent(t);
        JLabel errorIconLabel = this.createErrorIconLabel();
        JLabel messageLabel = this.createErrorMessageComponent();
        JComponent buttonPanel = this.createButtonPanelComponent();
        JLabel titleLabel = this.createTitleComponent();
        this.separator = this.createSeparator();
        this.doLayout(errorIconLabel, titleLabel, messageLabel, buttonPanel, this.detailsComponent, this.separator);
    }

    protected void doLayout(JLabel errorIconLabel, JLabel titleLabel, JLabel messageLabel, Component buttonPanel, Component detailsPanel, Component separator) {
        JPanel content = new JPanel(new BorderLayout());
        JPanel centerContentPanel = new JPanel(new GridBagLayout());
        content.add((Component)centerContentPanel, "Center");
        centerContentPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setContentPane(content);
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets0t10l5b5r = new Insets(0, 10, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.anchor = 11;
        centerContentPanel.add((Component)errorIconLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.insets = insets0t10l5b5r;
        gbc.anchor = 17;
        centerContentPanel.add((Component)titleLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 20, 5, 5);
        centerContentPanel.add((Component)messageLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        centerContentPanel.add(buttonPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 5, 0);
        centerContentPanel.add(separator, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 5, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        centerContentPanel.add(detailsPanel, gbc);
    }

    protected JSeparator createSeparator() {
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(600, 3));
        if (this.getDefaultDetailsVisible()) {
            separator.setVisible(false);
        }
        return separator;
    }

    protected void setupClose() {
        this.setDefaultCloseOperation(2);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction actionListener = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionListener);
    }

    protected Component createDetailsComponent(Throwable t) {
        JTextArea throwableTextArea = new JTextArea(this.getDetailComponentMessageText(), 25, 80);
        throwableTextArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(throwableTextArea);
        if (!this.getDefaultDetailsVisible()) {
            scrollPane.setVisible(false);
        }
        scrollPane.setPreferredSize(new Dimension(600, scrollPane.getPreferredSize().height));
        return scrollPane;
    }

    protected String getDetailComponentMessageText() {
        return this.determineDetailMessage(this.throwable);
    }

    protected String getEmailMessageText() {
        return this.determineDetailMessage(this.throwable);
    }

    protected JComponent createButtonPanelComponent() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JPanel leftButtonPanel = new JPanel();
        AbstractAction action = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.close();
            }
        };
        JButton okButton = new JButton(action);
        leftButtonPanel.add(okButton);
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.copy();
            }
        });
        leftButtonPanel.add(copyButton);
        if (AWTExceptionHandler.getErrorEmailAddress() != null) {
            JButton emailButton = new JButton("Email");
            emailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.this.email();
                }
            });
            leftButtonPanel.add(emailButton);
        }
        if (this.detailsComponent != null) {
            boolean defaultDetailsVisible = this.getDefaultDetailsVisible();
            final JButton detailsButton = new JButton(defaultDetailsVisible ? "Details >>" : "<< Details");
            detailsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ("<< Details".equals(detailsButton.getText())) {
                        ExceptionDialog.this.detailsComponent.setVisible(true);
                        ExceptionDialog.this.separator.setVisible(false);
                        detailsButton.setText("Details >>");
                    } else {
                        ExceptionDialog.this.detailsComponent.setVisible(false);
                        ExceptionDialog.this.separator.setVisible(true);
                        detailsButton.setText("<< Details");
                    }
                    ExceptionDialog.this.pack();
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            buttonPanel.add((Component)leftButtonPanel, gbc);
            gbc.gridx = 1;
            gbc.anchor = 13;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            JPanel rightPanel = new JPanel(new FlowLayout(2));
            rightPanel.add(detailsButton);
            buttonPanel.add((Component)rightPanel, gbc);
            buttonPanel.setBackground(Color.BLACK);
        }
        this.getRootPane().setDefaultButton(okButton);
        return buttonPanel;
    }

    protected boolean getDefaultDetailsVisible() {
        return false;
    }

    protected JLabel createErrorIconLabel() {
        return new JLabel(this.getErrorIcon());
    }

    protected JLabel createTitleComponent() {
        JLabel label = new JLabel("The following error occurred:");
        return label;
    }

    protected JLabel createErrorMessageComponent() {
        return new JLabel(this.getMessageText(this.throwable));
    }

    protected Icon getErrorIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    protected void copy() {
        StringSelection ss = new StringSelection(this.getDetailComponentMessageText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    protected void email() {
        if (this.emailAddress != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Message emailMessage = new Message();
                        ArrayList<String> to = new ArrayList<String>();
                        to.add(ExceptionDialog.this.emailAddress);
                        emailMessage.setToAddrs(to);
                        emailMessage.setSubject(ExceptionDialog.this.getErrorEmailSubject());
                        emailMessage.setBody(ExceptionDialog.this.getEmailMessageText());
                        Desktop.mail((Message)emailMessage);
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Could not email previous error.  Likely a Java Desktop Integration configuraiton issue.  " + ex, ex);
                    }
                }
            });
        }
    }

    protected String determineDetailMessage(Throwable t) {
        String msg = new Date() + "\n";
        Throwable root = this.getRootCause(t);
        if (root == t) {
            msg = String.valueOf(msg) + t.getMessage() + "\n";
            msg = String.valueOf(msg) + AWTExceptionHandler.stackTraceToString(t);
        } else {
            msg = String.valueOf(msg) + "Root Cause:" + root.getMessage() + "\n";
            msg = String.valueOf(msg) + AWTExceptionHandler.stackTraceToString(root);
            msg = String.valueOf(msg) + "Full Trace:" + t.getMessage() + "\n";
            msg = String.valueOf(msg) + AWTExceptionHandler.stackTraceToString(t);
        }
        String jvmProps = "\nJVM properties:";
        Properties props = System.getProperties();
        Iterator<Object> keyIt = props.keySet().iterator();
        while (keyIt.hasNext()) {
            Object o = keyIt.next();
            jvmProps = String.valueOf(jvmProps) + "\n" + o + "=" + props.get(o);
        }
        return String.valueOf(msg) + jvmProps;
    }

    protected String getMessageText(Throwable t) {
        if (t == null) {
            return "No throwable available.";
        }
        t = this.getRootCause(t);
        String msg = "<html>";
        String fullMessage = t.getMessage();
        if (fullMessage == null) {
            msg = String.valueOf(msg) + "No message available";
        } else if (fullMessage.length() < 80) {
            msg = String.valueOf(msg) + fullMessage;
        } else {
            String line = "";
            StringTokenizer tok = new StringTokenizer(fullMessage, " \throwable\n\r\f", true);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (line.length() + token.length() > 80) {
                    msg = String.valueOf(msg) + line + "<br>";
                    line = "";
                    continue;
                }
                line = String.valueOf(line) + token;
            }
            msg = String.valueOf(msg) + line;
        }
        return String.valueOf(msg) + "</html>";
    }

    protected String getErrorEmailSubject() {
        return "Application Error";
    }

    protected void close() {
        this.dispose();
    }

    private Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }
}

