/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.CalendarModel;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CalendarViewConfig {
    private CalendarModel callback;
    private boolean showTopHeader = true;
    private Font font = new Font("Verdana", 0, 10);
    private Color primaryColor = new Color(100, 100, 245);
    private Color secondaryColor = new Color(255, 255, 255);
    private String caption;
    private Color lineColor = new Color(200, 200, 200);
    private Color lineColor2 = new Color(150, 150, 150);
    private Color lineColor3 = new Color(100, 100, 100);
    private TimeOfDay startView;
    private TimeOfDay endView;
    private DateFormat monthDateFormat = new SimpleDateFormat("EEEE", Locale.getDefault());
    private DateFormat weekDateFormat = new SimpleDateFormat("EE - dd.MM.", Locale.getDefault());
    private DateFormat dayFormat = new SimpleDateFormat("EEEE dd.MM.yyyy", Locale.getDefault());

    public CalendarViewConfig() {
        this.startView = new TimeOfDay(2, 0);
        this.endView = new TimeOfDay(18, 0);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public CalendarModel getCallback() {
        return this.callback;
    }

    public void setCallback(CalendarModel calendarModel) {
        this.callback = calendarModel;
    }

    public boolean isShowTopHeader() {
        return this.showTopHeader;
    }

    public void setShowTopHeader(boolean bl) {
        this.showTopHeader = bl;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void copy(CalendarViewConfig calendarViewConfig) {
        this.callback = calendarViewConfig.callback;
        this.font = calendarViewConfig.font;
        this.showTopHeader = calendarViewConfig.showTopHeader;
        this.startView = calendarViewConfig.startView;
        this.endView = calendarViewConfig.endView;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color color) {
        this.primaryColor = color;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(Color color) {
        this.secondaryColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public TimeOfDay getEndView() {
        return this.endView;
    }

    public void setEndView(TimeOfDay timeOfDay) {
        this.endView = timeOfDay;
    }

    public TimeOfDay getStartView() {
        return this.startView;
    }

    public void setStartView(TimeOfDay timeOfDay) {
        this.startView = timeOfDay;
    }

    public Color getLineColor2() {
        return this.lineColor2;
    }

    public void setLineColor2(Color color) {
        this.lineColor2 = color;
    }

    public Color getLineColor3() {
        return this.lineColor3;
    }

    public void setLineColor3(Color color) {
        this.lineColor3 = color;
    }

    public int getMinimumTimeSlotHeight() {
        return 20;
    }

    public DateFormat getDayFormat() {
        return this.dayFormat;
    }

    public void setDayFormat(DateFormat dateFormat) {
        this.dayFormat = dateFormat;
    }

    public DateFormat getMonthDateFormat() {
        return this.monthDateFormat;
    }

    public void setMonthDateFormat(DateFormat dateFormat) {
        this.monthDateFormat = dateFormat;
    }

    public DateFormat getWeekDateFormat() {
        return this.weekDateFormat;
    }

    public void setWeekDateFormat(DateFormat dateFormat) {
        this.weekDateFormat = dateFormat;
    }
}

