/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import bizcal.common.Event;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameArea
extends JComponent
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameArea.class);
    private String itsHeadLine;
    private String itsDescription;
    private Color fontColor;
    private List<Listener> listeners = new ArrayList<Listener>();
    private boolean border;
    private Color bordercolor;
    private boolean roundedRectangle;
    private boolean selected;
    private ImageIcon icon;
    private ImageIcon upperRightIcon;
    private Date endTime = null;
    private Date startTime = null;
    private boolean isMoving = false;
    private String movingString = "";
    private Date moveDate;
    private Event event = null;
    private List<FrameArea> children = null;
    private Color bgColor;
    public double xPosition = 0.0;
    public double yPosition = 54.0;
    private Color alphaFontColor;
    private Font normalFont;
    private float ALPHA_DEFAULT = 0.6f;
    private float SELECT_OFFSET = 0.2f;
    private float alphaValue = this.ALPHA_DEFAULT;
    private int lineDistance = 4;
    private static int HEADER_HEIGHT = 20;
    private boolean showHeader = true;
    private int lineWrap = -1;
    private boolean isBackgroundMarker = false;
    private int boundX;
    private int boundY;
    private int boundWidth;
    private int boundHeight;
    private static Color backgroundMarkColor = new Color(205, 207, 255);
    public final DateFormat timeFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());

    public FrameArea() {
        this.normalFont = new Font("Verdana", 0, 10);
        this.setFont(this.normalFont);
        this.setBackground(new Color(100, 100, 245));
        this.alphaFontColor = this.fontColor = Color.WHITE;
        this.border = true;
        this.roundedRectangle = true;
        this.selected = false;
        this.addComponentListener(this);
    }

    public FrameArea(boolean bl) {
        this();
        this.isBackgroundMarker = bl;
        if (this.isBackgroundMarker) {
            this.setBackground(backgroundMarkColor);
        }
    }

    public void setEvent(Event event) {
        this.event = event;
        if (this.event != null) {
            this.bgColor = event.getColor();
        }
        this.fontColor = this.event != null && this.event.isBackground() ? Color.BLACK : FrameArea.computeForeground(this.bgColor);
        this.alphaFontColor = new Color(this.fontColor.getRed(), this.fontColor.getGreen(), this.fontColor.getBlue(), 220);
        try {
            this.setBackground(event.getColor());
        }
        catch (Exception exception) {
            LOGGER.error("Can't set event.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public Event getEvent() {
        return this.event;
    }

    public void addChild(FrameArea frameArea) {
        if (this.children == null) {
            this.children = Collections.synchronizedList(new ArrayList(1));
        }
        this.children.add(frameArea);
    }

    public void removeChild(FrameArea frameArea) {
        if (this.children != null) {
            this.children.remove(frameArea);
        }
    }

    public List<FrameArea> getChildren() {
        if (this.children == null) {
            this.children = Collections.synchronizedList(new ArrayList(0));
        }
        return this.children;
    }

    public void setIsMoving(boolean bl) {
        this.isMoving = bl;
    }

    public synchronized void setMovingTimeString(Date date, Date date2) {
        this.moveDate = (Date)date.clone();
        this.movingString = this.timeFormat.format(this.moveDate) + " - " + this.timeFormat.format(date2);
    }

    public void setEndTime(Date date) {
        this.endTime = (Date)date.clone();
    }

    public void setStartTime(Date date) {
        this.startTime = (Date)date.clone();
    }

    @Deprecated
    public void setAlphaValue(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    private synchronized String getMovingTimeString() {
        return this.movingString;
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        AlphaComposite alphaComposite;
        boolean bl;
        Color color = this.getBackground();
        Color color2 = this.getBackground();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.event != null) {
            color = this.event.getColor();
            color2 = this.event.getColor();
        }
        boolean bl2 = bl = n2 > 40;
        if (this.event != null && this.event.isBackground()) {
            color2 = Color.LIGHT_GRAY;
            this.alphaValue = this.ALPHA_DEFAULT + this.SELECT_OFFSET - 0.55f;
        }
        if (!this.getBackground().equals(color)) {
            this.setBackground(color);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setStroke(new BasicStroke(1.0f));
        Composite composite = graphics2D2.getComposite();
        if (this.isBackgroundMarker) {
            this.event.setSelectable(false);
            this.event.setBackground(true);
            AlphaComposite alphaComposite2 = null;
            alphaComposite2 = AlphaComposite.getInstance(4, this.alphaValue);
            graphics2D2.setComposite(alphaComposite2);
            graphics2D2.setPaint(this.getBackground());
            graphics2D2.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
            graphics2D.drawImage(bufferedImage, null, 0, 0);
            return;
        }
        if (this.roundedRectangle || this.event != null && this.event.get("eventProposalState") != null && ((Boolean)this.event.get("eventProposalState")).booleanValue()) {
            alphaComposite = AlphaComposite.getInstance(4, this.alphaValue);
            graphics2D2.setComposite(alphaComposite);
            graphics2D2.setPaint(this.getBackground());
            graphics2D2.fill(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 20.0, 20.0));
            graphics2D2.setPaint(color2);
            if (this.showHeader) {
                graphics2D2.fill(new RoundRectangle2D.Double(0.0, 0.0, n, 20.0, 20.0, 20.0));
            }
            if (bl) {
                graphics2D2.fill(new RoundRectangle2D.Double(0.0, n2 - 18, n, 18.0, 20.0, 20.0));
            }
            if (this.border && (this.event == null || !this.event.isBackground())) {
                graphics2D2.setComposite(composite);
                graphics2D2.setPaint(this.bordercolor);
                graphics2D2.draw(new RoundRectangle2D.Double(0.0, 0.0, n - 1, n2 - 1, 18.0, 18.0));
            }
        } else {
            alphaComposite = null;
            alphaComposite = AlphaComposite.getInstance(4, this.alphaValue);
            graphics2D2.setComposite(alphaComposite);
            graphics2D2.setPaint(this.getBackground());
            graphics2D2.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
            graphics2D2.setPaint(color2);
            if (this.showHeader) {
                graphics2D2.fill(new Rectangle2D.Double(0.0, 0.0, n, 20.0));
            }
            if (bl) {
                graphics2D2.fill(new Rectangle2D.Double(0.0, n2 - 18, n, 18.0));
            }
            if (this.border && this.event != null) {
                graphics2D2.setComposite(composite);
                graphics2D2.setPaint(Color.GRAY);
                graphics2D2.draw(new Rectangle2D.Double(1.0, 1.0, n - 2, n2 - 2));
            }
        }
        int n3 = 5;
        if (this.icon != null) {
            graphics2D2.drawImage(this.icon.getImage(), n3, 2, this);
            n3 += this.icon.getIconWidth() + 3;
        }
        if (this.upperRightIcon != null) {
            graphics2D2.drawImage(this.upperRightIcon.getImage(), this.getWidth() - 20, 2, this);
        }
        if (this.event == null || !this.event.isBackground()) {
            graphics2D2.setPaint(this.fontColor);
        } else {
            graphics2D2.setPaint(this.alphaFontColor);
        }
        Font font = this.getFont().deriveFont(1);
        graphics2D2.setFont(font);
        int n4 = 15;
        if (this.itsHeadLine != null) {
            graphics2D2.drawString(this.itsHeadLine, n3, n4);
            n4 += 15;
            n3 = 5;
        }
        if (this.itsDescription != null) {
            object = this.getFont();
            int n5 = (int)((Font)object).getSize2D();
            graphics2D2.setFont((Font)object);
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            if (this.showHeader && this.itsHeadLine == null) {
                n4 = HEADER_HEIGHT + 15;
            }
            int n6 = this.getWidth() - 15;
            if (this.lineWrap < 0 || fontMetrics.stringWidth(this.itsDescription.substring(0, this.lineWrap)) < n6 - 15 || fontMetrics.stringWidth(this.itsDescription.substring(0, this.lineWrap)) > n6) {
                String string = this.itsDescription;
                this.lineWrap = string.length();
                while (fontMetrics.stringWidth(string) > n6 && this.lineWrap > -1) {
                    string = this.itsDescription.substring(0, this.lineWrap);
                    --this.lineWrap;
                }
                if (this.lineWrap < 0) {
                    this.lineWrap = 0;
                }
            }
            int n7 = n4;
            int n8 = 0;
            String string = null;
            int n9 = 0;
            String string2 = this.itsDescription;
            for (int i = 0; i < this.itsDescription.length(); i += n8) {
                n8 = string2.indexOf("\n");
                if (n8 == -1) {
                    n8 = string2.length();
                } else {
                    ++n9;
                    ++n8;
                }
                string = string2.substring(0, n8);
                for (int j = 0; j < string.length() && this.lineWrap > 0 && n7 <= this.getHeight() - 18; j += this.lineWrap) {
                    if (j + this.lineWrap >= string.length()) {
                        graphics2D2.drawString(string.substring(j, string.length()).trim(), n3, n7);
                        continue;
                    }
                    try {
                        graphics2D2.drawString(string.substring(j, j + this.lineWrap).trim(), n3, n7);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't draw event.");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    n7 = n7 + n5 + 5;
                }
                n7 = n7 + n5 + 5;
                if (n8 == string2.length()) continue;
                string2 = string2.substring(n8, string2.length());
            }
        }
        if (bl) {
            if (this.isMoving) {
                graphics2D2.setFont(font);
                graphics2D2.drawString(this.getMovingTimeString(), n3 + this.getBounds().width - 85, n4 + this.getBounds().height - 35);
            } else if (this.startTime != null && this.endTime != null) {
                object = this.timeFormat.format(this.startTime) + " - " + this.timeFormat.format(this.endTime);
                graphics2D2.drawString((String)object, n3 + this.getBounds().width - 85, n4 + this.getBounds().height - 35);
            }
        }
        if (this.selected) {
            graphics2D2.setPaint(Color.black);
            graphics2D2.setStroke(new BasicStroke(1.5f));
            if (this.roundedRectangle) {
                graphics2D2.draw(new RoundRectangle2D.Double(1.0, 1.0, n - 3, n2 - 3, 18.0, 18.0));
            } else {
                graphics2D2.draw(new Rectangle2D.Double(1.0, 1.0, n - 3, n2 - 3));
            }
        }
        if (this.event != null && this.event.get("eventProposalState") != null && ((Boolean)this.event.get("eventProposalState")).booleanValue()) {
            graphics2D2.setPaint(Color.red);
            graphics2D2.setStroke(new BasicStroke(1.5f));
            graphics2D2.draw(new RoundRectangle2D.Double(1.0, 1.0, n - 3, n2 - 3, 18.0, 18.0));
        }
        graphics2D.drawImage(bufferedImage, null, 0, 0);
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean bl) {
        this.border = bl;
    }

    public void setBordercolor(Color color) {
        this.bordercolor = color;
    }

    public void setRoundedRectangle(boolean bl) {
        this.roundedRectangle = bl;
    }

    public boolean isRoundedRectangle() {
        return this.roundedRectangle;
    }

    public void setHeadLine(String string) {
        this.itsHeadLine = string;
        if (string == null) {
            this.itsHeadLine = "";
        }
    }

    public void setDescription(String string) {
        this.itsDescription = string;
        if (string == null) {
            this.itsDescription = "";
        }
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.setBrightness(bl);
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setBrightness(boolean bl) {
        this.alphaValue = bl ? this.ALPHA_DEFAULT + this.SELECT_OFFSET : this.ALPHA_DEFAULT - this.SELECT_OFFSET;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public ImageIcon getUpperRightIcon() {
        return this.upperRightIcon;
    }

    public void setUpperRightIcon(ImageIcon imageIcon) {
        this.upperRightIcon = imageIcon;
    }

    public void setLineDistance(int n) {
        this.lineDistance = n;
    }

    public int getLineDistance() {
        return this.lineDistance;
    }

    public void showHeader(boolean bl) {
        this.showHeader = bl;
    }

    public void commitBounds() {
        super.setBounds(this.boundX, this.boundY, this.boundWidth, this.boundHeight);
    }

    public void drawHatchedRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.lineDistance;
        if (bl) {
            graphics.drawRoundRect(n, n2, n3, n4, 20, 20);
        } else {
            graphics.drawRect(n, n2, n3, n4);
        }
        for (int i = n5; i < n3 + n4; i += n5) {
            int n6 = i <= n4 ? n : n + i - n4;
            int n7 = i <= n4 ? n2 + i : n2 + n4;
            int n8 = i <= n3 ? n + i : n + n3;
            int n9 = i <= n3 ? n2 : n2 + i - n3;
            graphics.drawLine(n6, n7, n8, n9);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static Color computeForeground(Color color) {
        if (color == null) {
            return Color.WHITE;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        FrameArea.rgb2lab(Color.WHITE.getRed(), Color.WHITE.getGreen(), Color.WHITE.getBlue(), nArray);
        FrameArea.rgb2lab(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), nArray2);
        FrameArea.rgb2lab(color.getRed(), color.getGreen(), color.getBlue(), nArray3);
        int n = FrameArea.deltaE(nArray3, nArray);
        int n2 = FrameArea.deltaE(nArray3, nArray2);
        if (n2 > n) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    private static int deltaE(int[] nArray, int[] nArray2) {
        int n = 0;
        double d = nArray2[0] - nArray[0];
        double d2 = nArray2[1] - nArray[1];
        double d3 = nArray2[2] - nArray[2];
        n = (int)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        return n;
    }

    public static void rgb2lab(int n, int n2, int n3, int[] nArray) {
        float f = 0.008856452f;
        float f2 = 903.2963f;
        float f3 = 0.964221f;
        float f4 = 1.0f;
        float f5 = 0.825211f;
        float f6 = (float)n / 255.0f;
        float f7 = (float)n2 / 255.0f;
        float f8 = (float)n3 / 255.0f;
        f6 = (double)f6 <= 0.04045 ? (f6 /= 12.0f) : (float)Math.pow(((double)f6 + 0.055) / 1.055, 2.4);
        f7 = (double)f7 <= 0.04045 ? (f7 /= 12.0f) : (float)Math.pow(((double)f7 + 0.055) / 1.055, 2.4);
        f8 = (double)f8 <= 0.04045 ? (f8 /= 12.0f) : (float)Math.pow(((double)f8 + 0.055) / 1.055, 2.4);
        float f9 = 0.43605202f * f6 + 0.3850816f * f7 + 0.14308742f * f8;
        float f10 = 0.22249159f * f6 + 0.71688604f * f7 + 0.060621485f * f8;
        float f11 = 0.013929122f * f6 + 0.097097f * f7 + 0.7141855f * f8;
        float f12 = f9 / f3;
        float f13 = f10 / f4;
        float f14 = f11 / f5;
        float f15 = f12 > f ? (float)Math.pow(f12, 0.3333333333333333) : (float)(((double)(f2 * f12) + 16.0) / 116.0);
        float f16 = f13 > f ? (float)Math.pow(f13, 0.3333333333333333) : (float)(((double)(f2 * f13) + 16.0) / 116.0);
        float f17 = f14 > f ? (float)Math.pow(f14, 0.3333333333333333) : (float)(((double)(f2 * f14) + 16.0) / 116.0);
        float f18 = 116.0f * f16 - 16.0f;
        float f19 = 500.0f * (f15 - f16);
        float f20 = 200.0f * (f16 - f17);
        nArray[0] = (int)(2.55 * (double)f18 + 0.5);
        nArray[1] = (int)((double)f19 + 0.5);
        nArray[2] = (int)((double)f20 + 0.5);
    }

    public static interface Listener
    extends EventListener {
        public void selected(FrameArea var1) throws Exception;

        public void mouseOver(FrameArea var1) throws Exception;

        public void mouseOut(FrameArea var1) throws Exception;

        public void popupMenu(FrameArea var1) throws Exception;

        public void moved(Point var1, Point var2) throws Exception;
    }
}

