/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class TableLayoutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final double FILL = -1.0;
    public static final double PREFERRED = -2.0;
    public static final int RIGHT = 3;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int BOTTOM = 3;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    private TableLayout _layout;
    private List<Column> _columns = new ArrayList<Column>();
    private List<Row> _rows = new ArrayList<Row>();

    public TableLayoutPanel() {
        this._layout = new TableLayout();
        this.setLayout((LayoutManager)this._layout);
    }

    public Column createColumn(double d) {
        Column column = new Column(this, d);
        this._columns.add(column);
        return column;
    }

    public Column createSpaceColumn(double d) {
        Column column = new Column(this, d);
        return column;
    }

    public Column createColumn() {
        Column column = new Column(this, -2.0);
        this._columns.add(column);
        return column;
    }

    public Row createRow(double d) {
        Row row = new Row(this, d);
        this._rows.add(row);
        return row;
    }

    public Row createRow() {
        Row row = new Row(this, -2.0);
        this._rows.add(row);
        return row;
    }

    public void deleteRows() {
        while (this._layout.getRow().length > 0) {
            this._layout.deleteRow(this._layout.getRow().length - 1);
        }
        this._rows.clear();
    }

    public void deleteColumns() {
        while (this._layout.getColumn().length > 0) {
            this._layout.deleteColumn(this._layout.getColumn().length - 1);
        }
        this._columns.clear();
    }

    public void clear() {
        this.removeAll();
        this.invalidate();
    }

    public class Cell {
        private TableLayoutConstraints c = new TableLayoutConstraints();
        private TableLayoutPanel _table;
        private Component _comp;

        private Cell(Column column, Row row, Component component, int n, int n2) {
            this.c.col1 = this.c.col2 = column._colNo;
            this.c.row1 = this.c.row2 = row._rowNo;
            this.c.vAlign = n;
            this.c.hAlign = n2;
            this._table = row._table;
            if (component != null) {
                this.put(component);
            }
        }

        private Cell(Column column, Row row) {
            this(column, row, null, 2, 0);
        }

        public void setVerticalAlignment(int n) {
            this.c.vAlign = n;
        }

        public void setHorizontalAlignment(int n) {
            this.c.hAlign = n;
        }

        public void setColumnSpan(int n) {
            this.c.col2 = this.c.col1 + n - 1;
        }

        public void setRowSpan(int n) {
            this.c.row2 = this.c.row1 + n - 1;
        }

        public void put(Component component) {
            if (this._comp != null) {
                this._table.remove(this._comp);
                this._table.revalidate();
            }
            this._comp = component;
            this._table.add(component, this.c);
        }
    }

    public class Column {
        private int _colNo;

        public Column(TableLayoutPanel tableLayoutPanel2, double d) {
            this._colNo = tableLayoutPanel2._layout.getNumColumn();
            tableLayoutPanel2._layout.insertColumn(this._colNo, d);
        }
    }

    public class Row {
        private TableLayoutPanel _table;
        private int _rowNo;
        private List cells = new ArrayList();

        private Row(TableLayoutPanel tableLayoutPanel2, double d) {
            this._table = tableLayoutPanel2;
            this._rowNo = tableLayoutPanel2._layout.getNumRow();
            tableLayoutPanel2._layout.insertRow(this._rowNo, d);
        }

        public Cell createCell(Component component) {
            Cell cell = this.createCell(component, 2, 0);
            this.cells.add(cell);
            return cell;
        }

        public Cell createCell(Component component, int n, int n2) {
            Cell cell = new Cell(this.getNextColumn(), this, component, n, n2);
            this.cells.add(cell);
            return cell;
        }

        public Cell createCell() {
            Cell cell = new Cell(this.getNextColumn(), this);
            this.cells.add(cell);
            return cell;
        }

        public int getRowNumber() {
            return this._rowNo;
        }

        public void setRowNumber(int n) {
            this._rowNo = n;
        }

        private Column getNextColumn() {
            if (this.cells.isEmpty()) {
                return (Column)TableLayoutPanel.this._columns.get(0);
            }
            Cell cell = (Cell)this.cells.get(this.cells.size() - 1);
            int n = ((Cell)cell).c.col2;
            return (Column)TableLayoutPanel.this._columns.get(n + 1);
        }
    }
}

