/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.export;

import bizcal.common.Event;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collection;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.UidGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICALExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICALExporter.class);
    private Calendar calendar = new Calendar();
    private UidGenerator uidGenerator;
    private boolean showCalendarName = true;

    public ICALExporter() {
        this.calendar.getProperties().add((Object)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        this.calendar.getProperties().add((Object)Version.VERSION_2_0);
        this.calendar.getProperties().add((Object)CalScale.GREGORIAN);
        try {
            this.uidGenerator = new UidGenerator("1");
        }
        catch (SocketException socketException) {
            LOGGER.warn("uidGenerator failed", (Throwable)socketException);
        }
    }

    public void saveEvents(Collection<Event> collection) {
        for (Event event : collection) {
            String string = "";
            if (this.showCalendarName && event.get("calendar_name") != null) {
                string = string + event.get("calendar_name") + ": \n";
            }
            string = string + event.getSummary();
            VEvent vEvent = new VEvent((Date)new DateTime(event.getStart()), (Date)new DateTime(event.getEnd()), string);
            Description description = new Description(event.getDescription());
            vEvent.getProperties().add((Object)description);
            Location location = new Location((String)event.get("calendar_name"));
            vEvent.getProperties().add((Object)location);
            vEvent.getProperties().add((Object)this.uidGenerator.generateUid());
            this.calendar.getComponents().add((Object)vEvent);
        }
    }

    public void writeICSFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            CalendarOutputter calendarOutputter = new CalendarOutputter();
            calendarOutputter.output(this.calendar, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            LOGGER.warn("writing ICS file failed", (Throwable)exception);
        }
    }

    public boolean isShowCalendarName() {
        return this.showCalendarName;
    }

    public void setShowCalendarName(boolean bl) {
        this.showCalendarName = bl;
    }
}

