/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.views.list.ListModel;
import lu.tudor.santec.bizcal.views.list.ListRenderer;

public class ListView
extends CalendarView
implements MouseListener {
    private JPanel panel;
    private JTable table;
    private ListModel listModel;
    private boolean showDeparted = false;
    private int showDays = 7;
    private ListViewPanel parent;
    private Date date;
    private List<Event> showEvents = new ArrayList<Event>();

    public ListView(CalendarViewConfig calendarViewConfig, ListViewPanel listViewPanel) throws Exception {
        super(calendarViewConfig);
        this.parent = listViewPanel;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout(new BorderLayout());
        this.listModel = new ListModel();
        this.table = new JTable(this.listModel);
        ListRenderer listRenderer = new ListRenderer(this.listModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(listRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(listRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(listRenderer);
        this.table.getColumnModel().getColumn(3).setCellRenderer(listRenderer);
        this.table.getColumnModel().getColumn(0).setMinWidth(120);
        this.table.getColumnModel().getColumn(0).setMaxWidth(120);
        this.table.getColumnModel().getColumn(1).setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(2).setMinWidth(120);
        this.table.getColumnModel().getColumn(2).setMaxWidth(120);
        this.table.setRowHeight(32);
        this.table.addMouseListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.panel.add((Component)jScrollPane, "Center");
        this.setDate(new Date());
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    protected Date getDate(int n, int n2) throws Exception {
        return null;
    }

    @Override
    public void refresh0() throws Exception {
        if (this.broker != null) {
            List<Event> list = this.broker.getEvents(null);
            if (!this.showDeparted) {
                Date date = this.date;
                Date date2 = DateUtil.getDiffDay(date, this.showDays);
                this.parent.setTitle(date, date2);
                this.showEvents.clear();
                for (Event event : list) {
                    if (!event.getStart().after(date) || !event.getStart().before(date2)) continue;
                    this.showEvents.add(event);
                }
            } else {
                this.showEvents = list;
            }
            this.listModel.setEvents(this.showEvents);
        }
    }

    public boolean isShowDeparted() {
        return this.showDeparted;
    }

    public void setShowDeparted(boolean bl) {
        this.showDeparted = bl;
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getShowDays() {
        return this.showDays;
    }

    public void setShowDays(int n) {
        this.showDays = n;
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        this.date = gregorianCalendar.getTime();
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.listener.eventDoubleClick(null, this.listModel.getEvent(this.table.getSelectedRow()), mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public List<Event> getEvents() {
        return this.showEvents;
    }
}

