/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.CalendarViewConfig;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;

public class DayViewConfig
extends CalendarViewConfig {
    public static final int FRAG_HOUR = 1;
    public static final int FRAG_HALF = 2;
    public static final int FRAG_THIRD = 3;
    public static final int FRAG_QUARTER = 4;
    public static final int FRAG_SIXTHT = 6;
    private boolean showExtraDateHeaders = true;
    private boolean showDateFooter = false;
    private TimeOfDay endView;
    private int gridAlpha = 50;
    private int numberOfTimeSlots = 6;
    public int DAY_START_DEFAULT = 0;
    public int DAY_END_DEFAULT = 24;
    private int dayStartHour = this.DAY_START_DEFAULT;
    private int dayEndHour = this.DAY_END_DEFAULT;
    private int breakHour = 12;
    private int dayViewStart = 7;
    private int dayViewEnd = 12;
    private int weekStart = 2;
    private int weekEnd = 1;

    public DayViewConfig() {
        this.endView = new TimeOfDay(this.dayViewEnd, 0);
        this.setCaption("Calendar");
    }

    public DayViewConfig(CalendarViewConfig calendarViewConfig) {
        this.copy(calendarViewConfig);
    }

    public int getDayCount() {
        return DateUtil.getDiffDay(this.weekStart, this.weekEnd);
    }

    @Deprecated
    public void setDayCount(int n) {
    }

    public boolean isShowExtraDateHeaders() {
        return this.showExtraDateHeaders;
    }

    public void setShowExtraDateHeaders(boolean bl) {
        this.showExtraDateHeaders = bl;
    }

    public void setShowDateFooter(boolean bl) {
        this.showDateFooter = bl;
    }

    public boolean isShowDateFooter() {
        return this.showDateFooter;
    }

    @Override
    public TimeOfDay getEndView() {
        return this.endView;
    }

    @Override
    public void setEndView(TimeOfDay timeOfDay) {
        this.endView = timeOfDay;
    }

    public int getNumberOfTimeSlots() {
        return this.numberOfTimeSlots;
    }

    public void setNumberOfTimeSlots(int n) {
        this.numberOfTimeSlots = n;
    }

    public int getDefaultDayEndHour() {
        return this.DAY_END_DEFAULT;
    }

    public int getDefaultDayStartHour() {
        return this.DAY_START_DEFAULT;
    }

    public void setDefaultDayEndHour(int n) {
        this.DAY_END_DEFAULT = n;
    }

    public void setDefaultDayStartHour(int n) {
        this.DAY_START_DEFAULT = n;
    }

    public int getDayEndHour() {
        return this.dayEndHour;
    }

    public void setDayEndHour(int n) {
        this.dayEndHour = n;
    }

    public int getDayStartHour() {
        return this.dayStartHour;
    }

    public void setDayStartHour(int n) {
        this.dayStartHour = n;
    }

    public int getHours() {
        return this.getDayEndHour() - this.getDayStartHour();
    }

    @Override
    public int getMinimumTimeSlotHeight() {
        return super.getMinimumTimeSlotHeight();
    }

    public int getDayViewEnd() {
        return this.dayViewEnd;
    }

    public void setDayViewEnd(int n) {
        this.dayViewEnd = n;
        this.endView = new TimeOfDay(n, 0);
    }

    public int getDayViewStart() {
        return this.dayViewStart;
    }

    public void setDayViewStart(int n) {
        this.dayViewStart = n;
    }

    public int getWeekEnd() {
        return this.weekEnd;
    }

    public void setWeekStop(int n) {
        this.weekEnd = n;
    }

    public int getWeekStart() {
        return this.weekStart;
    }

    public void setWeekStart(int n) {
        this.weekStart = n;
    }

    public void setDayBreak(int n) {
        this.breakHour = n;
    }

    public int getDayBreak() {
        return this.breakHour;
    }

    public int getGridAlpha() {
        return this.gridAlpha;
    }

    public void setGridAlpha(int n) {
        this.gridAlpha = n;
    }
}

