/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarModel;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.TimeLabelPanel;
import bizcal.swing.util.FrameArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import bizcal.util.Tuple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lu.tudor.santec.bizcal.NamedCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DayView
extends CalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(DayView.class);
    private static final I18n I18N = I18nFactory.getI18n(DayView.class);
    public static int PIXELS_PER_HOUR = 80;
    private static final int CAPTION_ROW_HEIGHT0 = 20;
    public static final int PREFERRED_DAY_WIDTH = 10;
    public static final Integer GRID_LEVEL = 1;
    private List<List<FrameArea>> frameAreaCols = new ArrayList<List<FrameArea>>();
    private List<List<Event>> eventColList = new ArrayList<List<Event>>();
    private List<Date> _dateList = new ArrayList<Date>();
    private Map<Tuple, JLabel> timeLines = new HashMap<Tuple, JLabel>();
    private HashMap<Date, Integer> linePositionMap = new HashMap();
    private Map<Integer, Date> minuteMapping = Collections.synchronizedMap(new HashMap());
    private List<JLabel> vLines = new ArrayList<JLabel>();
    private List<JPanel> calBackgrounds = new ArrayList<JPanel>();
    private ColumnHeaderPanel columnHeader;
    private TimeLabelPanel rowHeader;
    private int dayCount;
    private JScrollPane scrollPane;
    private JLayeredPane calPanel;
    private boolean firstRefresh = true;
    private DayViewConfig config;
    private List<JLabel> dateFooters = new ArrayList<JLabel>();
    private Collection<NamedCalendar> activeCalendars = null;
    private Layout layout;
    private NamedCalendar selectedCalendar;
    private JLabel currentTimeLineLabel = new JLabel();
    private JLabel currentTimeLine = new JLabel();
    private JLabel currentTimeLineShadow = new JLabel();

    public DayView(DayViewConfig dayViewConfig) throws Exception {
        this(dayViewConfig, null);
    }

    public DayView(DayViewConfig dayViewConfig, Component component) throws Exception {
        this(dayViewConfig, component, 0);
    }

    public DayView(DayViewConfig dayViewConfig, Component component, Integer n) throws Exception {
        super(dayViewConfig);
        this.config = dayViewConfig;
        this.calPanel = new JLayeredPane();
        this.layout = new Layout(n);
        this.calPanel.setLayout(this.layout);
        CalendarView.ThisMouseListener thisMouseListener = new CalendarView.ThisMouseListener();
        CalendarView.ThisKeyListener thisKeyListener = new CalendarView.ThisKeyListener();
        this.calPanel.addMouseListener(thisMouseListener);
        this.calPanel.addMouseMotionListener(thisMouseListener);
        this.calPanel.addKeyListener(thisKeyListener);
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        if (component == null) {
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        } else {
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", component);
        }
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new ColumnHeaderPanel(dayViewConfig);
        this.columnHeader.setShowExtraDateHeaders(dayViewConfig.isShowExtraDateHeaders());
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
        this.rowHeader = new TimeLabelPanel(dayViewConfig, new TimeOfDay(this.config.getDayStartHour(), 0), new TimeOfDay(this.config.getDayEndHour(), 0), this.config.getNumberOfTimeSlots());
        this.rowHeader.setFooterHeight(this.getFooterHeight());
        this.scrollPane.setRowHeaderView(this.rowHeader.getComponent());
    }

    @Override
    public void refresh0() throws Exception {
        Serializable serializable;
        Object object;
        long l;
        if (this.calPanel == null || this.getModel() == null) {
            return;
        }
        this.dayCount = (int)(this.getModel().getInterval().getDuration() / 86400000L);
        this.calPanel.removeAll();
        this.calPanel.setBackground(Color.WHITE);
        this.rowHeader.setStartEnd(new TimeOfDay(this.config.getDayStartHour(), 0), new TimeOfDay(this.config.getDayEndHour(), 0), this.config.getNumberOfTimeSlots());
        this.rowHeader.setFooterHeight(this.getFooterHeight());
        this.rowHeader.getComponent().revalidate();
        this.frameAreaCols.clear();
        this.eventColList.clear();
        this.timeLines.clear();
        this.linePositionMap.clear();
        this.minuteMapping.clear();
        this.calBackgrounds.clear();
        this.vLines.clear();
        this.dateFooters.clear();
        this.addDraggingComponents(this.calPanel);
        Font font = this.getDayViewConfig().getFont().deriveFont(12.0f);
        font = font.deriveFont(1);
        Color color = this.getDayViewConfig().getLineColor();
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.getDayViewConfig().getGridAlpha());
        for (l = this.getFirstInterval().getStartDate().getTime(); l < this.getFirstInterval().getEndDate().getTime(); l += 3600000L) {
            object = new Date(l);
            int n = this.config.getNumberOfTimeSlots();
            for (int i = 1; i <= n; ++i) {
                serializable = new JLabel();
                serializable.setOpaque(true);
                serializable.setBackground(color2);
                this.calPanel.add((Component)serializable, GRID_LEVEL);
                this.timeLines.put(new Tuple(object, (Object)("" + 60 / n * i)), (JLabel)serializable);
                this.addHorizontalLine((JLabel)serializable);
            }
        }
        if (this.config.isShowDateFooter()) {
            object = new JLabel();
            ((JComponent)object).setBackground(this.getDayViewConfig().getLineColor());
            ((JComponent)object).setOpaque(true);
            this.calPanel.add((Component)object, GRID_LEVEL);
            this.timeLines.put(new Tuple(new Date(l), (Object)"00"), (JLabel)object);
        }
        this.createColumns();
        for (Object e : this.getSelectedCalendars()) {
            bizcal.common.Calendar calendar = (bizcal.common.Calendar)e;
            serializable = new JPanel();
            serializable.setBackground(calendar.getColor());
            this.calBackgrounds.add((JPanel)serializable);
            this.calPanel.add((Component)serializable);
        }
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.setPopupMenuCallback(this.popupMenuCallback);
        this.columnHeader.refresh();
        if (this.firstRefresh) {
            this.initScroll();
        }
        this.firstRefresh = false;
        object = this.getModel();
        Date date = new Date();
        if (object.getInterval().isDayIn(date)) {
            Color color3 = new Color(111, 236, 82);
            serializable = new Color(111, 236, 82, this.getDayViewConfig().getGridAlpha());
            this.currentTimeLineLabel.setOpaque(true);
            this.currentTimeLineLabel.setBackground(color3);
            this.currentTimeLine.setOpaque(true);
            this.currentTimeLine.setBackground(color3);
            this.currentTimeLineShadow.setOpaque(true);
            this.currentTimeLineShadow.setBackground((Color)serializable);
            this.calPanel.add((Component)this.currentTimeLineLabel, GRID_LEVEL);
            this.calPanel.add((Component)this.currentTimeLine, GRID_LEVEL);
            this.calPanel.add((Component)this.currentTimeLineShadow, GRID_LEVEL);
        }
        this.scrollPane.repaint();
        this.rowHeader.getComponent().updateUI();
    }

    private int getColCount() throws Exception {
        return this.dayCount * this.getSelectedCalendars().size();
    }

    private DateInterval getFirstInterval() throws Exception {
        Date date = this.getInterval().getStartDate();
        return new DateInterval(DateUtil.round2Hour(date, this.config.getDayStartHour()), DateUtil.round2Hour(date, this.config.getDayEndHour()));
    }

    private void createColumns() throws Exception {
        DateInterval dateInterval = this.getFirstInterval();
        int n = this.getColCount();
        this.frameAreaHash.clear();
        List<Event> list = null;
        DateInterval dateInterval2 = null;
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            int n2 = i / this.dayCount;
            bizcal.common.Calendar calendar = (bizcal.common.Calendar)this.getSelectedCalendars().get(n2);
            Object object = calendar.getId();
            list = this.broker.getEvents(object);
            Collections.sort(list);
            if (i % this.dayCount == 0) {
                dateInterval2 = new DateInterval(dateInterval);
            }
            if (dateInterval2 != null) {
                this._dateList.add(dateInterval2.getStartDate());
            }
            Calendar calendar2 = DateUtil.newCalendar();
            calendar2.setTime(dateInterval2.getStartDate());
            Color color = this.getDayViewConfig().getLineColor();
            int n3 = this.getDayViewConfig().getGridAlpha() + 50;
            if (n3 > 255) {
                n3 = 255;
            }
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), n3);
            if (i > 0) {
                serializable = new JLabel();
                ((JComponent)serializable).setOpaque(true);
                ((JComponent)serializable).setBackground(color2);
                if (calendar2.get(7) == calendar2.getFirstDayOfWeek()) {
                    ((JComponent)serializable).setBackground(this.getDescriptor().getLineColor2());
                }
                if (this.getSelectedCalendars().size() > 1 && i % this.dayCount == 0) {
                    ((JComponent)serializable).setBackground(this.getDescriptor().getLineColor3());
                }
                this.calPanel.add((Component)serializable, GRID_LEVEL);
                this.vLines.add((JLabel)serializable);
            }
            serializable = new ArrayList();
            this.frameAreaCols.add((List<FrameArea>)((Object)serializable));
            if (object == null) continue;
            DateInterval dateInterval3 = this.getInterval(i % this.dayCount);
            ArrayList<Event> arrayList = new ArrayList<Event>();
            this.eventColList.add(arrayList);
            int n4 = 0;
            if (list == null) {
                list = new ArrayList<Event>();
            }
            for (Event event : list) {
                DateInterval dateInterval4 = new DateInterval(event.getStart(), event.getEnd());
                if (!dateInterval3.overlap(dateInterval4)) continue;
                FrameArea frameArea = this.createFrameArea(object, event);
                frameArea.setBackground(this.config.getPrimaryColor());
                serializable.add(frameArea);
                arrayList.add(event);
                this.calPanel.add((Component)frameArea, (Object)event.getLevel());
                ++n4;
                if (!this.frameAreaHash.containsKey(event)) {
                    this.frameAreaHash.put(event, frameArea);
                    continue;
                }
                ((FrameArea)this.frameAreaHash.get(event)).addChild(frameArea);
            }
            if (this.config.isShowDateFooter()) {
                JLabel jLabel = new JLabel(this.broker.getDateFooter(calendar.getId(), dateInterval2.getStartDate(), arrayList));
                jLabel.setHorizontalAlignment(0);
                this.dateFooters.add(jLabel);
                this.calPanel.add(jLabel);
            }
            if (this.dayCount <= 1) continue;
            dateInterval2 = this.incDay(dateInterval2);
        }
    }

    private int getYPos(Date date, int n) throws Exception {
        long l = date.getTime();
        return this.getYPos(l, n);
    }

    private int getYPos(long l, int n) throws Exception {
        DateInterval dateInterval = this.getInterval(n);
        if (DateUtil.isDaylightSavingDay(dateInterval.getStartDate())) {
            Date date = new Date(l);
            if (DateUtil.isAfterDSTChange(date)) {
                date = DateUtil.moveByMinute(date, 60);
                l = date.getTime();
                l -= dateInterval.getStartDate().getTime();
            }
        } else {
            l -= dateInterval.getStartDate().getTime();
        }
        double d = this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
        double d2 = this.config.getHours() * 3600 * 1000;
        double d3 = l;
        int n2 = (int)(d3 / d2 * d);
        return n2 += this.getCaptionRowHeight();
    }

    @Override
    protected synchronized Date getDate(int n, int n2) throws Exception {
        int n3 = this.getColumn(n);
        int n4 = 0;
        if (this.dayCount != 0) {
            n4 = n3 % this.dayCount;
        }
        DateInterval dateInterval = this.getInterval(n4);
        n2 -= this.getCaptionRowHeight();
        Date date = null;
        if (this.minuteMapping == null || this.minuteMapping.size() == 0) {
            date = new Date();
        }
        while (date == null) {
            date = this.minuteMapping.get(n2);
            if (++n2 < 0) break;
            if (n2 < this.getHeight()) continue;
            n2 = this.getHeight();
        }
        if (date != null) {
            TimeOfDay timeOfDay = DateUtil.getTimeOfDay(date);
            Date date2 = timeOfDay.getDate(dateInterval.getStartDate());
            return date2;
        }
        return null;
    }

    private DateInterval getInterval(int n) throws Exception {
        DateInterval dateInterval = this.getFirstInterval();
        for (int i = 0; i < n; ++i) {
            dateInterval = this.incDay(dateInterval);
        }
        return dateInterval;
    }

    private int getColumn(int n) throws Exception {
        int n2 = this.getWidth() - this.getXOffset();
        double d = (double)(n -= this.getXOffset()) / (double)n2;
        return (int)(d * (double)this.getColCount());
    }

    private Object getCalendarId(int n) throws Exception {
        int n2 = 0;
        if (this.dayCount != 0) {
            n2 = n / this.dayCount;
        }
        bizcal.common.Calendar calendar = (bizcal.common.Calendar)this.getSelectedCalendars().get(n2);
        return calendar.getId();
    }

    @Override
    protected int getXOffset() {
        return 0;
    }

    private int getXPos(int n) throws Exception {
        double d = this.getWidth();
        double d2 = (double)n / (double)this.getColCount();
        return (int)((d -= (double)this.getXOffset()) * d2) + this.getXOffset();
    }

    private int getWidth() {
        return this.calPanel.getWidth();
    }

    private int getHeight() {
        return this.calPanel.getHeight();
    }

    private int getTimeHeight() throws Exception {
        return this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
    }

    private int getFooterHeight() {
        if (this.config.isShowDateFooter()) {
            return PIXELS_PER_HOUR / 2;
        }
        return 0;
    }

    private int findSmallestFrameArea(FrameArea frameArea) {
        if (frameArea.getChildren() == null || frameArea.getChildren().size() < 1) {
            return frameArea.getWidth();
        }
        int n = frameArea.getWidth();
        for (FrameArea frameArea2 : frameArea.getChildren()) {
            if (frameArea2.getWidth() >= n) continue;
            n = frameArea2.getWidth();
        }
        return n;
    }

    @Override
    protected Object getCalendarId(int n, int n2) throws Exception {
        return this.getCalendarId(this.getColumn(n));
    }

    private DayViewConfig getDayViewConfig() throws Exception {
        DayViewConfig dayViewConfig = (DayViewConfig)this.getDescriptor();
        if (dayViewConfig == null) {
            dayViewConfig = new DayViewConfig();
            this.setDescriptor(dayViewConfig);
        }
        return dayViewConfig;
    }

    @Override
    protected int getInitYPos() throws Exception {
        double d = this.getModel().getViewStart().getValue();
        double d2 = d / 8.64E7;
        return (int)(d2 * (double)this.config.getHours() * (double)PIXELS_PER_HOUR);
    }

    private int getPreferredHeight() {
        return this.config.getHours() * PIXELS_PER_HOUR + this.getFooterHeight();
    }

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void initScroll() throws Exception {
        this.scrollPane.getViewport().setViewPosition(new Point(0, this.getInitYPos()));
    }

    @Override
    public void addListener(CalendarListener calendarListener) {
        super.addListener(calendarListener);
        this.columnHeader.addCalendarListener(calendarListener);
    }

    public void setActiveCalendars(Collection<NamedCalendar> collection) {
        this.activeCalendars = collection;
        try {
            this.deselect();
        }
        catch (Exception exception) {
            LOGGER.error("Can't deselect calendar.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setSelectedCalendar(NamedCalendar namedCalendar) {
        this.selectedCalendar = namedCalendar;
        if (this.calPanel != null) {
            this.setSelectedCalendarInCV(namedCalendar);
        }
    }

    public Integer getLayoutMode() {
        return this.layout.getLayoutMode();
    }

    public void setLayoutMode(Integer n) {
        this.layout.setLayoutMode(n);
    }

    public void setCurrentTimeLine() throws Exception {
        CalendarModel calendarModel = this.getModel();
        Date date = new Date();
        if (!calendarModel.getInterval().isDayIn(date)) {
            return;
        }
        double d = DateUtil.round2Hour(new Date(), this.config.getDayStartHour()).getTime();
        double d2 = date.getTime();
        double d3 = this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
        double d4 = this.config.getHours() * 3600 * 1000;
        int n = calendarModel.getInterval().getDiffInDays();
        int n2 = (int)((d2 -= d) / d4 * d3);
        int n3 = this.getWidth() / n;
        try {
            Date date2 = calendarModel.getInterval().getStartDate();
            int n4 = DateUtil.getDiffDay(DateUtil.getDayOfWeek(date2), DateUtil.getDayOfWeek(date));
            this.currentTimeLine.setBounds(0 + --n4 * n3, n2 - 1, n3, 1);
            this.currentTimeLineShadow.setBounds(0 + n4 * n3, n2 - 6, n3, 11);
            this.currentTimeLineLabel.setText(I18N.tr("now"));
            this.currentTimeLineLabel.setFont(new Font("Arial", 1, 9));
            this.currentTimeLineLabel.setBounds(n3 / 2 - 10 + n4 * n3, n2 - 5, 23, 10);
        }
        catch (Exception exception) {
            LOGGER.error("Can't format current timeline.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public class Layout
    implements LayoutManager {
        public static final int DAY_COLUMN_NORMAL = 0;
        public static final int DAY_COLUMN_SEPARATED_BY_CALENDAR = 1;
        public static final int DAY_COLUMN_SEPARATED_BY_MAX_NUMBER_OF_CALENDAR = 2;
        private Integer layoutMode = 0;

        public Layout() {
            this(0);
        }

        public Layout(Integer n) {
            this.layoutMode = n;
        }

        public void setLayoutMode(Integer n) {
            this.layoutMode = n;
        }

        public Integer getLayoutMode() {
            return this.layoutMode;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            try {
                int n = DayView.this.dayCount * DayView.this.getModel().getSelectedCalendars().size() * 10;
                return new Dimension(n, DayView.this.getPreferredHeight());
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(50, 100);
        }

        @Override
        public void layoutContainer(Container container) {
            if (DayView.this.activeCalendars == null) {
                return;
            }
            if (this.layoutMode == 1) {
                this.layoutContainerDayColumnSeparatedByCalendar(container);
                return;
            }
            if (this.layoutMode == 2) {
                this.layoutContainerDayColumnSeparatedByMaxNumberCalendar(container);
                return;
            }
            try {
                int n;
                Object object;
                int n2;
                int n3;
                int n4;
                DayView.this.resetVerticalLines();
                int n5 = DayView.this.getWidth();
                int n6 = DayView.this.getHeight();
                DateInterval dateInterval = DayView.this.getFirstInterval();
                int n7 = DayView.this.getColCount();
                if (n7 == 0) {
                    n7 = 1;
                }
                for (int i = 0; i < DayView.this.eventColList.size(); ++i) {
                    int n8;
                    int n9;
                    Serializable serializable;
                    Event event;
                    int n10;
                    Serializable serializable2;
                    int n11 = i % DayView.this.dayCount;
                    n4 = DayView.this.getXPos(i);
                    n3 = DayView.this.getCaptionRowHeight() - 20;
                    int n12 = DayView.this.getXPos(i + 1) - DayView.this.getXPos(i);
                    int n13 = n3 + 20 + 2;
                    if (n11 == 0 && DayView.this.getSelectedCalendars().size() > 1) {
                        n13 = 0;
                        dateInterval = DayView.this.getFirstInterval();
                    }
                    if (i > 0) {
                        serializable2 = (JLabel)DayView.this.vLines.get(i - 1);
                        int n14 = n6 - n13;
                        ((Component)serializable2).setBounds(n4, n13, 1, n14);
                        DayView.this.addVerticalLine((JLabel)serializable2);
                    }
                    if (DayView.this.config.isShowDateFooter()) {
                        serializable2 = (JLabel)DayView.this.dateFooters.get(i);
                        ((Component)serializable2).setBounds(n4, DayView.this.getTimeHeight(), n12, DayView.this.getFooterHeight());
                    }
                    serializable2 = DayView.this.getInterval(n11);
                    JComponent jComponent = null;
                    int n15 = 0;
                    n2 = 0;
                    List list = (List)DayView.this.eventColList.get(i);
                    List list2 = (List)DayView.this.frameAreaCols.get(i);
                    object = new int[list.size()];
                    for (n10 = 0; n10 < list.size(); ++n10) {
                        int n16;
                        Date date;
                        FrameArea frameArea = (FrameArea)list2.get(n10);
                        event = (Event)list.get(n10);
                        serializable = event.getStart();
                        if (((Date)serializable).before(((DateInterval)serializable2).getStartDate())) {
                            serializable = ((DateInterval)serializable2).getStartDate();
                        }
                        if ((date = event.getEnd()).after(((DateInterval)serializable2).getEndDate())) {
                            date = ((DateInterval)serializable2).getEndDate();
                        }
                        if ((n16 = DayView.this.getYPos((Date)serializable, n11)) < DayView.this.getCaptionRowHeight()) {
                            n16 = DayView.this.getCaptionRowHeight();
                        }
                        n9 = DayView.this.getYPos(date, n11);
                        n8 = n9 - n16;
                        int n17 = n4;
                        frameArea.setBounds(n17, n16, n12, n8);
                        if (!event.isBackground()) {
                            if (jComponent != null) {
                                int n18 = jComponent.getY() + jComponent.getHeight();
                                if (n18 > n16) {
                                    ++n15;
                                    if (n18 < n9) {
                                        jComponent = frameArea;
                                    }
                                } else {
                                    n15 = 0;
                                    jComponent = frameArea;
                                }
                            } else {
                                jComponent = frameArea;
                            }
                            object[n10] = n15;
                            if (n15 <= n2) continue;
                            n2 = n15;
                            continue;
                        }
                        object[n10] = -1;
                    }
                    if (n2 <= 0) continue;
                    n10 = n12;
                    for (int j = 0; j < list2.size(); ++j) {
                        event = (Event)list.get(j);
                        if (event.isBackground()) continue;
                        serializable = (FrameArea)list2.get(j);
                        int n19 = object[j];
                        if (n19 == 0) {
                            n10 = n12;
                        }
                        try {
                            int n20 = 1;
                            while (((Event)list.get(j + n20)).isBackground()) {
                                ++n20;
                            }
                            if (object[j + n20] > 0) {
                                n9 = n19;
                                for (n8 = j + 1; n8 < list2.size(); ++n8) {
                                    if (object[n8] == 0 || object[n8] <= n9) continue;
                                    n9 = object[n8];
                                }
                                n10 = n12 / (n9 + 1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((Component)serializable).setBounds(((JComponent)serializable).getX() + n19 * n10, ((JComponent)serializable).getY(), n10, ((JComponent)serializable).getHeight());
                    }
                }
                for (List list : DayView.this.frameAreaCols) {
                    if (list == null) continue;
                    n4 = 0;
                    n3 = 0;
                    for (FrameArea frameArea : list) {
                        int n21;
                        int n22 = DayView.this.findSmallestFrameArea(frameArea);
                        try {
                            n21 = DayView.this.getBaseFrameArea(frameArea.getEvent()).getWidth();
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        if (n22 > n21) {
                            n22 = n21;
                        }
                        frameArea.setBounds(frameArea.getX(), frameArea.getY(), n22, frameArea.getHeight());
                        if (frameArea.getEvent().get("calendarId") != null) {
                            if (((Boolean)frameArea.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length - 4 - n3);
                                ++n3;
                            }
                            if (frameArea.getEvent().isBackground() && !((Boolean)frameArea.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length / 2 - n3);
                                ++n3;
                            }
                            if (frameArea.getEvent().isBackground()) continue;
                            DayView.this.calPanel.setComponentZOrder(frameArea, list.size() - n4);
                            ++n4;
                            continue;
                        }
                        DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length - 4);
                    }
                }
                if (DayView.this.dayCount > 1) {
                    dateInterval = DayView.this.incDay(dateInterval);
                }
                for (Tuple tuple : DayView.this.timeLines.keySet()) {
                    Date date = (Date)tuple.elementAt(0);
                    n3 = Integer.parseInt((String)tuple.elementAt(1));
                    JLabel jLabel = (JLabel)DayView.this.timeLines.get(tuple);
                    Date date2 = new Date(date.getTime() + (long)n3 * 60L * 1000L);
                    int n23 = DayView.this.getYPos(date2, 0);
                    DayView.this.linePositionMap.put(date2, n23);
                    int n24 = 0;
                    int n25 = 1;
                    if (n3 > 0) {
                        n25 = 1;
                    }
                    jLabel.setBounds(n24, n23, n5, n25);
                }
                ArrayList arrayList = new ArrayList(DayView.this.linePositionMap.keySet());
                DayView.this.linePositionMap.put(DayView.this.getFirstInterval().getStartDate(), 0);
                Collections.sort(arrayList);
                int n26 = DayView.this.config.getNumberOfTimeSlots();
                for (n = 0; n < arrayList.size(); ++n) {
                    Date date = (Date)arrayList.get(n);
                    int n27 = (Integer)DayView.this.linePositionMap.get(date);
                    int n28 = 0;
                    if (n + 1 < arrayList.size()) {
                        Date date3 = (Date)arrayList.get(n + 1);
                        n28 = (Integer)DayView.this.linePositionMap.get(date3);
                    } else {
                        n28 = DayView.this.getTimeHeight();
                    }
                    int n29 = n28 - n27;
                    int n30 = 60 / n26;
                    int n31 = n29 / n30;
                    DayView.this.minuteMapping.put(n27, date);
                    n2 = DateUtil.getMinuteOfHour(date);
                    boolean bl = DateUtil.isDaylightSavingDay(date);
                    for (int i = 1; i < n30; ++i) {
                        object = DateUtil.round2Minute(date, n2 + i);
                        if (!bl || DateUtil.isAfterDSTChange((Date)object)) {
                            // empty if block
                        }
                        DayView.this.minuteMapping.put(n27 + i * n31, object);
                    }
                }
                for (n = 0; n < DayView.this.calBackgrounds.size(); ++n) {
                    int n32 = DayView.this.getXPos(n * DayView.this.dayCount);
                    int n33 = DayView.this.getXPos((n + 1) * DayView.this.dayCount);
                    JPanel jPanel = (JPanel)DayView.this.calBackgrounds.get(n);
                    jPanel.setBounds(n32, DayView.this.getCaptionRowHeight(), n33 - n32, DayView.this.getHeight());
                }
                DayView.this.setCurrentTimeLine();
                for (JLabel jLabel : DayView.this.timeLines.values()) {
                    try {
                        DayView.this.calPanel.setComponentZOrder(jLabel, DayView.this.calPanel.getComponents().length - 2);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't put timelines in background.");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void layoutContainerDayColumnSeparatedByCalendar(Container container) {
            try {
                int n;
                Comparable<Integer> comparable;
                int n2;
                int n3;
                int n4;
                DayView.this.resetVerticalLines();
                int n5 = DayView.this.getWidth();
                int n6 = DayView.this.getHeight();
                DateInterval dateInterval = DayView.this.getFirstInterval();
                int n7 = DayView.this.getColCount();
                if (n7 == 0) {
                    n7 = 1;
                }
                for (int i = 0; i < DayView.this.eventColList.size(); ++i) {
                    int n8;
                    int n9;
                    Object object;
                    int n10;
                    Integer[] integerArray;
                    Serializable serializable2;
                    int n11 = i % DayView.this.dayCount;
                    n4 = DayView.this.getXPos(i);
                    n3 = DayView.this.getCaptionRowHeight() - 20;
                    int n12 = DayView.this.getXPos(i + 1) - DayView.this.getXPos(i);
                    int n13 = n3 + 20 + 2;
                    if (n11 == 0 && DayView.this.getSelectedCalendars().size() > 1) {
                        n13 = 0;
                        dateInterval = DayView.this.getFirstInterval();
                    }
                    if (i > 0) {
                        serializable2 = (JLabel)DayView.this.vLines.get(i - 1);
                        n2 = n6 - n13;
                        ((Component)serializable2).setBounds(n4, n13, 1, n2);
                        DayView.this.addVerticalLine((JLabel)serializable2);
                    }
                    if (DayView.this.config.isShowDateFooter()) {
                        serializable2 = (JLabel)DayView.this.dateFooters.get(i);
                        ((Component)serializable2).setBounds(n4, DayView.this.getTimeHeight(), n12, DayView.this.getFooterHeight());
                    }
                    serializable2 = DayView.this.getInterval(n11);
                    n2 = 0;
                    List list = (List)DayView.this.eventColList.get(i);
                    List list2 = (List)DayView.this.frameAreaCols.get(i);
                    int[] nArray = new int[list.size()];
                    HashSet<Object> hashSet = new HashSet<Object>();
                    for (int j = 0; j < list.size(); ++j) {
                        integerArray = (Integer[])list.get(j);
                        if (integerArray.get("calendarId") == null || ((Boolean)integerArray.get("calendarIsBackground")).booleanValue()) continue;
                        hashSet.add(integerArray.get("calendarId"));
                    }
                    comparable = hashSet.size();
                    integerArray = new Integer[((Integer)comparable).intValue()];
                    int n14 = 0;
                    for (Object object2 : DayView.this.activeCalendars) {
                        for (Integer n15 : hashSet) {
                            if (((NamedCalendar)object2).getId() != n15) continue;
                            integerArray[n14] = ((NamedCalendar)object2).getId();
                            ++n14;
                        }
                    }
                    for (n10 = 0; n10 < list.size(); ++n10) {
                        void var24_63;
                        int n16;
                        Date date;
                        Object object2;
                        object2 = (FrameArea)list2.get(n10);
                        object = (Event)list.get(n10);
                        Date date2 = ((Event)object).getStart();
                        if (date2.before(((DateInterval)serializable2).getStartDate())) {
                            Date date3 = ((DateInterval)serializable2).getStartDate();
                        }
                        if ((date = ((Event)object).getEnd()).after(((DateInterval)serializable2).getEndDate())) {
                            date = ((DateInterval)serializable2).getEndDate();
                        }
                        if ((n16 = DayView.this.getYPos((Date)var24_63, n11)) < DayView.this.getCaptionRowHeight()) {
                            n16 = DayView.this.getCaptionRowHeight();
                        }
                        n9 = DayView.this.getYPos(date, n11);
                        n8 = n9 - n16;
                        int n17 = n4;
                        for (int j = 0; j < (Integer)comparable; ++j) {
                            if (((Event)object).get("calendarId") != integerArray[j]) continue;
                            n17 += j * (n12 / (Integer)comparable);
                        }
                        if (((Event)object).get("calendarId") != null && !((Boolean)((Event)object).get("calendarIsBackground")).booleanValue()) {
                            ((Component)object2).setBounds(n17, n16, n12 / (Integer)comparable, n8);
                        } else {
                            ((Component)object2).setBounds(n4, n16, n12, n8);
                        }
                        nArray[n10] = -1;
                    }
                    if (n2 <= 0) continue;
                    n10 = n12;
                    for (int j = 0; j < list2.size(); ++j) {
                        object = (Event)list.get(j);
                        if (((Event)object).isBackground()) continue;
                        FrameArea frameArea = (FrameArea)list2.get(j);
                        int n18 = nArray[j];
                        if (n18 == 0) {
                            n10 = n12;
                        }
                        try {
                            int n19 = 1;
                            while (((Event)list.get(j + n19)).isBackground()) {
                                ++n19;
                            }
                            if (nArray[j + n19] > 0) {
                                n9 = n18;
                                for (n8 = j + 1; n8 < list2.size(); ++n8) {
                                    if (nArray[n8] == 0 || nArray[n8] <= n9) continue;
                                    n9 = nArray[n8];
                                }
                                n10 = n12 / (n9 + 1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        frameArea.setBounds(frameArea.getX() + n18 * n10, frameArea.getY(), n10, frameArea.getHeight());
                    }
                }
                for (List list : DayView.this.frameAreaCols) {
                    if (list == null) continue;
                    n4 = 0;
                    n3 = 0;
                    for (FrameArea frameArea : list) {
                        int n19 = DayView.this.findSmallestFrameArea(frameArea);
                        try {
                            n2 = DayView.this.getBaseFrameArea(frameArea.getEvent()).getWidth();
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        if (n19 > n2) {
                            n19 = n2;
                        }
                        frameArea.setBounds(frameArea.getX(), frameArea.getY(), n19, frameArea.getHeight());
                        if (frameArea.getEvent().get("calendarId") != null) {
                            if (((Boolean)frameArea.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length - 5 - n3);
                                ++n3;
                            }
                            if (frameArea.getEvent().isBackground() && !((Boolean)frameArea.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length / 2 - n3);
                                ++n3;
                            }
                            if (frameArea.getEvent().isBackground()) continue;
                            DayView.this.calPanel.setComponentZOrder(frameArea, list.size() - n4);
                            ++n4;
                            continue;
                        }
                        DayView.this.calPanel.setComponentZOrder(frameArea, DayView.this.calPanel.getComponents().length - 4);
                    }
                }
                if (DayView.this.dayCount > 1) {
                    dateInterval = DayView.this.incDay(dateInterval);
                }
                for (Tuple tuple : DayView.this.timeLines.keySet()) {
                    Date date = (Date)tuple.elementAt(0);
                    n3 = Integer.parseInt((String)tuple.elementAt(1));
                    JLabel jLabel = (JLabel)DayView.this.timeLines.get(tuple);
                    Date date2 = new Date(date.getTime() + (long)n3 * 60L * 1000L);
                    int n20 = DayView.this.getYPos(date2, 0);
                    DayView.this.linePositionMap.put(date2, n20);
                    n2 = 0;
                    int n21 = 1;
                    if (n3 > 0) {
                        n21 = 1;
                    }
                    jLabel.setBounds(n2, n20, n5, n21);
                }
                ArrayList arrayList = new ArrayList(DayView.this.linePositionMap.keySet());
                DayView.this.linePositionMap.put(DayView.this.getFirstInterval().getStartDate(), 0);
                Collections.sort(arrayList);
                int n22 = DayView.this.config.getNumberOfTimeSlots();
                for (n = 0; n < arrayList.size(); ++n) {
                    Date date = (Date)arrayList.get(n);
                    int n23 = (Integer)DayView.this.linePositionMap.get(date);
                    int n24 = 0;
                    if (n + 1 < arrayList.size()) {
                        Date date3 = (Date)arrayList.get(n + 1);
                        n24 = (Integer)DayView.this.linePositionMap.get(date3);
                    } else {
                        n24 = DayView.this.getTimeHeight();
                    }
                    int n25 = n24 - n23;
                    n2 = 60 / n22;
                    int n26 = n25 / n2;
                    DayView.this.minuteMapping.put(n23, date);
                    int n27 = DateUtil.getMinuteOfHour(date);
                    boolean bl = DateUtil.isDaylightSavingDay(date);
                    for (int i = 1; i < n2; ++i) {
                        comparable = DateUtil.round2Minute(date, n27 + i);
                        if (bl && !DateUtil.isAfterDSTChange((Date)comparable)) continue;
                    }
                }
                for (n = 0; n < DayView.this.calBackgrounds.size(); ++n) {
                    int n28 = DayView.this.getXPos(n * DayView.this.dayCount);
                    int n29 = DayView.this.getXPos((n + 1) * DayView.this.dayCount);
                    JPanel jPanel = (JPanel)DayView.this.calBackgrounds.get(n);
                    jPanel.setBounds(n28, DayView.this.getCaptionRowHeight(), n29 - n28, DayView.this.getHeight());
                }
                DayView.this.setCurrentTimeLine();
                for (JLabel jLabel : DayView.this.timeLines.values()) {
                    try {
                        DayView.this.calPanel.setComponentZOrder(jLabel, DayView.this.calPanel.getComponents().length - 2);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't put timelines in background.");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        public void layoutContainerDayColumnSeparatedByMaxNumberCalendar(Container container) {
        }
    }
}

