/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GradientArea
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final String TOP_BOTTOM = "TOP_BOTTOM";
    public static final String BOTTOM_TOP = "BOTTOM_TOP";
    public static final String LEFT_RIGHT = "LEFT_RIGHT";
    public static final String RIGHT_LEFT = "RIGHT_LEFT";
    public static final String TOPLEFT_BOTTOMRIGHT = "TOPLEFT_BOTTOMRIGHT";
    public static final String IN_OUT = "IN_OUT";
    public static final String BORDER_RECTANGLE = "BORDER_RECTANGLE";
    public static final String BORDER_TOP = "BORDER_TOP";
    private String itsFadeDirection;
    private double itsGradientLength;
    private Color itsStartColor;
    private Color itsEndColor;
    private float itsBorderWidth;
    private Color itsBorderColor;
    private boolean itsBorder;
    private String itsBorderType;
    private JLabel _label;

    public GradientArea() {
        this(TOP_BOTTOM, new Color(255, 255, 255), new Color(245, 245, 245));
    }

    public GradientArea(String string, Color color, Color color2) {
        this.itsFadeDirection = string;
        this.itsStartColor = color;
        this.itsEndColor = color2;
        this.itsBorderWidth = 4.0f;
        this.itsBorderColor = this.itsEndColor;
        this.itsGradientLength = 1.0;
        this.itsBorder = true;
        this.itsBorderType = BORDER_RECTANGLE;
    }

    public void setGradientLength(double d) {
        this.itsGradientLength = d;
    }

    public void setBorderWidth(float f) {
        this.itsBorderWidth = f;
    }

    public void setBorderColor(Color color) {
        this.itsBorderColor = color;
    }

    public void setBorder(boolean bl) {
        this.itsBorder = bl;
    }

    public void setColors(Color color, Color color2) {
        this.itsStartColor = color;
        this.itsEndColor = color2;
    }

    public void setBorderType(String string) {
        this.itsBorderType = string;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        GradientPaint gradientPaint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.itsFadeDirection.equals(TOP_BOTTOM)) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.itsStartColor, 0.0f, (int)((double)n2 * this.itsGradientLength), this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
        }
        if (this.itsFadeDirection.equals(BOTTOM_TOP)) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.itsEndColor, 0.0f, (int)((double)n2 * this.itsGradientLength), this.itsStartColor);
            graphics2D.setPaint(gradientPaint);
        }
        if (this.itsFadeDirection.equals(LEFT_RIGHT)) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.itsStartColor, (int)((double)n * this.itsGradientLength), 0.0f, this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
        }
        if (this.itsFadeDirection.equals(RIGHT_LEFT)) {
            gradientPaint = new GradientPaint((int)((double)n * this.itsGradientLength), 0.0f, this.itsStartColor, 0.0f, 0.0f, this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
        }
        if (this.itsFadeDirection.equals(TOPLEFT_BOTTOMRIGHT)) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, this.itsStartColor, (int)((double)n * this.itsGradientLength), (int)((double)n2 * this.itsGradientLength), this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
        }
        if (this.itsFadeDirection.equals(IN_OUT)) {
            gradientPaint = new GradientPaint(0.0f, 10.0f, Color.RED, (int)((double)n * this.itsGradientLength), 0.0f, this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
            gradientPaint = new GradientPaint(0.0f, 0.0f, Color.BLUE, (int)((double)n * this.itsGradientLength), 0.0f, this.itsEndColor);
            graphics2D.setPaint(gradientPaint);
        }
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
        if (this.itsBorder) {
            graphics2D.setStroke(new BasicStroke(this.itsBorderWidth));
            graphics2D.setPaint(this.itsBorderColor);
            if (this.itsBorderType.equals(BORDER_RECTANGLE)) {
                graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, n - 1, n2 - 1));
            }
            if (this.itsBorderType.equals(BORDER_TOP)) {
                graphics2D.draw(new Line2D.Double(new Point(0, 0), new Point(n, 0)));
            }
        }
        super.paintComponent(graphics2D);
    }

    public void setText(String string, boolean bl) {
        this.initLabel();
        this._label.setText(string);
        if (bl) {
            this._label.setHorizontalAlignment(0);
        }
    }

    private void initLabel() {
        if (this._label == null) {
            this._label = new JLabel();
            this.addComponentListener(new ThisComponentListner());
            this.add(this._label);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.initLabel();
        this._label.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        this.initLabel();
        this._label.setForeground(color);
        super.setForeground(color);
    }

    public void setHorizontalAlignment(int n) {
        this._label.setHorizontalAlignment(n);
    }

    public ComponentListener getComponentListener() {
        return new ThisComponentListner();
    }

    private class ThisComponentListner
    extends ComponentAdapter {
        private ThisComponentListner() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GradientArea.this._label.setBounds(10, 0, componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
        }
    }
}

