/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.BizcalException;
import bizcal.util.NullSafe;
import java.io.Serializable;

public class Interval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Comparable start;
    private Comparable end;
    private boolean includeStart = true;
    private boolean includeEnd = false;

    public Interval(Comparable comparable, Comparable comparable2) {
        this.start = comparable;
        this.end = comparable2;
    }

    protected Interval() {
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setStart(Comparable comparable) {
        this.start = comparable;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public void setEnd(Comparable comparable) {
        this.end = comparable;
    }

    public boolean isIncludeEnd() {
        return this.includeEnd;
    }

    public void setIncludeEnd(boolean bl) {
        this.includeEnd = bl;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public void setIncludeStart(boolean bl) {
        this.includeStart = bl;
    }

    public boolean contains(Comparable comparable) {
        if (this.start != null) {
            if (comparable.compareTo(this.getStart()) < 0) {
                return false;
            }
            if (!this.includeStart && comparable.compareTo(this.getStart()) == 0) {
                return false;
            }
        }
        if (this.end != null) {
            if (comparable.compareTo(this.getEnd()) > 0) {
                return false;
            }
            if (!this.includeEnd && comparable.compareTo(this.getEnd()) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Interval interval) {
        int n;
        if (this.start != null) {
            n = interval.getStart().compareTo(this.start);
            if (n < 0) {
                return false;
            }
            if (n == 0 && !this.includeStart && interval.isIncludeStart()) {
                return false;
            }
        }
        if (this.end != null) {
            if (interval.getEnd() == null) {
                return false;
            }
            n = interval.getEnd().compareTo(this.end);
            if (n > 0) {
                return false;
            }
            if (n == 0 && !this.includeEnd && interval.isIncludeEnd()) {
                return false;
            }
        }
        return true;
    }

    public boolean overlap(Interval interval) {
        Interval interval2 = new Interval(this.getStart(), this.getEnd());
        interval2.setIncludeStart(false);
        interval2.setIncludeEnd(false);
        if (interval2.contains(interval.getStart())) {
            return true;
        }
        if (interval2.contains(interval.getEnd())) {
            return true;
        }
        if (interval.contains(this.getStart()) && interval.contains(this.getEnd())) {
            return true;
        }
        return NullSafe.equals(interval.getStart(), this.getStart()) && NullSafe.equals(interval.getEnd(), this.getEnd());
    }

    public Interval intersection(Interval interval) {
        Comparable comparable = this.getStart();
        Comparable comparable2 = this.getEnd();
        if (interval.getStart().compareTo(comparable) > 0) {
            comparable = interval.getStart();
        }
        if (interval.getEnd().compareTo(comparable2) < 0) {
            comparable2 = interval.getEnd();
        }
        if (comparable.compareTo(comparable2) > 0) {
            return null;
        }
        return new Interval(comparable, comparable2);
    }

    public Interval union(Interval interval) {
        Comparable comparable = this.getStart();
        Comparable comparable2 = this.getEnd();
        if (interval.getStart().compareTo(comparable) < 0) {
            comparable = interval.getStart();
        }
        if (interval.getEnd().compareTo(comparable2) > 0) {
            comparable2 = interval.getEnd();
        }
        return new Interval(comparable, comparable2);
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof Interval) {
                Interval interval = (Interval)object;
                return NullSafe.equals(this.getStart(), interval.getStart()) && NullSafe.equals(this.getEnd(), interval.getEnd());
            }
            return false;
        }
        catch (Exception exception) {
            throw BizcalException.create(exception);
        }
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getStart() != null) {
                stringBuffer.append(this.getStart().toString());
            }
            stringBuffer.append(" - ");
            if (this.getEnd() != null) {
                stringBuffer.append(this.getEnd().toString());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw BizcalException.create(exception);
        }
    }
}

