/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;

public class CheckBoxPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBox;
    private JToggleButton button;
    private Color bgColor;
    private ColorBoxIcon icon;
    private Vector<ActionListener> listeners = new Vector();

    public CheckBoxPanel(String string, Color color, ButtonGroup buttonGroup) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.checkBox.requestFocus(false);
        this.add((Component)this.checkBox, "East");
        this.button = new JToggleButton(string);
        buttonGroup.add(this.button);
        this.button.addActionListener(this);
        this.icon = new ColorBoxIcon(color);
        this.button.setIcon(this.icon);
        this.button.setHorizontalAlignment(2);
        this.add((Component)this.button, "Center");
    }

    public void setActiv(boolean bl) {
        this.checkBox.setSelected(bl);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.checkBox.addActionListener(actionListener);
        this.listeners.add(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.checkBox.removeActionListener(actionListener);
        this.listeners.remove(actionListener);
    }

    public boolean isActiv() {
        return this.checkBox.isSelected();
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    public void setSelected(boolean bl) {
        this.button.setSelected(bl);
        this.asynchInformActionListeners();
    }

    public void setColor(Color color) {
        this.bgColor = color;
        this.icon.setColor(this.bgColor);
        this.button.updateUI();
    }

    public void setText(String string) {
        this.button.setText(string);
    }

    private synchronized void asynchInformActionListeners() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "selection changed"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.button.equals(actionEvent.getSource())) {
            this.asynchInformActionListeners();
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.button.addMouseListener(mouseListener);
    }

    public class ColorBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color color;
        private static final double FAQ = 1.5;
        private static final long serialVersionUID = 1L;

        public ColorBoxIcon(Color color) {
            this.color = color;
        }

        protected int getControlSize() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.setColor(this.color);
            graphics.fillRect(n, n2 + 1, (int)((double)(n3 - 1) * 1.5), n3 - 1);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n, n2 + 1, (int)((double)(n3 - 1) * 1.5), n3 - 1);
        }

        @Override
        public int getIconWidth() {
            return (int)((double)this.getControlSize() * 1.5);
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

