/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.openestate.io.core.CsvParser;
import org.openestate.io.core.CsvPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CsvFormat<Parser extends CsvParser, Printer extends CsvPrinter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvFormat.class);
    private final CSVFormat format;

    protected CsvFormat(CSVFormat cSVFormat) {
        this.format = cSVFormat;
    }

    public abstract String getEncoding();

    public final CSVFormat getFormat() {
        return this.format;
    }

    protected abstract Parser newParser(CSVParser var1);

    protected abstract Printer newPrinter(CSVPrinter var1);

    public final Parser parse(String string) throws IOException {
        return this.parse(new StringReader(string));
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="The stream is closed later together with the parser.")
    public final Parser parse(File file) throws IOException {
        return this.parse(new FileInputStream(file));
    }

    public final Parser parse(InputStream inputStream) throws IOException {
        return this.parse(new InputStreamReader(inputStream, this.getEncoding()));
    }

    public Parser parse(Reader reader) throws IOException {
        return this.newParser(new CSVParser(reader, this.getFormat()));
    }

    public final Printer print(StringBuffer stringBuffer) throws IOException {
        return this.print((Appendable)stringBuffer);
    }

    public final Printer print(StringBuilder stringBuilder) throws IOException {
        return this.print((Appendable)stringBuilder);
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="The stream is closed later together with the printer.")
    public final Printer print(File file) throws IOException {
        return this.print(new FileOutputStream(file));
    }

    public final Printer print(OutputStream outputStream) throws IOException {
        return this.print(new OutputStreamWriter(outputStream, this.getEncoding()));
    }

    public final Printer print(Writer writer) throws IOException {
        return this.print((Appendable)writer);
    }

    protected Printer print(Appendable appendable) throws IOException {
        return this.newPrinter(new CSVPrinter(appendable, this.getFormat()));
    }
}

