/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberUtils.class);

    public static boolean isNumeric(String string, Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols;
        if (string == null) {
            return false;
        }
        int n = 0;
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols = locale != null ? DecimalFormatSymbols.getInstance(locale) : DecimalFormatSymbols.getInstance();
        if (string.startsWith("+") || string.startsWith("-")) {
            ++n;
        }
        boolean bl = false;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == decimalFormatSymbols.getDecimalSeparator() && !bl) {
                bl = true;
                continue;
            }
            if (c == decimalFormatSymbols.getGroupingSeparator() && !bl || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static Number parseNumber(String string) throws NumberFormatException {
        return NumberUtils.parseNumber(string, false, new Locale[0]);
    }

    public static Number parseNumber(String string, Locale ... localeArray) throws NumberFormatException {
        return NumberUtils.parseNumber(string, false, localeArray);
    }

    public static Number parseNumber(String string, boolean bl, Locale ... localeArray) throws NumberFormatException {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        if (string.startsWith("+")) {
            string = StringUtils.trimToNull((String)string.substring(1));
        }
        string = StringUtils.replace((String)string, (String)" ", (String)"");
        if (ArrayUtils.isEmpty((Object[])localeArray)) {
            localeArray = new Locale[]{Locale.getDefault()};
        }
        for (Locale locale : localeArray) {
            if (!NumberUtils.isNumeric(string, locale)) continue;
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            try {
                numberFormat.setMinimumFractionDigits(0);
                numberFormat.setParseIntegerOnly(bl);
                numberFormat.setGroupingUsed(string.indexOf(DecimalFormatSymbols.getInstance(locale).getGroupingSeparator()) > -1);
                return numberFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("The provided value '" + string + "' is not numeric!");
    }

    public static String printNumber(Number number, int n, int n2) {
        return NumberUtils.printNumber(number, n, n2, null);
    }

    public static String printNumber(Number number, int n, int n2, Locale locale) {
        if (number == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale != null ? locale : Locale.ENGLISH);
        numberFormat.setMaximumIntegerDigits(n);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(number);
    }
}

