/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);

    private XmlUtils() {
    }

    public static void clean(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node2 = nodeList.item(i);
            short s = node2.getNodeType();
            if (s == 1) {
                XmlUtils.clean(node2);
                continue;
            }
            if (s == 8) {
                node.removeChild(node2);
                continue;
            }
            if (s != 3) continue;
            String string = StringUtils.trimToNull((String)node2.getNodeValue());
            if (string == null) {
                node.removeChild(node2);
                continue;
            }
            node2.setNodeValue(string);
        }
    }

    public static int countNodes(String string, Document document) throws JaxenException {
        return XmlUtils.countNodes(string, document, document);
    }

    public static int countNodes(String string, Document document, Object object) throws JaxenException {
        return XmlUtils.newXPath(string, document).selectNodes(object).size();
    }

    public static Element getRootElement(Document document) {
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XmlUtils.newDocument(true);
    }

    public static Document newDocument(boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static Document newDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtils.newDocument(string, true);
    }

    public static Document newDocument(String string, boolean bl) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtils.newDocument(new InputSource(new StringReader(string)), bl);
    }

    public static Document newDocument(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtils.newDocument(inputSource, true);
    }

    public static Document newDocument(InputSource inputSource, boolean bl) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static Document newDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtils.newDocument(inputStream, true);
    }

    public static Document newDocument(InputStream inputStream, boolean bl) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    public static Document newDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtils.newDocument(file, true);
    }

    public static Document newDocument(File file, boolean bl) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static XPath newXPath(String string) throws JaxenException {
        return XmlUtils.newXPath(string, null, null);
    }

    public static XPath newXPath(String string, Document document) throws JaxenException {
        return XmlUtils.newXPath(string, document, "io");
    }

    public static XPath newXPath(String string, Document document, String string2) throws JaxenException {
        DOMXPath dOMXPath = new DOMXPath(string);
        if (document != null && string2 != null) {
            Element element = XmlUtils.getRootElement(document);
            String string3 = StringUtils.trimToEmpty((String)element.getNamespaceURI());
            dOMXPath.addNamespace(string2, string3);
        }
        return dOMXPath;
    }

    public static Calendar parseDate(String string) {
        return XmlUtils.parseDate(string, true);
    }

    private static Calendar parseDate(String string, boolean bl) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDate((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Date date = DateUtils.parseDateStrictly((String)string, (String[])new String[]{"dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-D", "MM/yyyy", "MMM yyyy", "MMMMM yyyy", "yyyy"});
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
                if (bl) {
                    try {
                        return XmlUtils.parseDateTime(string, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Can't parse date value '" + string + "'!");
            }
        }
    }

    public static Calendar parseDateTime(String string) {
        return XmlUtils.parseDateTime(string, true);
    }

    private static Calendar parseDateTime(String string, boolean bl) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDateTime((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Date date = DateUtils.parseDateStrictly((String)string, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"});
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
                if (bl) {
                    try {
                        return XmlUtils.parseDate(string, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Can't parse date-time value '" + string + "'!");
            }
        }
    }

    public static void printNodes(Document document) {
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            XmlUtils.printNode((Element)node);
        }
    }

    public static void printNode(Element element) {
        XmlUtils.printNode(element, 0);
    }

    private static void printNode(Element element, int n) {
        String string = n > 0 ? StringUtils.repeat((String)">", (int)n) + " " : "";
        LOGGER.debug(string + "<" + element.getTagName() + "> / " + element.getNamespaceURI() + " / " + element.getPrefix());
        string = StringUtils.repeat((String)">", (int)(n + 1)) + " ";
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            LOGGER.debug(string + "@" + attr.getName() + " / " + attr.getNamespaceURI() + " / " + attr.getPrefix());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            XmlUtils.printNode((Element)node, n + 1);
        }
    }

    public static void replaceNamespace(Document document, String string) {
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XmlUtils.replaceNamespace(document, nodeList.item(i), string);
        }
    }

    public static void replaceNamespace(Document document, Node node, String string) {
        if (node instanceof Attr) {
            document.renameNode(node, string, node.getLocalName());
        } else if (node instanceof Element) {
            document.renameNode(node, string, node.getLocalName());
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XmlUtils.replaceNamespace(document, nodeList.item(i), string);
            }
        }
    }

    public static void replaceTextWithCData(Document document) {
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XmlUtils.replaceTextWithCData(document, nodeList.item(i));
        }
    }

    public static void replaceTextWithCData(Document document, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            CDATASection cDATASection = document.createCDATASection(text.getTextContent());
            Element element = (Element)text.getParentNode();
            element.replaceChild(cDATASection, text);
        } else if (node instanceof Element) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XmlUtils.replaceTextWithCData(document, nodeList.item(i));
            }
        }
    }

    public static void write(Document document, File file) throws TransformerException, IOException {
        XmlUtils.write(document, file, true);
    }

    public static void write(Document document, File file, boolean bl) throws TransformerException, IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            XmlUtils.write(document, fileOutputStream, bl);
        }
    }

    public static void write(Document document, OutputStream outputStream) throws TransformerException {
        XmlUtils.write(document, outputStream, true);
    }

    public static void write(Document document, OutputStream outputStream, boolean bl) throws TransformerException {
        XmlUtils.clean(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", bl ? "yes" : "no");
        if (bl) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
    }

    public static void write(Document document, Writer writer) throws TransformerException {
        XmlUtils.write(document, writer, true);
    }

    public static void write(Document document, Writer writer, boolean bl) throws TransformerException {
        XmlUtils.clean(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", bl ? "yes" : "no");
        if (bl) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }
}

