/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.viewer.wms;

import org.jxmapviewer.viewer.util.MercatorUtils;

public class WMSService {
    private String baseUrl;
    private String layer;

    public WMSService() {
        this.setLayer("BMNG");
        this.setBaseUrl("http://wms.jpl.nasa.gov/wms.cgi?");
    }

    public WMSService(String baseUrl, String layer) {
        this.baseUrl = baseUrl;
        this.layer = layer;
    }

    public String toWMSURL(int x, int y, int zoom, int tileSize) {
        String format = "image/jpeg";
        String styles = "";
        String srs = "EPSG:4326";
        int ts = tileSize;
        int circumference = this.widthOfWorldInPixels(zoom, tileSize);
        double radius = (double)circumference / (Math.PI * 2);
        double ulx = MercatorUtils.xToLong(x * ts, radius);
        double uly = MercatorUtils.yToLat(y * ts, radius);
        double lrx = MercatorUtils.xToLong((x + 1) * ts, radius);
        double lry = MercatorUtils.yToLat((y + 1) * ts, radius);
        String bbox = ulx + "," + uly + "," + lrx + "," + lry;
        String url = this.getBaseUrl() + "version=1.1.1&request=GetMap&Layers=" + this.layer + "&format=" + format + "&BBOX=" + bbox + "&width=" + ts + "&height=" + ts + "&SRS=" + srs + "&Styles=" + styles + "";
        return url;
    }

    private int widthOfWorldInPixels(int zoom, int TILE_SIZE) {
        int tiles = (int)Math.pow(2.0, zoom);
        int circumference = TILE_SIZE * tiles;
        return circumference;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

