/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.trovit;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.core.XmlDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.Trovit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TrovitDocument
extends XmlDocument<Trovit> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitDocument.class);

    public TrovitDocument(Document document) {
        super(document);
        if (!TrovitDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
        this.setTextWrittenAsCDATA(true);
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "trovit".equals(element.getLocalName());
    }

    public static TrovitDocument newDocument() throws ParserConfigurationException, JAXBException {
        return TrovitDocument.newDocument(TrovitUtils.getFactory().createTrovit());
    }

    public static TrovitDocument newDocument(Trovit trovit) throws ParserConfigurationException, JAXBException {
        Document document = XmlUtils.newDocument();
        TrovitUtils.createMarshaller("UTF-8", true).marshal((Object)trovit, (Node)document);
        return new TrovitDocument(document);
    }

    public Trovit toObject() throws JAXBException {
        return (Trovit)TrovitUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

