/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvFormat;
import org.openestate.io.core.LocaleUtils;
import org.openestate.io.core.NumberUtils;
import org.openestate.io.is24_csv.Is24CsvParser;
import org.openestate.io.is24_csv.Is24CsvPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvFormat
extends CsvFormat<Is24CsvParser, Is24CsvPrinter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvFormat.class);
    public static final String VERSION = "1.4.0.4";
    public static final String ENCODING = "CP1252";
    public static final String RECORD_SEPARATOR = "\r\n";

    public Is24CsvFormat() {
        super(CSVFormat.newFormat((char)'|').withRecordSeparator(RECORD_SEPARATOR).withNullString(""));
    }

    public static String getCountryCode(String string) {
        return LocaleUtils.getCountryISO3((String)string);
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public String getEncoding() {
        return ENCODING;
    }

    protected Is24CsvParser newParser(CSVParser cSVParser) {
        return new Is24CsvParser(cSVParser);
    }

    protected Is24CsvPrinter newPrinter(CSVPrinter cSVPrinter) {
        return new Is24CsvPrinter(cSVPrinter);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="This behaviour is intended.")
    public static Boolean parseBoolean(String string) {
        if ("J".equalsIgnoreCase(string = StringUtils.trimToNull((String)string))) {
            return true;
        }
        if ("N".equalsIgnoreCase(string)) {
            return false;
        }
        return null;
    }

    public static Date parseDate(String string) throws ParseException {
        return (string = StringUtils.trimToNull((String)string)) != null ? Is24CsvFormat.getDateFormat().parse(string) : null;
    }

    public static Calendar parseDateAsCalendar(String string) throws ParseException {
        Date date = Is24CsvFormat.parseDate(string);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static BigDecimal parseDecimal(String string) throws NumberFormatException {
        Number number = Is24CsvFormat.parseNumber(string, false);
        return number != null ? BigDecimal.valueOf(number.doubleValue()) : null;
    }

    public static Integer parseInteger(String string) throws NumberFormatException {
        Number number = Is24CsvFormat.parseNumber(string, false);
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static Long parseLong(String string) throws NumberFormatException {
        Number number = Is24CsvFormat.parseNumber(string, false);
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public static Number parseNumber(String string) throws NumberFormatException {
        return Is24CsvFormat.parseNumber(string, false);
    }

    public static Number parseNumber(String string, boolean bl) throws NumberFormatException {
        return NumberUtils.parseNumber((String)string, (boolean)bl, (Locale[])new Locale[]{Locale.GERMANY, Locale.ENGLISH});
    }

    public static String printBoolean(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "J";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "N";
        }
        return "";
    }

    public static String printDate(Calendar calendar) {
        return Is24CsvFormat.printDate(calendar != null ? calendar.getTime() : null);
    }

    public static String printDate(Date date) {
        return date != null ? Is24CsvFormat.getDateFormat().format(date) : null;
    }

    public static String printNumber(Number number, int n) {
        return Is24CsvFormat.printNumber(number, n, 0);
    }

    public static String printNumber(Number number, int n, int n2) {
        return NumberUtils.printNumber((Number)number, (int)n, (int)n2, (Locale)Locale.GERMANY);
    }

    public static String printString(String string) {
        return Is24CsvFormat.printString(string, 0);
    }

    public static String printString(String string, int n) {
        string = StringUtils.trimToNull((String)string);
        if (n < 1) {
            return string;
        }
        if (n < 4) {
            return StringUtils.left((String)string, (int)n);
        }
        return StringUtils.abbreviate((String)string, (int)n);
    }
}

