/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv;

import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.types.Datei;
import org.openestate.io.is24_csv.types.DateiSuffix;
import org.openestate.io.is24_csv.types.DateiTyp;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.Importmodus;
import org.openestate.io.is24_csv.types.Objektdarstellung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Is24CsvRecord
extends CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvRecord.class);
    private static final Pattern LINEBREAK = Pattern.compile("<br\\s*/?>", 2);
    public static final int LENGTH = 182;
    public static final int FILE_LIMIT = 10;
    protected static final int FIELD_MODUS = 0;
    protected static final int FIELD_STATUS = 1;
    protected static final int FIELD_IMMOBILIENART = 2;
    protected static final int FIELD_SCOUT_OBJEKT_ID = 3;
    protected static final int FIELD_TERMS_REGION = 4;
    protected static final int FIELD_TERMS_STADT = 5;
    protected static final int FIELD_TERMS_STADTTEIL = 6;
    protected static final int FIELD_ANBIETER_OBJEKT_ID = 7;
    protected static final int FIELD_GRUPPIERUNG_ID = 8;
    protected static final int FIELD_OBJEKTDARSTELLUNG = 9;
    protected static final int FIELD_OBJEKTDARSTELLUNG_GRUPPEN = 10;
    protected static final int FIELD_API_SUCHFELD1 = 11;
    protected static final int FIELD_API_SUCHFELD2 = 12;
    protected static final int FIELD_API_SUCHFELD3 = 13;
    protected static final int FIELD_SCOUT_KUNDEN_ID = 15;
    protected static final int FIELD_KONTAKT_ANREDE = 16;
    protected static final int FIELD_KONTAKT_VORNAME = 17;
    protected static final int FIELD_KONTAKT_NACHNAME = 18;
    protected static final int FIELD_KONTAKT_STRASSE = 19;
    protected static final int FIELD_KONTAKT_HAUSNR = 20;
    protected static final int FIELD_KONTAKT_PLZ = 21;
    protected static final int FIELD_KONTAKT_ORT = 22;
    protected static final int FIELD_KONTAKT_LAND = 23;
    protected static final int FIELD_KONTAKT_TELEFON = 24;
    protected static final int FIELD_KONTAKT_MOBILTELEFON = 25;
    protected static final int FIELD_KONTAKT_TELEFAX = 26;
    protected static final int FIELD_KONTAKT_EMAIL = 27;
    protected static final int FIELD_KONTAKT_WEBSEITE = 28;
    protected static final int FIELD_ADRESSDRUCK = 35;
    protected static final int FIELD_UEBERSCHRIFT = 36;
    protected static final int FIELD_PROVISION = 37;
    protected static final int FIELD_WAEHRUNG = 38;
    protected static final int FIELD_PROVISIONPFLICHTIG = 39;
    protected static final int FIELD_PROVISIONSHINWEIS = 40;
    protected static final int FIELD_OBJEKT_STRASSE = 50;
    protected static final int FIELD_OBJEKT_HAUSNR = 51;
    protected static final int FIELD_OBJEKT_PLZ = 52;
    protected static final int FIELD_OBJEKT_ORT = 53;
    protected static final int FIELD_OBJEKT_LAND = 54;
    protected static final int FIELD_OBJEKT_INTERNATIONALE_REGION = 55;
    protected static final int FIELD_BESCHREIBUNG_LAGE = 99;
    protected static final int FIELD_BESCHREIBUNG_AUSSTATTUNG = 100;
    protected static final int FIELD_BESCHREIBUNG_OBJEKT = 101;
    protected static final int FIELD_BESCHREIBUNG_SONSTIGES = 102;
    protected static final int FIELD_DATEI1_NAME = 107;
    protected static final int FIELD_DATEI1_SUFFIX = 108;
    protected static final int FIELD_DATEI1_TYP = 109;
    protected static final int FIELD_DATEI1_DAUER = 110;
    protected static final int FIELD_DATEI1_TEXT = 111;
    protected static final int FIELD_DATEI2_NAME = 112;
    protected static final int FIELD_DATEI2_SUFFIX = 113;
    protected static final int FIELD_DATEI2_TYP = 114;
    protected static final int FIELD_DATEI2_DAUER = 115;
    protected static final int FIELD_DATEI2_TEXT = 116;
    protected static final int FIELD_DATEI3_NAME = 117;
    protected static final int FIELD_DATEI3_SUFFIX = 118;
    protected static final int FIELD_DATEI3_TYP = 119;
    protected static final int FIELD_DATEI3_DAUER = 120;
    protected static final int FIELD_DATEI3_TEXT = 121;
    protected static final int FIELD_DATEI4_NAME = 122;
    protected static final int FIELD_DATEI4_SUFFIX = 123;
    protected static final int FIELD_DATEI4_TYP = 124;
    protected static final int FIELD_DATEI4_DAUER = 125;
    protected static final int FIELD_DATEI4_TEXT = 126;
    protected static final int FIELD_DATEI5_NAME = 127;
    protected static final int FIELD_DATEI5_SUFFIX = 128;
    protected static final int FIELD_DATEI5_TYP = 129;
    protected static final int FIELD_DATEI5_DAUER = 130;
    protected static final int FIELD_DATEI5_TEXT = 131;
    protected static final int FIELD_DATEI6_NAME = 132;
    protected static final int FIELD_DATEI6_SUFFIX = 133;
    protected static final int FIELD_DATEI6_TYP = 134;
    protected static final int FIELD_DATEI6_DAUER = 135;
    protected static final int FIELD_DATEI6_TEXT = 136;
    protected static final int FIELD_DATEI7_NAME = 137;
    protected static final int FIELD_DATEI7_SUFFIX = 138;
    protected static final int FIELD_DATEI7_TYP = 139;
    protected static final int FIELD_DATEI7_DAUER = 140;
    protected static final int FIELD_DATEI7_TEXT = 141;
    protected static final int FIELD_DATEI8_NAME = 142;
    protected static final int FIELD_DATEI8_SUFFIX = 143;
    protected static final int FIELD_DATEI8_TYP = 144;
    protected static final int FIELD_DATEI8_DAUER = 145;
    protected static final int FIELD_DATEI8_TEXT = 146;
    protected static final int FIELD_DATEI9_NAME = 147;
    protected static final int FIELD_DATEI9_SUFFIX = 148;
    protected static final int FIELD_DATEI9_TYP = 149;
    protected static final int FIELD_DATEI9_DAUER = 150;
    protected static final int FIELD_DATEI9_TEXT = 151;
    protected static final int FIELD_DATEI10_NAME = 152;
    protected static final int FIELD_DATEI10_SUFFIX = 153;
    protected static final int FIELD_DATEI10_TYP = 154;
    protected static final int FIELD_DATEI10_DAUER = 155;
    protected static final int FIELD_DATEI10_TEXT = 156;

    public String getAnbieterObjektId() {
        return this.get(7);
    }

    public String getApiSuchfeld1() {
        return this.get(11);
    }

    public String getApiSuchfeld2() {
        return this.get(12);
    }

    public String getApiSuchfeld3() {
        return this.get(13);
    }

    public String getBeschreibungAusstattung() {
        return this.get(100);
    }

    public String getBeschreibungLage() {
        return this.get(99);
    }

    public String getBeschreibungObjekt() {
        return this.get(101);
    }

    public String getBeschreibungSonstiges() {
        return this.get(102);
    }

    public Datei getDatei(int n) {
        switch (n) {
            case 1: {
                return this.getDatei1();
            }
            case 2: {
                return this.getDatei2();
            }
            case 3: {
                return this.getDatei3();
            }
            case 4: {
                return this.getDatei4();
            }
            case 5: {
                return this.getDatei5();
            }
            case 6: {
                return this.getDatei6();
            }
            case 7: {
                return this.getDatei7();
            }
            case 8: {
                return this.getDatei8();
            }
            case 9: {
                return this.getDatei9();
            }
            case 10: {
                return this.getDatei10();
            }
        }
        throw new IllegalArgumentException("Unsupported file position " + n + "!");
    }

    public Datei getDatei1() {
        String string = this.get(107);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(110));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 1!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(109)), DateiSuffix.parse(this.get(108)), this.get(111), n != null ? n : 0);
    }

    public Datei getDatei2() {
        String string = this.get(112);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(115));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 2!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(114)), DateiSuffix.parse(this.get(113)), this.get(116), n != null ? n : 0);
    }

    public Datei getDatei3() {
        String string = this.get(117);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(120));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 3!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(119)), DateiSuffix.parse(this.get(118)), this.get(121), n != null ? n : 0);
    }

    public Datei getDatei4() {
        String string = this.get(122);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(125));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 4!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(124)), DateiSuffix.parse(this.get(123)), this.get(126), n != null ? n : 0);
    }

    public Datei getDatei5() {
        String string = this.get(127);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(130));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 5!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(129)), DateiSuffix.parse(this.get(128)), this.get(131), n != null ? n : 0);
    }

    public Datei getDatei6() {
        String string = this.get(132);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(135));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 6!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(134)), DateiSuffix.parse(this.get(133)), this.get(136), n != null ? n : 0);
    }

    public Datei getDatei7() {
        String string = this.get(137);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(140));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 7!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(139)), DateiSuffix.parse(this.get(138)), this.get(141), n != null ? n : 0);
    }

    public Datei getDatei8() {
        String string = this.get(142);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(145));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 8!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(144)), DateiSuffix.parse(this.get(143)), this.get(146), n != null ? n : 0);
    }

    public Datei getDatei9() {
        String string = this.get(147);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(150));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 9!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(149)), DateiSuffix.parse(this.get(148)), this.get(151), n != null ? n : 0);
    }

    public Datei getDatei10() {
        String string = this.get(152);
        if (string == null) {
            return null;
        }
        Integer n = null;
        try {
            n = Is24CsvFormat.parseInteger(this.get(155));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read duration for file 10!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        return new Datei(string, DateiTyp.parse(this.get(154)), DateiSuffix.parse(this.get(153)), this.get(156), n != null ? n : 0);
    }

    public Datei[] getDateien() {
        ArrayList<Datei> arrayList = new ArrayList<Datei>();
        for (int i = 1; i <= 10; ++i) {
            Datei datei = this.getDatei(i);
            if (datei == null) continue;
            arrayList.add(datei);
        }
        return arrayList.toArray(new Datei[0]);
    }

    public Integer getGruppierungId() {
        try {
            return Is24CsvFormat.parseInteger(this.get(8));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gruppierung ID'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Immobilienart getImmobilienart() {
        return Immobilienart.parse(this.get(2));
    }

    public static Immobilienart getImmobilienart(CSVRecord cSVRecord) {
        return Immobilienart.parse(cSVRecord.get(2));
    }

    public Importmodus getImportmodus() {
        return Importmodus.parse(this.get(0));
    }

    public String getKontaktAnrede() {
        return this.get(16);
    }

    public String getKontaktEmail() {
        return this.get(27);
    }

    public String getKontaktHausNr() {
        return this.get(20);
    }

    public String getKontaktLand() {
        String string = this.get(23);
        return string != null ? string : Locale.GERMANY.getISO3Country();
    }

    public String getKontaktMobiltelefon() {
        return this.get(25);
    }

    public String getKontaktNachname() {
        return this.get(18);
    }

    public String getKontaktOrt() {
        return this.get(22);
    }

    public String getKontaktPlz() {
        return this.get(21);
    }

    public String getKontaktStrasse() {
        return this.get(19);
    }

    public String getKontaktTelefax() {
        return this.get(26);
    }

    public String getKontaktTelefon() {
        return this.get(24);
    }

    public String getKontaktVorname() {
        return this.get(17);
    }

    public String getKontaktWebseite() {
        return this.get(28);
    }

    public Objektdarstellung getObjektdarstellung() {
        return Objektdarstellung.parse(this.get(9));
    }

    public String[] getObjektdarstellungGruppen() {
        String string = this.get(10);
        return StringUtils.split((String)string, (String)";");
    }

    public String getObjektHausNr() {
        return this.get(51);
    }

    public String getInternationaleRegion() {
        return this.get(55);
    }

    public String getObjektLand() {
        String string = this.get(54);
        return string != null ? string : Locale.GERMANY.getISO3Country();
    }

    public String getObjektOrt() {
        return this.get(53);
    }

    public String getObjektPlz() {
        return this.get(52);
    }

    public String getObjektStrasse() {
        return this.get(50);
    }

    public String getProvision() {
        return this.get(37);
    }

    public String getProvisionshinweis() {
        return this.get(40);
    }

    protected int getRecordLength() {
        return 182;
    }

    public String getScoutKundenId() {
        return this.get(15);
    }

    public String getScoutObjektId() {
        return this.get(3);
    }

    public String getTermsRegion() {
        return this.get(4);
    }

    public String getTermsStadt() {
        return this.get(5);
    }

    public String getTermsStadtteil() {
        return this.get(6);
    }

    public String getUeberschrift() {
        return this.get(36);
    }

    public Currency getWaehrung() {
        String string = this.get(38);
        try {
            return string != null ? Currency.getInstance(string) : Currency.getInstance("EUR");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("Can't read currency '" + string + "'!");
            LOGGER.warn("> " + illegalArgumentException.getLocalizedMessage(), (Throwable)illegalArgumentException);
            return Currency.getInstance("EUR");
        }
    }

    public boolean isAdressdruck() {
        return Boolean.TRUE.equals(Is24CsvFormat.parseBoolean(this.get(35)));
    }

    public boolean isAktiv() {
        String string = this.get(1);
        return !"0".equals(string);
    }

    public boolean isProvisionspflichtig() {
        return Boolean.TRUE.equals(Is24CsvFormat.parseBoolean(this.get(39)));
    }

    protected String parse(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        Matcher matcher = LINEBREAK.matcher(string);
        return matcher.find() ? matcher.replaceAll(System.lineSeparator()) : string;
    }

    public void setAdressdruck(boolean bl) {
        this.setAdressdruck((Boolean)bl);
    }

    public void setAdressdruck(Boolean bl) {
        this.set(35, Is24CsvFormat.printBoolean(bl != null ? bl : false));
    }

    public void setAktiv(boolean bl) {
        this.setAktiv((Boolean)bl);
    }

    public void setAktiv(Boolean bl) {
        this.set(1, Boolean.TRUE.equals(bl) ? "1" : "0");
    }

    public void setAnbieterObjektId(String string) {
        this.set(7, Is24CsvFormat.printString(string, 50));
    }

    public void setApiSuchfeld1(String string) {
        this.set(11, Is24CsvFormat.printString(string, 10));
    }

    public void setApiSuchfeld2(String string) {
        this.set(12, Is24CsvFormat.printString(string, 10));
    }

    public void setApiSuchfeld3(String string) {
        this.set(13, Is24CsvFormat.printString(string, 10));
    }

    public void setBeschreibungAusstattung(String string) {
        this.set(100, Is24CsvFormat.printString(string, 2000));
    }

    public void setBeschreibungLage(String string) {
        this.set(99, Is24CsvFormat.printString(string, 2000));
    }

    public void setBeschreibungObjekt(String string) {
        this.set(101, Is24CsvFormat.printString(string, 2000));
    }

    public void setBeschreibungSonstiges(String string) {
        this.set(102, Is24CsvFormat.printString(string, 2000));
    }

    public void setDatei(Datei datei, int n) {
        switch (n) {
            case 1: {
                this.setDatei1(datei);
                break;
            }
            case 2: {
                this.setDatei2(datei);
                break;
            }
            case 3: {
                this.setDatei3(datei);
                break;
            }
            case 4: {
                this.setDatei4(datei);
                break;
            }
            case 5: {
                this.setDatei5(datei);
                break;
            }
            case 6: {
                this.setDatei6(datei);
                break;
            }
            case 7: {
                this.setDatei7(datei);
                break;
            }
            case 8: {
                this.setDatei8(datei);
                break;
            }
            case 9: {
                this.setDatei9(datei);
                break;
            }
            case 10: {
                this.setDatei10(datei);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file position " + n + "!");
            }
        }
    }

    public void setDatei1(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(107, string);
        this.set(111, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(109, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(108, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(110, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei2(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(112, string);
        this.set(116, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(114, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(113, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(115, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei3(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(117, string);
        this.set(121, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(119, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(118, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(120, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei4(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(122, string);
        this.set(126, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(124, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(123, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(125, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei5(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(127, string);
        this.set(131, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(129, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(128, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(130, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei6(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(132, string);
        this.set(136, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(134, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(133, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(135, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei7(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(137, string);
        this.set(141, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(139, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(138, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(140, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei8(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(142, string);
        this.set(146, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(144, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(143, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(145, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei9(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(147, string);
        this.set(151, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(149, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(148, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(150, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDatei10(Datei datei) {
        String string = datei != null ? StringUtils.trimToNull((String)datei.getName()) : null;
        this.set(152, string);
        this.set(156, datei != null && string != null ? Is24CsvFormat.printString(datei.getText(), 30) : null);
        this.set(154, datei != null && datei.getTyp() != null && string != null ? datei.getTyp().print() : null);
        this.set(153, datei != null && datei.getSuffix() != null && string != null ? datei.getSuffix().print() : null);
        this.set(155, datei != null && string != null ? Is24CsvFormat.printNumber(datei.getAbspieldauer(), 5) : null);
    }

    public void setDateien(Iterable<Datei> iterable) {
        int n = 1;
        if (iterable != null) {
            for (Datei datei : iterable) {
                this.setDatei(datei, n);
                if (++n <= 10) continue;
                break;
            }
        }
        for (int i = n; i <= 10; ++i) {
            this.setDatei(null, i);
        }
    }

    public void setGruppierungId(Number number) {
        this.set(8, number != null ? String.valueOf(number) : null);
    }

    protected void setImmobilienart(Immobilienart immobilienart) {
        this.set(2, immobilienart != null ? immobilienart.print() : null);
    }

    public void setImportmodus(Importmodus importmodus) {
        this.set(0, importmodus != null ? importmodus.print() : null);
    }

    public void setKontaktAnrede(String string) {
        this.set(16, Is24CsvFormat.printString(string, 20));
    }

    public void setKontaktEmail(String string) {
        this.set(27, Is24CsvFormat.printString(string, 150));
    }

    public void setKontaktHausNr(String string) {
        this.set(20, Is24CsvFormat.printString(string, 30));
    }

    public void setKontaktLand(String string) {
        this.set(23, (String)StringUtils.defaultIfBlank((CharSequence)Is24CsvFormat.getCountryCode(string), (CharSequence)Locale.GERMANY.getISO3Country()));
    }

    public void setKontaktMobiltelefon(String string) {
        this.set(25, Is24CsvFormat.printString(string, 40));
    }

    public void setKontaktNachname(String string) {
        this.set(18, Is24CsvFormat.printString(string, 50));
    }

    public void setKontaktOrt(String string) {
        this.set(22, Is24CsvFormat.printString(string, 50));
    }

    public void setKontaktPlz(String string) {
        this.set(21, Is24CsvFormat.printString(string, 20));
    }

    public void setKontaktStrasse(String string) {
        this.set(19, Is24CsvFormat.printString(string, 100));
    }

    public void setKontaktTelefax(String string) {
        this.set(26, Is24CsvFormat.printString(string, 40));
    }

    public void setKontaktTelefon(String string) {
        this.set(24, Is24CsvFormat.printString(string, 40));
    }

    public void setKontaktVorname(String string) {
        this.set(17, Is24CsvFormat.printString(string, 30));
    }

    public void setKontaktWebseite(String string) {
        this.set(28, Is24CsvFormat.printString(string, 300));
    }

    public void setObjektdarstellung(Objektdarstellung objektdarstellung) {
        this.set(9, objektdarstellung != null ? objektdarstellung.print() : null);
    }

    public void setObjektdarstellungGruppen(String[] stringArray) {
        this.set(10, StringUtils.trimToNull((String)StringUtils.join((Object[])stringArray, (String)";")));
    }

    public void setObjektHausNr(String string) {
        this.set(51, Is24CsvFormat.printString(string, 30));
    }

    public void setInternationaleRegion(String string) {
        this.set(55, Is24CsvFormat.printString(string, 100));
    }

    public void setObjektLand(String string) {
        this.set(54, (String)StringUtils.defaultIfBlank((CharSequence)Is24CsvFormat.getCountryCode(string), (CharSequence)Locale.GERMANY.getISO3Country()));
    }

    public void setObjektOrt(String string) {
        this.set(53, Is24CsvFormat.printString(string, 50));
    }

    public void setObjektPlz(String string) {
        this.set(52, Is24CsvFormat.printString(string, 20));
    }

    public void setObjektStrasse(String string) {
        this.set(50, Is24CsvFormat.printString(string, 100));
    }

    public void setProvision(String string) {
        this.set(37, Is24CsvFormat.printString(string, 50));
    }

    public void setProvisionpflichtig(boolean bl) {
        this.setProvisionpflichtig((Boolean)bl);
    }

    public void setProvisionpflichtig(Boolean bl) {
        this.set(39, Is24CsvFormat.printBoolean(bl != null ? bl : false));
    }

    public void setProvisionshinweis(String string) {
        this.set(40, Is24CsvFormat.printString(string, 200));
    }

    public void setScoutKundenId(String string) {
        this.set(15, Is24CsvFormat.printString(string, 15));
    }

    public void setScoutObjektId(String string) {
        this.set(3, Is24CsvFormat.printString(string, 20));
    }

    public void setTermsRegion(String string) {
        this.set(4, Is24CsvFormat.printString(string, 50));
    }

    public void setTermsStadt(String string) {
        this.set(5, Is24CsvFormat.printString(string, 50));
    }

    public void setTermsStadtteil(String string) {
        this.set(6, Is24CsvFormat.printString(string, 50));
    }

    public void setUeberschrift(String string) {
        this.set(36, Is24CsvFormat.printString(string, 100));
    }

    public void setWaehrung(Currency currency) {
        this.set(38, currency != null ? currency.getCurrencyCode() : "EUR");
    }
}

