/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.types;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DateiSuffix {
    BMP(".BMP"),
    GIF(".GIF"),
    PNG(".PNG"),
    JPG(".JPG"),
    WBMP(".WBMP"),
    JPEG(".JPEG"),
    MOV(".MOV"),
    QT(".QT"),
    QTL(".QTL"),
    RM(".RM"),
    RV(".RV"),
    MPE(".MPE"),
    MPG(".MPG"),
    MPEG(".MPEG"),
    MP4(".MP4"),
    WMV(".WMV"),
    AVI(".AVI"),
    PDF(".PDF");

    private static final Logger LOGGER;
    private final String value;

    private DateiSuffix(String string2) {
        this.value = string2;
    }

    public static DateiSuffix fromFileName(String string) {
        if ((string = StringUtils.lowerCase((String)StringUtils.trimToNull((String)string))) != null) {
            for (DateiSuffix dateiSuffix : DateiSuffix.values()) {
                if (!string.endsWith(dateiSuffix.name().toLowerCase())) continue;
                return dateiSuffix;
            }
        }
        return null;
    }

    public static DateiSuffix fromMimeType(String string) {
        if ("video/x-msvideo".equals(string = StringUtils.lowerCase((String)StringUtils.trimToNull((String)string)))) {
            return AVI;
        }
        if ("image/bmp".equals(string)) {
            return BMP;
        }
        if ("image/gif".equals(string)) {
            return GIF;
        }
        if ("image/jpeg".equals(string)) {
            return JPG;
        }
        if ("video/quicktime".equals(string)) {
            return MOV;
        }
        if ("video/mp4".equals(string)) {
            return MP4;
        }
        if ("video/mpeg".equals(string)) {
            return MPEG;
        }
        if ("application/pdf".equals(string)) {
            return PDF;
        }
        if ("image/png".equals(string)) {
            return PNG;
        }
        if ("application/vnd.rn-realmedia".equals(string)) {
            return RM;
        }
        if ("video/vnd.rn-realvideo".equals(string)) {
            return RV;
        }
        if ("video/x-ms-wmv".equals(string)) {
            return WMV;
        }
        return null;
    }

    public String getMimeType() {
        switch (this) {
            case AVI: {
                return "video/x-msvideo";
            }
            case BMP: {
                return "image/bmp";
            }
            case GIF: {
                return "image/gif";
            }
            case JPG: {
                return "image/jpeg";
            }
            case MOV: {
                return "video/quicktime";
            }
            case MP4: {
                return "video/mp4";
            }
            case MPE: {
                return "video/mpeg";
            }
            case MPEG: {
                return "video/mpeg";
            }
            case MPG: {
                return "video/mpeg";
            }
            case PDF: {
                return "application/pdf";
            }
            case PNG: {
                return "image/png";
            }
            case QT: {
                return "video/quicktime";
            }
            case QTL: {
                return "video/quicktime";
            }
            case RM: {
                return "application/vnd.rn-realmedia";
            }
            case RV: {
                return "video/vnd.rn-realvideo";
            }
            case WMV: {
                return "video/x-ms-wmv";
            }
        }
        return "application/octet-stream";
    }

    public static DateiSuffix parse(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (DateiSuffix dateiSuffix : DateiSuffix.values()) {
            if (!dateiSuffix.value.equalsIgnoreCase(string) && !dateiSuffix.name().equalsIgnoreCase(string)) continue;
            return dateiSuffix;
        }
        return null;
    }

    public String print() {
        return this.value;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DateiSuffix.class);
    }
}

