/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.db.DbAdapterImpl;
import com.openindex.openestate.impl.db.DbContactsHandler;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.impl.db.DbObjectsHandler;
import com.openindex.openestate.impl.db.DbSearchesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.hsql.HSqlDbContactsHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbFilesHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbGeoHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbLanguagesHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbLinksHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbObjectsHandler;
import com.openindex.openestate.impl.db.hsql.HSqlDbSearchesHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbAdapter
extends DbAdapterImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAdapter.class);
    private final String schema;

    public HSqlDbAdapter() {
        this(null);
    }

    public HSqlDbAdapter(String string) {
        this.schema = StringUtils.trimToNull((String)string);
    }

    public DbContactsHandler getContactsHandler() {
        return new HSqlDbContactsHandler(this.schema);
    }

    public DbFilesHandler getFilesHandler() {
        return new HSqlDbFilesHandler(this.schema);
    }

    public DbGeoHandler getGeoHandler() {
        return new HSqlDbGeoHandler(this.schema);
    }

    public DbLanguagesHandler getLanguageHandler() {
        return new HSqlDbLanguagesHandler(this.schema);
    }

    public DbLinksHandler getLinksHandler() {
        return new HSqlDbLinksHandler(this.schema);
    }

    public DbObjectsHandler getObjectsHandler() {
        return new HSqlDbObjectsHandler(this.schema);
    }

    public DbSearchesHandler getSearchesHandler() {
        return new HSqlDbSearchesHandler(this.schema);
    }

    public void install(Connection connection, boolean bl) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbAdapter.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            if (bl) {
                sqlFile = HSqlDbAdapter.readHsqlFile("routines.sql");
                sqlFile.setConnection(connection);
                sqlFile.execute();
                sqlFile.closeReader();
            }
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        try (InputStream inputStream = HSqlDbAdapter.class.getResourceAsStream("/com/openindex/openestate/impl/db/hsql/resources/" + string);){
            List list = IOUtils.readLines((InputStream)inputStream, (String)"UTF-8");
            File file = File.createTempFile("openestate.", ".sql");
            file.deleteOnExit();
            FileUtils.writeLines((File)file, (Collection)list);
            SqlFile sqlFile = new SqlFile(file, "UTF-8");
            return sqlFile;
        }
    }
}

