/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchAttribImpl;
import com.openindex.openestate.impl.SearchDateTimeImpl;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.SearchNumericImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnergyConsumptionAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbObjectsHandlerImpl;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.db.NamedPreparedStatement;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.CurrencyValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbObjectsHandler
extends DbObjectsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbObjectsHandler.class);
    public static final String PROC_REMOVE_OBJECTS = "remove_openestate_objects";
    public static final String PROC_REMOVE_OBJECTS_ATTRIBS = "remove_openestate_objects_attribs";
    public static final String PROC_REMOVE_OBJECTS_GEODBS_AREAS = "remove_openestate_objects_geodbs_areas";
    public static final String PROC_REMOVE_OBJECTS_I18N = "remove_openestate_objects_i18n";
    public static final String PROC_GET_OBJECT_ID = "get_openestate_objects_id";
    public static final String PROC_SAVE_OBJECTS = "save_openestate_objects";
    public static final String PROC_SAVE_OBJECTS_ATTRIBS = "save_openestate_objects_attribs";
    public static final String PROC_SAVE_OBJECTS_GEODBS_AREAS = "save_openestate_objects_geodbs_areas";
    public static final String PROC_SAVE_OBJECTS_I18N = "save_openestate_objects_i18n";
    public static final String PROC_SET_OBJECTS_CONTACT = "set_openestate_objects_contact";
    public static final String VIEW_OBJECTS = "view_openestate_objects";
    public static final String VIEW_OBJECTS_ACTIONS = "view_openestate_objects_actions";
    public static final String VIEW_OBJECTS_ATTRIBS = "view_openestate_objects_attribs";
    public static final String VIEW_OBJECTS_GEODBS_AREAS = "view_openestate_objects_geodbs_areas";
    public static final String VIEW_OBJECTS_I18N = "view_openestate_objects_i18n";
    public static final String VIEW_OBJECTS_TYPES = "view_openestate_objects_types";
    public static final String FIELD_OBJECT_ID = "object_id";
    public static final String FIELD_OBJECT_TYPE = "object_type";
    public static final String FIELD_OBJECT_ACTION = "object_action";
    public static final String FIELD_OBJECT_PUBLIC_ID = "object_public_id";
    public static final String FIELD_OBJECT_GROUP_ID = "object_group_id";
    public static final String FIELD_OBJECT_CURRENCY = "object_currency";
    public static final String FIELD_OBJECT_HIDDEN_PRICES = "object_hidden_prices";
    public static final String FIELD_OBJECT_PUBLISH_BEGIN = "object_publish_begin";
    public static final String FIELD_OBJECT_PUBLISH_END = "object_publish_end";
    public static final String FIELD_ADDRESS_PUBLISHED = "address_published";
    public static final String FIELD_ADDRESS_STREET = "address_street";
    public static final String FIELD_ADDRESS_STREET2 = "address_street2";
    public static final String FIELD_ADDRESS_STREET_NR = "address_street_nr";
    public static final String FIELD_ADDRESS_POSTAL_CODE = "address_postal_code";
    public static final String FIELD_ADDRESS_CITY = "address_city";
    public static final String FIELD_ADDRESS_DISTRICT = "address_district";
    public static final String FIELD_ADDRESS_COUNTRY = "address_country";
    public static final String FIELD_ADDRESS_REGION = "address_region";
    public static final String FIELD_ADDRESS_LATITUDE = "address_latitude";
    public static final String FIELD_ADDRESS_LONGITUDE = "address_longitude";
    public static final String FIELD_ATTRIB_NAME = "attrib_name";
    public static final String FIELD_ATTRIB_UNIT = "attrib_unit";
    public static final String FIELD_VALUE_TEXT = "value_text";
    public static final String FIELD_VALUE_STRING = "value_string";
    public static final String FIELD_VALUE_BOOLEAN = "value_boolean";
    public static final String FIELD_VALUE_NUMERIC = "value_numeric";
    public static final String FIELD_VALUE_NUMERIC_BASE = "value_numeric_base";
    public static final String FIELD_VALUE_DATE = "value_date";
    public static final String FIELD_VALUE_TIME = "value_time";
    public static final String FIELD_VALUE_DATETIME = "value_datetime";
    public static final String FIELD_I18N_TITLE = "i18n_title";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_CONTACT_ID = "contact_id";
    private static final String FIELD_LANGUAGE_ID = "language_id";
    private static final String FIELD_GEODB_ID = "geodb_id";
    private static final String FIELD_AREA_ID = "area_id";

    public HSqlDbObjectsHandler() {
    }

    public HSqlDbObjectsHandler(String string) {
        super(string);
    }

    protected AbstractAttribImpl buildAttrib(ResultSet resultSet, Map<Long, String> map, EstateImpl estateImpl) throws SQLException {
        Object object;
        OpenEstateAttrib openEstateAttrib;
        long l;
        Currency currency;
        block88: {
            currency = estateImpl.getCurrency();
            l = resultSet.getLong(FIELD_OBJECT_ID);
            String string = resultSet.getString(FIELD_ATTRIB_NAME);
            openEstateAttrib = null;
            try {
                openEstateAttrib = OpenEstateAttrib.valueOf((String)string);
            }
            catch (Exception exception) {
                object = StringUtils.split((String)string, (String)"_", (int)2);
                if (ArrayUtils.getLength((Object)object) == 2) {
                    openEstateAttrib = OpenEstateUtils.lookupAttrib((String)object[0], (String)object[1]);
                }
                if (openEstateAttrib != null) break block88;
                LOGGER.warn("Unsupported attribute \"" + string + "\" in object #" + l + "!");
                return null;
            }
        }
        AbstractAttribImpl abstractAttribImpl = estateImpl.hasAttribute(openEstateAttrib) ? estateImpl.getAttribute(openEstateAttrib) : openEstateAttrib.createImpl();
        object = resultSet.getString(FIELD_VALUE_STRING);
        if (StringUtils.isBlank((CharSequence)object)) {
            object = resultSet.getString(FIELD_VALUE_TEXT);
        }
        Object object2 = object = !StringUtils.isBlank((CharSequence)object) ? ((String)object).trim() : null;
        if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
            boolean bl;
            SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)abstractAttribImpl;
            if (resultSet.getObject(FIELD_VALUE_BOOLEAN) != null) {
                bl = resultSet.getBoolean(FIELD_VALUE_BOOLEAN);
            } else if ("1".equals(object) || "true".equalsIgnoreCase((String)object)) {
                bl = true;
            } else if ("0".equals(object) || "false".equalsIgnoreCase((String)object)) {
                bl = false;
            } else {
                LOGGER.warn("Can't read boolean value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            simpleBooleanAttrib.setValue(Boolean.valueOf(bl));
            return simpleBooleanAttrib;
        }
        if (abstractAttribImpl instanceof SimpleEnumAttrib) {
            if (object == null) {
                return null;
            }
            SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
            Enum enum_ = simpleEnumAttrib.getOption((String)object);
            if (enum_ == null) {
                enum_ = OpenEstateUtils.lookupAttribOption((String)openEstateAttrib.getGroupName(), (String)openEstateAttrib.getAttribName(), (String)object);
            }
            if (enum_ == null) {
                LOGGER.warn("Can't read option \"" + (String)object + "\" of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                LOGGER.warn("> allowed values: " + StringUtils.join((Object[])simpleEnumAttrib.getOptions(), (String)", "));
                return null;
            }
            simpleEnumAttrib.setValue(enum_);
            return simpleEnumAttrib;
        }
        if (abstractAttribImpl instanceof SimpleNumericAttrib) {
            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)abstractAttribImpl;
            BigDecimal bigDecimal = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (bigDecimal == null && object != null) {
                try {
                    bigDecimal = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bigDecimal == null) {
                LOGGER.warn("Can't read numeric value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            simpleNumericAttrib.setValue(simpleNumericAttrib.getPrecision() > 0 ? bigDecimal : bigDecimal.toBigInteger());
            return simpleNumericAttrib;
        }
        if (abstractAttribImpl instanceof SimpleTimeAttrib) {
            SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)abstractAttribImpl;
            java.util.Date date = null;
            if (simpleTimeAttrib.isDate()) {
                date = resultSet.getDate(FIELD_VALUE_DATE);
                try {
                    if (date == null) {
                        date = OpenEstateUtils.parseDate((String)object);
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Can't read date from text value '" + (String)object + "'!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
            } else if (simpleTimeAttrib.isTime()) {
                date = resultSet.getTime(FIELD_VALUE_TIME);
                try {
                    if (date == null) {
                        date = OpenEstateUtils.parseTime((String)object);
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Can't read time from text value '" + (String)object + "'!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
            } else if (simpleTimeAttrib.isDateTime()) {
                date = resultSet.getTimestamp(FIELD_VALUE_DATETIME);
                try {
                    if (date == null) {
                        date = OpenEstateUtils.parseDateTime((String)object);
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Can't read date-time from text value '" + (String)object + "'!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
            }
            if (date == null && object != null) {
                date = simpleTimeAttrib.parseValue((String)object);
            }
            if (date == null) {
                LOGGER.warn("Can't read time value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            simpleTimeAttrib.setValue(date);
            return simpleTimeAttrib;
        }
        if (abstractAttribImpl instanceof ComplexAreaAttrib) {
            AreaValue.Unit unit;
            Object object3;
            ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)abstractAttribImpl;
            try {
                object3 = resultSet.getString(FIELD_ATTRIB_UNIT);
                unit = object3 != null ? AreaValue.Unit.valueOf((String)object3) : AreaValue.Unit.getBaseUnit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read area unit of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                unit = AreaValue.Unit.getBaseUnit();
            }
            object3 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (object3 == null && (object3 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC_BASE)) != null) {
                unit = AreaValue.Unit.getBaseUnit();
            }
            if (object3 == null && object != null) {
                try {
                    object3 = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object3 == null) {
                LOGGER.warn("Can't read area value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexAreaAttrib.setValue(new AreaValue((BigDecimal)object3, unit));
            return complexAreaAttrib;
        }
        if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
            Currency currency2;
            Object object4;
            ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)abstractAttribImpl;
            try {
                object4 = resultSet.getString(FIELD_ATTRIB_UNIT);
                currency2 = object4 != null ? Currency.getInstance((String)object4) : currency;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read currency unit of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                currency2 = currency;
            }
            object4 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (object4 == null) {
                object4 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC_BASE);
            }
            if (object4 == null && object != null) {
                try {
                    object4 = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object4 == null) {
                LOGGER.warn("Can't read currency value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexCurrencyAttrib.setValue(new CurrencyValue((BigDecimal)object4, currency2));
            return complexCurrencyAttrib;
        }
        if (abstractAttribImpl instanceof ComplexEnergyConsumptionAttrib) {
            EnergyConsumptionValue.Unit unit;
            Object object5;
            ComplexEnergyConsumptionAttrib complexEnergyConsumptionAttrib = (ComplexEnergyConsumptionAttrib)abstractAttribImpl;
            try {
                object5 = resultSet.getString(FIELD_ATTRIB_UNIT);
                unit = object5 != null ? EnergyConsumptionValue.Unit.valueOf((String)object5) : EnergyConsumptionValue.Unit.getBaseUnit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read energy-consumption unit of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                unit = EnergyConsumptionValue.Unit.getBaseUnit();
            }
            object5 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (object5 == null && (object5 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC_BASE)) != null) {
                unit = EnergyConsumptionValue.Unit.getBaseUnit();
            }
            if (object5 == null && object != null) {
                try {
                    object5 = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object5 == null) {
                LOGGER.warn("Can't read energy-consumption value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexEnergyConsumptionAttrib.setValue(new EnergyConsumptionValue((BigDecimal)object5, unit));
            return complexEnergyConsumptionAttrib;
        }
        if (abstractAttribImpl instanceof ComplexEnumAttrib) {
            if (object == null) {
                return null;
            }
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : StringUtils.substringsBetween((String)object, (String)"[", (String)"]")) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            Object[] objectArray = complexEnumAttrib.parseValue(arrayList);
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                return null;
            }
            complexEnumAttrib.setValue((Enum[])objectArray);
            return complexEnumAttrib;
        }
        if (abstractAttribImpl instanceof ComplexLengthAttrib) {
            LengthValue.Unit unit;
            Object object6;
            ComplexLengthAttrib complexLengthAttrib = (ComplexLengthAttrib)abstractAttribImpl;
            try {
                object6 = resultSet.getString(FIELD_ATTRIB_UNIT);
                unit = object6 != null ? LengthValue.Unit.valueOf((String)object6) : LengthValue.Unit.getBaseUnit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read length unit of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                unit = LengthValue.Unit.getBaseUnit();
            }
            object6 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (object6 == null && (object6 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC_BASE)) != null) {
                unit = LengthValue.Unit.getBaseUnit();
            }
            if (object6 == null && object != null) {
                try {
                    object6 = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object6 == null) {
                LOGGER.warn("Can't read length value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexLengthAttrib.setValue(new LengthValue((BigDecimal)object6, unit));
            return complexLengthAttrib;
        }
        if (abstractAttribImpl instanceof ComplexStringAttrib) {
            if (object == null) {
                return null;
            }
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
            long l2 = resultSet.getLong(FIELD_LANGUAGE_ID);
            if (l2 < 1L) {
                LOGGER.warn("No language ID is provided with string attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                LOGGER.warn("> attribute: " + openEstateAttrib);
                return null;
            }
            if (!map.containsKey(l2)) {
                LOGGER.warn("An unknown language ID is provided with string attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexStringAttrib.putValue(map.get(l2), (String)object);
            return complexStringAttrib;
        }
        if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
            VolumeValue.Unit unit;
            Object object7;
            ComplexVolumeAttrib complexVolumeAttrib = (ComplexVolumeAttrib)abstractAttribImpl;
            try {
                object7 = resultSet.getString(FIELD_ATTRIB_UNIT);
                unit = object7 != null ? VolumeValue.Unit.valueOf((String)object7) : VolumeValue.Unit.getBaseUnit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read volume unit of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                unit = VolumeValue.Unit.getBaseUnit();
            }
            object7 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC);
            if (object7 == null && (object7 = resultSet.getBigDecimal(FIELD_VALUE_NUMERIC_BASE)) != null) {
                unit = VolumeValue.Unit.getBaseUnit();
            }
            if (object7 == null && object != null) {
                try {
                    object7 = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object7 == null) {
                LOGGER.warn("Can't read volume value of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
                return null;
            }
            complexVolumeAttrib.setValue(new VolumeValue((BigDecimal)object7, unit));
            return complexVolumeAttrib;
        }
        if (abstractAttribImpl != null) {
            LOGGER.warn("Can't read class \"" + abstractAttribImpl.getClass().getName() + "\" of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
        } else {
            LOGGER.warn("Unknown class of attribute \"" + openEstateAttrib + "\" for object #" + l + "!");
        }
        return null;
    }

    protected DbObject buildObject(ResultSet resultSet) throws SQLException {
        DbObject dbObject = this.createObject();
        dbObject.id = resultSet.getLong(FIELD_OBJECT_ID);
        dbObject.contactId = resultSet.getLong(FIELD_CONTACT_ID);
        dbObject.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbObject.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbObject.item = new EstateImpl();
        dbObject.item.setId(String.valueOf(dbObject.id));
        dbObject.item.setPublicId(resultSet.getString(FIELD_OBJECT_PUBLIC_ID));
        dbObject.item.setGroupId(resultSet.getString(FIELD_OBJECT_GROUP_ID));
        dbObject.item.setCurrency(Currency.getInstance(resultSet.getString(FIELD_OBJECT_CURRENCY)));
        dbObject.item.setHiddenPrices(Boolean.valueOf(resultSet.getBoolean(FIELD_OBJECT_HIDDEN_PRICES)));
        dbObject.item.setPublishBegin((java.util.Date)resultSet.getDate(FIELD_OBJECT_PUBLISH_BEGIN));
        dbObject.item.setPublishEnd((java.util.Date)resultSet.getDate(FIELD_OBJECT_PUBLISH_END));
        dbObject.item.setType(resultSet.getString(FIELD_OBJECT_TYPE), resultSet.getString(FIELD_OBJECT_ACTION));
        EstateAddressImpl estateAddressImpl = dbObject.item.getAddress();
        estateAddressImpl.setCity(resultSet.getString(FIELD_ADDRESS_CITY));
        estateAddressImpl.setCountry(resultSet.getString(FIELD_ADDRESS_COUNTRY));
        estateAddressImpl.setDistrict(resultSet.getString(FIELD_ADDRESS_DISTRICT));
        estateAddressImpl.setPostalCode(resultSet.getString(FIELD_ADDRESS_POSTAL_CODE));
        estateAddressImpl.setPublished(resultSet.getBoolean(FIELD_ADDRESS_PUBLISHED));
        estateAddressImpl.setRegion(resultSet.getString(FIELD_ADDRESS_REGION));
        estateAddressImpl.setStreet(resultSet.getString(FIELD_ADDRESS_STREET));
        estateAddressImpl.setStreet2(resultSet.getString(FIELD_ADDRESS_STREET2));
        estateAddressImpl.setStreetNr(resultSet.getString(FIELD_ADDRESS_STREET_NR));
        estateAddressImpl.setLatitude(resultSet.getObject(FIELD_ADDRESS_LATITUDE) != null ? resultSet.getBigDecimal(FIELD_ADDRESS_LATITUDE) : null);
        estateAddressImpl.setLongitude(resultSet.getObject(FIELD_ADDRESS_LONGITUDE) != null ? resultSet.getBigDecimal(FIELD_ADDRESS_LONGITUDE) : null);
        return dbObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfFiles(Connection connection, long l, Boolean bl, String string) throws SQLException {
        int n;
        string = StringUtils.trimToNull((String)string);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl != null) {
                arrayList.add("file_published = ?");
            }
            if (string != null) {
                arrayList.add("file_mimetype ILIKE ?");
            }
            String string2 = "SELECT count(*) AS result FROM " + this.getSchemaPath("view_openestate_objects_files") + " WHERE " + FIELD_OBJECT_ID + " = ? ";
            if (!arrayList.isEmpty()) {
                string2 = string2 + "AND (" + StringUtils.join(arrayList, (String)") AND (") + ") ";
            }
            string2 = string2 + ";";
            preparedStatement = connection.prepareStatement(string2);
            int n2 = 0;
            preparedStatement.setLong(++n2, l);
            if (bl != null) {
                preparedStatement.setBoolean(++n2, bl);
            }
            if (string != null) {
                preparedStatement.setString(++n2, string);
            }
            n = (resultSet = preparedStatement.executeQuery()).next() ? resultSet.getInt("result") : 0;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObject[] getObjects(Connection connection, long[] lArray) throws SQLException {
        DbObject[] dbObjectArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbObject[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE " + FIELD_OBJECT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_OBJECT_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
            while (resultSet.next()) {
                arrayList.add(this.buildObject(resultSet));
            }
            dbObjectArray = arrayList.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObject[] getObjects(Connection connection, String[] stringArray) throws SQLException {
        DbObject[] dbObjectArray;
        if (stringArray != null && stringArray.length <= 0) {
            return new DbObject[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (stringArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE " + FIELD_OBJECT_PUBLIC_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)stringArray.length) + ") ORDER BY " + FIELD_OBJECT_ID + " ASC LIMIT " + stringArray.length + ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
            while (resultSet.next()) {
                arrayList.add(this.buildObject(resultSet));
            }
            dbObjectArray = arrayList.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObject[] getObjects(Connection connection, DbSearch dbSearch) throws SQLException {
        DbObject[] dbObjectArray;
        if (dbSearch == null || dbSearch.item == null) {
            return null;
        }
        NamedPreparedStatement namedPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.loadSearchConditions(dbSearch, arrayList, hashMap);
            String string = "SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ";
            if (!arrayList.isEmpty()) {
                string = string + "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ") ";
            }
            string = string + "ORDER BY object_id ASC;";
            namedPreparedStatement = new NamedPreparedStatement(connection, string);
            if (!hashMap.isEmpty()) {
                this.loadSearchParameters(namedPreparedStatement, hashMap);
            }
            resultSet = namedPreparedStatement.executeQuery();
            ArrayList<DbObject> arrayList2 = new ArrayList<DbObject>();
            while (resultSet.next()) {
                arrayList2.add(this.buildObject(resultSet));
            }
            dbObjectArray = arrayList2.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(namedPreparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((NamedPreparedStatement)namedPreparedStatement);
        return dbObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObject[] getObjectsByKeyword(Connection connection, String string, int n) throws SQLException {
        DbObject[] dbObjectArray;
        string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)string));
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (string == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE LOWER(" + FIELD_OBJECT_PUBLIC_ID + ") LIKE ? OR LOWER(" + FIELD_ADDRESS_CITY + ") LIKE ? OR LOWER(" + FIELD_ADDRESS_STREET + ") LIKE ? OR " + FIELD_OBJECT_ID + " IN (SELECT " + FIELD_OBJECT_ID + " FROM " + this.getSchemaPath(VIEW_OBJECTS_I18N) + " WHERE LOWER(" + FIELD_I18N_TITLE + ") LIKE ? ) ORDER BY " + FIELD_OBJECT_ID + " DESC " + (n > 0 ? "LIMIT " + n : "") + ";");
                int n2 = 0;
                preparedStatement.setString(++n2, "%" + string + "%");
                preparedStatement.setString(++n2, "%" + string + "%");
                preparedStatement.setString(++n2, "%" + string + "%");
                preparedStatement.setString(++n2, "%" + string + "%");
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
            while (resultSet.next()) {
                arrayList.add(this.buildObject(resultSet));
            }
            dbObjectArray = arrayList.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenEstateAction[] getObjectActions(Connection connection) throws SQLException {
        OpenEstateAction[] openEstateActionArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT object_action FROM " + this.getSchemaPath(VIEW_OBJECTS_ACTIONS) + " ORDER BY " + FIELD_OBJECT_ACTION + ";");
            resultSet = preparedStatement.executeQuery();
            ArrayList<OpenEstateAction> arrayList = new ArrayList<OpenEstateAction>();
            while (resultSet.next()) {
                openEstateActionArray = resultSet.getString(FIELD_OBJECT_ACTION);
                OpenEstateAction openEstateAction = OpenEstateUtils.lookupAction((String)openEstateActionArray);
                if (openEstateAction == null) {
                    LOGGER.warn("Unknown estate action \"" + (String)openEstateActionArray + "\"!");
                    continue;
                }
                arrayList.add(openEstateAction);
            }
            openEstateActionArray = arrayList.toArray(new OpenEstateAction[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return openEstateActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectId(Connection connection, String string) throws SQLException {
        long l;
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return 0L;
        }
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_GET_OBJECT_ID) + "(?);");
            callableStatement.setString(1, string);
            resultSet = callableStatement.executeQuery();
            l = resultSet.next() ? resultSet.getLong(1) : 0L;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(callableStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)callableStatement);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getObjectIds(Connection connection, long[] lArray) throws SQLException {
        long[] lArray2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null || lArray.length < 1) {
                preparedStatement = connection.prepareStatement("SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE " + FIELD_CONTACT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_OBJECT_ID + " ASC;");
                int n = 0;
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_OBJECT_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getObjectIds(Connection connection, DbSearch dbSearch) throws SQLException {
        long[] lArray;
        if (dbSearch == null || dbSearch.item == null) {
            return null;
        }
        NamedPreparedStatement namedPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.loadSearchConditions(dbSearch, arrayList, hashMap);
            String string = "SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS) + " ";
            if (!arrayList.isEmpty()) {
                string = string + "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ") ";
            }
            string = string + "ORDER BY object_id ASC;";
            namedPreparedStatement = new NamedPreparedStatement(connection, string);
            if (!hashMap.isEmpty()) {
                this.loadSearchParameters(namedPreparedStatement, hashMap);
            }
            resultSet = namedPreparedStatement.executeQuery();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getLong(FIELD_OBJECT_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(namedPreparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((NamedPreparedStatement)namedPreparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenEstateType[] getObjectTypes(Connection connection) throws SQLException {
        OpenEstateType[] openEstateTypeArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT object_type FROM " + this.getSchemaPath(VIEW_OBJECTS_TYPES) + " ORDER BY " + FIELD_OBJECT_TYPE + ";");
            resultSet = preparedStatement.executeQuery();
            ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
            while (resultSet.next()) {
                openEstateTypeArray = resultSet.getString(FIELD_OBJECT_TYPE);
                OpenEstateType openEstateType = OpenEstateUtils.lookupEstate((String)openEstateTypeArray);
                if (openEstateType == null) {
                    LOGGER.warn("Unsupported estate type \"" + (String)openEstateTypeArray + "\"!");
                    continue;
                }
                arrayList.add(openEstateType);
            }
            openEstateTypeArray = arrayList.toArray(new OpenEstateType[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return openEstateTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObjectAttribs(Connection connection, DbObject[] dbObjectArray, Map<Long, String> map) throws SQLException {
        ResultSet resultSet;
        HashMap<Long, DbObject> hashMap = new HashMap<Long, DbObject>();
        for (DbObject object2 : dbObjectArray) {
            if (object2.item == null || object2.id <= 0L || hashMap.containsKey(object2.id)) continue;
            hashMap.put(object2.id, object2);
        }
        int n = map.size();
        int n2 = hashMap.size();
        if (n2 < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS_ATTRIBS) + " WHERE " + FIELD_OBJECT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n2) + ") AND (" + FIELD_LANGUAGE_ID + " IS NULL OR " + FIELD_LANGUAGE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ) ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            int n3 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            for (Long l : map.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong(FIELD_OBJECT_ID);
                if (!hashMap.containsKey(l2)) continue;
                l = (DbObject)hashMap.get(l2);
                try {
                    AbstractAttribImpl abstractAttribImpl = this.buildAttrib(resultSet, map, ((DbObject)l).item);
                    if (abstractAttribImpl == null) continue;
                    ((DbObject)l).item.putAttribute(abstractAttribImpl);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read attribute \"" + resultSet.getString(FIELD_ATTRIB_NAME) + "\" for object #" + l2 + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet2);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObjectGeoDbAreas(Connection connection, DbObject[] dbObjectArray, DbGeoHandler dbGeoHandler) throws SQLException {
        HashMap<Long, DbObject> hashMap = new HashMap<Long, DbObject>();
        for (DbObject dbObject : dbObjectArray) {
            if (dbObject.item == null || dbObject.id <= 0L || hashMap.containsKey(dbObject.id)) continue;
            dbObject.geoDbAreas = new HashMap();
            hashMap.put(dbObject.id, dbObject);
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS_GEODBS_AREAS) + " WHERE " + FIELD_OBJECT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_OBJECT_ID);
                if (!hashMap.containsKey(l)) continue;
                DbObject dbObject = (DbObject)hashMap.get(l);
                long l2 = resultSet.getLong(FIELD_AREA_ID);
                DbGeoArea dbGeoArea = dbGeoHandler.getGeoArea(connection, l2);
                if (dbGeoArea == null) {
                    LOGGER.warn("Can't find geodb-area #" + l2 + "!");
                    continue;
                }
                Long l3 = resultSet.getLong(FIELD_GEODB_ID);
                dbObject.geoDbAreas.put(l3, dbGeoArea);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObjectTranslations(Connection connection, DbObject[] dbObjectArray, Map<Long, String> map) throws SQLException {
        ResultSet resultSet;
        HashMap<Long, DbObject> hashMap = new HashMap<Long, DbObject>();
        for (DbObject object2 : dbObjectArray) {
            if (object2.item == null || object2.id <= 0L || hashMap.containsKey(object2.id)) continue;
            object2.item.getLanguages().clear();
            hashMap.put(object2.id, object2);
        }
        int n = map.size();
        int n2 = hashMap.size();
        if (n2 < 1 || n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_OBJECTS_I18N) + " WHERE " + FIELD_OBJECT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n2) + ") AND " + FIELD_LANGUAGE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_OBJECT_ID + " ASC;");
            int n3 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            for (Long l : map.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong(FIELD_OBJECT_ID);
                if (!hashMap.containsKey(l2) || !map.containsKey(l = Long.valueOf(resultSet.getLong(FIELD_LANGUAGE_ID)))) continue;
                DbObject dbObject = (DbObject)hashMap.get(l2);
                String string = map.get(l);
                dbObject.item.getLanguages().add(string);
                dbObject.item.setTitle(resultSet.getString(FIELD_I18N_TITLE), string);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet2);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadSearchConditions(DbSearch dbSearch, List<String> list, Map<String, Object> map) {
        Object object;
        Object object2;
        Object object32;
        for (SearchImpl.SimpleConditionType object5 : SearchImpl.SimpleConditionType.values()) {
            if (SearchImpl.SimpleConditionType.ESTATE_TYPE.equals((Object)object5) || (object32 = dbSearch.item.getSimpleConditions(object5)) == null || object32.isEmpty()) continue;
            object2 = new ArrayList();
            Iterator iterator = object32.iterator();
            while (iterator.hasNext()) {
                void var13_39;
                SearchEqualsImpl searchEqualsImpl = (SearchEqualsImpl)iterator.next();
                String string = searchEqualsImpl.getValue();
                if (StringUtils.isBlank((CharSequence)string)) continue;
                if (SearchImpl.SimpleConditionType.CITY.equals((Object)object5)) {
                    String string2 = FIELD_ADDRESS_CITY;
                } else if (SearchImpl.SimpleConditionType.DISTRICT.equals((Object)object5)) {
                    String string3 = FIELD_ADDRESS_DISTRICT;
                } else if (SearchImpl.SimpleConditionType.COUNTRY.equals((Object)object5)) {
                    String string4 = FIELD_ADDRESS_COUNTRY;
                } else if (SearchImpl.SimpleConditionType.ESTATE_ACTION.equals((Object)object5)) {
                    String string5 = FIELD_OBJECT_ACTION;
                } else if (SearchImpl.SimpleConditionType.POSTAL_CODE.equals((Object)object5)) {
                    String string6 = FIELD_ADDRESS_POSTAL_CODE;
                } else if (SearchImpl.SimpleConditionType.REGION.equals((Object)object5)) {
                    String string7 = FIELD_ADDRESS_REGION;
                } else if (SearchImpl.SimpleConditionType.STREET.equals((Object)object5)) {
                    String string8 = FIELD_ADDRESS_STREET;
                } else if (SearchImpl.SimpleConditionType.STREET_NR.equals((Object)object5)) {
                    String string9 = FIELD_ADDRESS_STREET_NR;
                } else {
                    LOGGER.warn("Unknown type of search-condition: " + object5 + "!");
                    continue;
                }
                if (!searchEqualsImpl.isCaseSensitive()) {
                    void var13_48;
                    String string10 = "LOWER(" + (String)var13_48 + ")";
                    string = string.toLowerCase();
                }
                if (searchEqualsImpl.isLike()) {
                    object = "value" + map.size();
                    map.put((String)object, StringUtils.replace((String)string, (String)"*", (String)"%"));
                    object2.add((String)var13_39 + " LIKE :" + (String)object);
                    continue;
                }
                object = "value" + map.size();
                map.put((String)object, string);
                object2.add((String)var13_39 + " = :" + (String)object);
            }
            if (object2.isEmpty()) continue;
            String string = "SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE (" + StringUtils.join((Iterable)object2, (String)") OR (") + ")";
            list.add("object_id IN (" + string + ")");
        }
        List list2 = dbSearch.item.getSimpleConditions(SearchImpl.SimpleConditionType.ESTATE_TYPE);
        if (list2 != null && !list2.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object6 = list2.iterator();
            while (object6.hasNext()) {
                SearchEqualsImpl searchEqualsImpl = (SearchEqualsImpl)object6.next();
                object32 = searchEqualsImpl.getValue();
                if (StringUtils.isEmpty((CharSequence)object32) || (object2 = OpenEstateUtils.lookupEstate((String)object32)) == null || arrayList.contains(object2)) continue;
                arrayList.add(object2);
                for (OpenEstateType openEstateType : object2.getChildTypes(true)) {
                    if (arrayList.contains(openEstateType)) continue;
                    arrayList.add(openEstateType);
                }
            }
            if (!arrayList.isEmpty()) {
                object6 = new ArrayList();
                for (Object object32 : arrayList) {
                    object2 = "value" + map.size();
                    map.put((String)object2, object32.name());
                    object6.add(":" + (String)object2);
                }
                String string = "SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS) + " WHERE " + FIELD_OBJECT_TYPE + " IN (" + StringUtils.join((Iterable)object6, (String)", ") + ")";
                list.add("object_id IN (" + string + ")");
            }
        }
        EnumMap enumMap = new EnumMap(OpenEstateAttrib.class);
        for (SearchAttribImpl searchAttribImpl : dbSearch.item.getAttribConditions()) {
            void var13_98;
            String string;
            Object object4;
            Object object5;
            Object object6;
            object32 = searchAttribImpl.getAttribute();
            object2 = object32 != null ? object32.createImpl() : null;
            SearchEqualsImpl searchEqualsImpl = searchAttribImpl.getEqualsCondition();
            SearchNumericImpl searchNumericImpl = searchAttribImpl.getNumericCondition();
            SearchDateTimeImpl searchDateTimeImpl = searchAttribImpl.getDateTimeCondition();
            String string11 = "";
            if (object2 instanceof SimpleBooleanAttrib) {
                Object object7 = object = searchEqualsImpl != null ? searchEqualsImpl.getValue() : null;
                if (object != null) {
                    try {
                        object6 = Boolean.valueOf((String)object);
                        object5 = "value" + map.size();
                        map.put((String)object5, object6);
                        String string12 = "value_boolean = :" + (String)object5;
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Illegal boolean value!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        continue;
                    }
                }
            } else if (object2 instanceof SimpleEnumAttrib) {
                Object object8 = object = searchEqualsImpl != null ? searchEqualsImpl.getValue() : null;
                if (object != null) {
                    object6 = "value" + map.size();
                    map.put((String)object6, object);
                    String string13 = "value_string = :" + (String)object6 + " OR " + FIELD_VALUE_TEXT + " = :" + (String)object6;
                }
            } else if (object2 instanceof SimpleNumericAttrib) {
                object = (SimpleNumericAttrib)object2;
                Object object9 = object6 = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
                if (object6 != null && ((BigDecimal)object6).compareTo(BigDecimal.ZERO) > 0) {
                    object5 = object.getPrecision() > 0 ? object6 : ((BigDecimal)object6).toBigInteger();
                    object4 = "value" + map.size();
                    map.put((String)object4, object5);
                    String string14 = string11 + "value_numeric >= :" + (String)object4;
                }
                Object object10 = object5 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
                if (object5 != null && ((BigDecimal)object5).compareTo(BigDecimal.ZERO) > 0) {
                    void var13_61;
                    void var13_59;
                    Object object11 = object4 = object.getPrecision() > 0 ? object5 : ((BigDecimal)object5).toBigInteger();
                    if (var13_59.length() > 0) {
                        String string15 = (String)var13_59 + " AND ";
                    }
                    string = "value" + map.size();
                    map.put(string, object4);
                    String string16 = (String)var13_61 + "value_numeric <= :" + string;
                }
            } else if (object2 instanceof SimpleTimeAttrib) {
                object = (SimpleTimeAttrib)object2;
                object6 = searchDateTimeImpl != null ? searchDateTimeImpl.getBegin() : null;
                Object object12 = object5 = searchDateTimeImpl != null ? searchDateTimeImpl.getEnd() : null;
                if (object.isDate()) {
                    object4 = FIELD_VALUE_DATE;
                } else if (object.isTime()) {
                    object4 = FIELD_VALUE_TIME;
                } else {
                    if (!object.isDateTime()) continue;
                    object4 = FIELD_VALUE_DATETIME;
                }
                if (object6 != null) {
                    string = "value" + map.size();
                    if (object.isDate()) {
                        map.put(string, new Date(((java.util.Date)object6).getTime()));
                    } else if (object.isTime()) {
                        map.put(string, new Time(((java.util.Date)object6).getTime()));
                    } else if (object.isDateTime()) {
                        map.put(string, new Timestamp(((java.util.Date)object6).getTime()));
                    }
                    String string17 = string11 + (String)object4 + " >= :" + string;
                }
                if (object5 != null) {
                    void var13_67;
                    void var13_65;
                    if (var13_65.length() > 0) {
                        String string18 = (String)var13_65 + " AND ";
                    }
                    string = "value" + map.size();
                    if (object.isDate()) {
                        map.put(string, new Date(((java.util.Date)object5).getTime()));
                    } else if (object.isTime()) {
                        map.put(string, new Time(((java.util.Date)object5).getTime()));
                    } else if (object.isDateTime()) {
                        map.put(string, new Timestamp(((java.util.Date)object5).getTime()));
                    }
                    String string19 = (String)var13_67 + (String)object4 + " <= :" + string;
                }
            } else if (object2 instanceof ComplexAreaAttrib) {
                Object object13 = object = searchNumericImpl != null ? searchNumericImpl.getAreaUnit() : null;
                if (object == null) {
                    object = AreaValue.Unit.getBaseUnit();
                }
                Object object14 = object6 = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
                if (object6 != null && ((BigDecimal)object6).compareTo(BigDecimal.ZERO) > 0) {
                    object5 = object != AreaValue.Unit.getBaseUnit() ? AreaValue.convert((BigDecimal)object6, (AreaValue.Unit)object, (AreaValue.Unit)AreaValue.Unit.getBaseUnit()) : object6;
                    object4 = "value" + map.size();
                    map.put((String)object4, object5);
                    String string20 = string11 + "value_numeric_base >= :" + (String)object4;
                }
                Object object15 = object5 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
                if (object5 != null && ((BigDecimal)object5).compareTo(BigDecimal.ZERO) > 0) {
                    void var13_73;
                    void var13_71;
                    Object object16 = object4 = object != AreaValue.Unit.getBaseUnit() ? AreaValue.convert((BigDecimal)object5, (AreaValue.Unit)object, (AreaValue.Unit)AreaValue.Unit.getBaseUnit()) : object5;
                    if (var13_71.length() > 0) {
                        String string21 = (String)var13_71 + " AND ";
                    }
                    string = "value" + map.size();
                    map.put(string, object4);
                    String string22 = (String)var13_73 + "value_numeric_base <= :" + string;
                }
            } else if (object2 instanceof ComplexCurrencyAttrib) {
                Object object17 = object = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
                if (object != null && ((BigDecimal)object).compareTo(BigDecimal.ZERO) > 0) {
                    object6 = "value" + map.size();
                    map.put((String)object6, object);
                    String string23 = string11 + "value_numeric >= :" + (String)object6;
                }
                Object object18 = object6 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
                if (object6 != null && ((BigDecimal)object6).compareTo(BigDecimal.ZERO) > 0) {
                    void var13_79;
                    void var13_77;
                    if (var13_77.length() > 0) {
                        String string24 = (String)var13_77 + " AND ";
                    }
                    object5 = "value" + map.size();
                    map.put((String)object5, object6);
                    String string25 = (String)var13_79 + "value_numeric <= :" + (String)object5;
                }
            } else if (object2 instanceof ComplexEnumAttrib) {
                Object object19 = object = searchEqualsImpl != null ? searchEqualsImpl.getValue() : null;
                if (object != null) {
                    object6 = "value" + map.size();
                    map.put((String)object6, "%[" + (String)object + "]%");
                    String string26 = "value_string LIKE :" + (String)object6 + " OR " + FIELD_VALUE_TEXT + " LIKE :" + (String)object6;
                }
            } else if (object2 instanceof ComplexLengthAttrib) {
                Object object20 = object = searchNumericImpl != null ? searchNumericImpl.getLengthUnit() : null;
                if (object == null) {
                    object = LengthValue.Unit.getBaseUnit();
                }
                Object object21 = object6 = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
                if (object6 != null && ((BigDecimal)object6).compareTo(BigDecimal.ZERO) > 0) {
                    object5 = object != LengthValue.Unit.getBaseUnit() ? LengthValue.convert((BigDecimal)object6, (LengthValue.Unit)object, (LengthValue.Unit)LengthValue.Unit.getBaseUnit()) : object6;
                    object4 = "value" + map.size();
                    map.put((String)object4, object5);
                    String string27 = string11 + "value_numeric_base >= :" + (String)object4;
                }
                Object object22 = object5 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
                if (object5 != null && ((BigDecimal)object5).compareTo(BigDecimal.ZERO) > 0) {
                    void var13_87;
                    void var13_85;
                    Object object23 = object4 = object != LengthValue.Unit.getBaseUnit() ? LengthValue.convert((BigDecimal)object5, (LengthValue.Unit)object, (LengthValue.Unit)LengthValue.Unit.getBaseUnit()) : object5;
                    if (var13_85.length() > 0) {
                        String string28 = (String)var13_85 + " AND ";
                    }
                    string = "value" + map.size();
                    map.put(string, object4);
                    String string29 = (String)var13_87 + "value_numeric_base <= :" + string;
                }
            } else if (object2 instanceof ComplexStringAttrib) {
                Object object24 = object = searchEqualsImpl != null ? searchEqualsImpl.getValue() : null;
                if (object != null) {
                    object6 = FIELD_VALUE_STRING;
                    object5 = FIELD_VALUE_TEXT;
                    if (!searchEqualsImpl.isCaseSensitive()) {
                        object6 = "LOWER(" + (String)object6 + ")";
                        object5 = "LOWER(" + (String)object5 + ")";
                        object = ((String)object).toLowerCase();
                    }
                    if (searchEqualsImpl.isLike()) {
                        object4 = "value" + map.size();
                        map.put((String)object4, StringUtils.replace((String)object, (String)"*", (String)"%"));
                        String string30 = (String)object6 + " LIKE :" + (String)object4 + " OR " + (String)object5 + " LIKE :" + (String)object4;
                    } else {
                        object4 = "value" + map.size();
                        map.put((String)object4, object);
                        String string31 = (String)object6 + " = :" + (String)object4 + " OR " + (String)object5 + " = :" + (String)object4;
                    }
                }
            } else if (object2 instanceof ComplexVolumeAttrib) {
                Object object25 = object = searchNumericImpl != null ? searchNumericImpl.getVolumeUnit() : null;
                if (object == null) {
                    object = VolumeValue.Unit.getBaseUnit();
                }
                Object object26 = object6 = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
                if (object6 != null && ((BigDecimal)object6).compareTo(BigDecimal.ZERO) > 0) {
                    object5 = object != VolumeValue.Unit.getBaseUnit() ? VolumeValue.convert((BigDecimal)object6, (VolumeValue.Unit)object, (VolumeValue.Unit)VolumeValue.Unit.getBaseUnit()) : object6;
                    object4 = "value" + map.size();
                    map.put((String)object4, object5);
                    String string32 = string11 + "value_numeric_base >= :" + (String)object4;
                }
                Object object27 = object5 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
                if (object5 != null && ((BigDecimal)object5).compareTo(BigDecimal.ZERO) > 0) {
                    void var13_96;
                    void var13_94;
                    Object object28 = object4 = object != VolumeValue.Unit.getBaseUnit() ? VolumeValue.convert((BigDecimal)object5, (VolumeValue.Unit)object, (VolumeValue.Unit)VolumeValue.Unit.getBaseUnit()) : object5;
                    if (var13_94.length() > 0) {
                        String string33 = (String)var13_94 + " AND ";
                    }
                    string = "value" + map.size();
                    map.put(string, object4);
                    String string34 = (String)var13_96 + "value_numeric_base <= :" + string;
                }
            }
            if (StringUtils.isBlank((CharSequence)var13_98)) continue;
            if (!enumMap.containsKey(object32)) {
                enumMap.put((OpenEstateAttrib)object32, new ArrayList());
            }
            ((List)enumMap.get(object32)).add(var13_98);
        }
        for (Map.Entry entry : enumMap.entrySet()) {
            object32 = (OpenEstateAttrib)entry.getKey();
            object2 = (List)entry.getValue();
            if (object2.isEmpty()) continue;
            String string = "SELECT object_id FROM " + this.getSchemaPath(VIEW_OBJECTS_ATTRIBS) + " WHERE " + FIELD_ATTRIB_NAME + " = '" + object32.name() + "' AND ((" + StringUtils.join((Iterable)object2, (String)") OR (") + "))";
            list.add("object_id IN (" + string + ")");
        }
    }

    protected void loadSearchParameters(NamedPreparedStatement namedPreparedStatement, Map<String, Object> map) throws SQLException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof String) {
                namedPreparedStatement.setString(string, (String)object);
                continue;
            }
            if (object instanceof Boolean) {
                namedPreparedStatement.setBoolean(string, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Double) {
                namedPreparedStatement.setDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Long) {
                namedPreparedStatement.setLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof BigDecimal) {
                namedPreparedStatement.setBigDecimal(string, (BigDecimal)object);
                continue;
            }
            if (object instanceof BigInteger) {
                namedPreparedStatement.setLong(string, ((BigInteger)object).longValue());
                continue;
            }
            if (object instanceof Date) {
                namedPreparedStatement.setDate(string, (Date)object);
                continue;
            }
            if (object instanceof Time) {
                namedPreparedStatement.setTime(string, (Time)object);
                continue;
            }
            if (object instanceof Timestamp) {
                namedPreparedStatement.setTimestamp(string, (Timestamp)object);
                continue;
            }
            if (object instanceof Number) {
                namedPreparedStatement.setDouble(string, ((Number)object).doubleValue());
                continue;
            }
            LOGGER.warn("Unsupported criteria-value!");
            LOGGER.warn("> " + object);
            if (object != null) {
                LOGGER.warn("> " + object.getClass().getName());
            } else {
                LOGGER.warn("> NULL");
            }
            namedPreparedStatement.setNull(string, 12);
        }
    }

    public void removeObjects(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_OBJECTS) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveObject(Connection connection, DbObject dbObject, Map<Long, String> map, boolean bl, boolean bl2) throws SQLException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl3;
        block40: {
            bl3 = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                Object object;
                Object object2;
                Object object3;
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_OBJECTS) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_CONTACT_ID + ", :" + FIELD_OBJECT_TYPE + ", :" + FIELD_OBJECT_ACTION + ", :" + FIELD_OBJECT_PUBLIC_ID + ", :" + FIELD_OBJECT_GROUP_ID + ", :" + FIELD_OBJECT_CURRENCY + ", :" + FIELD_OBJECT_HIDDEN_PRICES + ", :" + FIELD_OBJECT_PUBLISH_BEGIN + ", :" + FIELD_OBJECT_PUBLISH_END + ", :" + FIELD_ADDRESS_PUBLISHED + ", :" + FIELD_ADDRESS_STREET + ", :" + FIELD_ADDRESS_STREET2 + ", :" + FIELD_ADDRESS_STREET_NR + ", :" + FIELD_ADDRESS_POSTAL_CODE + ", :" + FIELD_ADDRESS_CITY + ", :" + FIELD_ADDRESS_DISTRICT + ", :" + FIELD_ADDRESS_COUNTRY + ", :" + FIELD_ADDRESS_REGION + ", :" + FIELD_ADDRESS_LATITUDE + ", :" + FIELD_ADDRESS_LONGITUDE + ");");
                namedCallableStatement.setLong(FIELD_OBJECT_ID, dbObject.id);
                namedCallableStatement.setBoolean(FIELD_OBJECT_HIDDEN_PRICES, dbObject.item.isHiddenPrices());
                namedCallableStatement.setBoolean(FIELD_ADDRESS_PUBLISHED, dbObject.item.isAddressPublished());
                namedCallableStatement.setString(FIELD_ADDRESS_STREET, StringUtils.abbreviate((String)dbObject.item.getAddress().getStreet(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_STREET2, StringUtils.abbreviate((String)dbObject.item.getAddress().getStreet2(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_STREET_NR, StringUtils.abbreviate((String)dbObject.item.getAddress().getStreetNr(), (int)20));
                namedCallableStatement.setString(FIELD_ADDRESS_POSTAL_CODE, StringUtils.abbreviate((String)dbObject.item.getAddress().getPostalCode(), (int)10));
                namedCallableStatement.setString(FIELD_ADDRESS_CITY, StringUtils.abbreviate((String)dbObject.item.getAddress().getCity(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_DISTRICT, StringUtils.abbreviate((String)dbObject.item.getAddress().getDistrict(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_REGION, StringUtils.abbreviate((String)dbObject.item.getAddress().getRegion(), (int)150));
                String string = StringUtils.trimToNull((String)dbObject.item.getAddress().getCountry());
                if (string != null && string.length() == 2) {
                    namedCallableStatement.setString(FIELD_ADDRESS_COUNTRY, string);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_COUNTRY, 12);
                }
                String object4 = StringUtils.trimToNull((String)dbObject.item.getPublicId());
                if (object4 != null) {
                    namedCallableStatement.setString(FIELD_OBJECT_PUBLIC_ID, StringUtils.abbreviate((String)object4, (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_OBJECT_PUBLIC_ID, 12);
                }
                String string2 = StringUtils.trimToNull((String)dbObject.item.getGroupId());
                if (string2 != null) {
                    namedCallableStatement.setString(FIELD_OBJECT_GROUP_ID, StringUtils.abbreviate((String)string2, (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_OBJECT_GROUP_ID, 12);
                }
                if (dbObject.contactId > 0L) {
                    namedCallableStatement.setLong(FIELD_CONTACT_ID, dbObject.contactId);
                } else {
                    namedCallableStatement.setNull(FIELD_CONTACT_ID, -5);
                }
                OpenEstateAction openEstateAction = dbObject.item.getAction();
                namedCallableStatement.setString(FIELD_OBJECT_ACTION, openEstateAction != null ? StringUtils.abbreviate((String)openEstateAction.name(), (int)100) : null);
                OpenEstateType openEstateType = dbObject.item.getType();
                namedCallableStatement.setString(FIELD_OBJECT_TYPE, openEstateType != null ? StringUtils.abbreviate((String)openEstateType.name(), (int)100) : null);
                Currency currency = dbObject.item.getCurrency();
                namedCallableStatement.setString(FIELD_OBJECT_CURRENCY, currency != null ? currency.getCurrencyCode() : null);
                java.util.Date date = dbObject.item.getPublishBegin();
                if (date != null) {
                    namedCallableStatement.setTimestamp(FIELD_OBJECT_PUBLISH_BEGIN, new Timestamp(date.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_OBJECT_PUBLISH_BEGIN, 93);
                }
                java.util.Date date2 = dbObject.item.getPublishEnd();
                if (date2 != null) {
                    namedCallableStatement.setTimestamp(FIELD_OBJECT_PUBLISH_END, new Timestamp(date2.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_OBJECT_PUBLISH_END, 93);
                }
                BigDecimal bigDecimal = dbObject.item.getAddress().getLatitude();
                BigDecimal bigDecimal2 = new BigDecimal("-90");
                BigDecimal bigDecimal3 = new BigDecimal("90");
                if (bigDecimal != null && bigDecimal.compareTo(bigDecimal2) >= 0 && bigDecimal.compareTo(bigDecimal3) <= 0) {
                    namedCallableStatement.setBigDecimal(FIELD_ADDRESS_LATITUDE, bigDecimal);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_LATITUDE, 3);
                }
                BigDecimal bigDecimal4 = dbObject.item.getAddress().getLongitude();
                BigDecimal bigDecimal5 = new BigDecimal("-180");
                BigDecimal bigDecimal6 = new BigDecimal("180");
                if (bigDecimal4 != null && bigDecimal4.compareTo(bigDecimal5) >= 0 && bigDecimal4.compareTo(bigDecimal6) <= 0) {
                    namedCallableStatement.setBigDecimal(FIELD_ADDRESS_LONGITUDE, bigDecimal4);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_LONGITUDE, 3);
                }
                namedCallableStatement.execute();
                long l2 = l = dbObject.id < 1L ? namedCallableStatement.getLong(FIELD_OBJECT_ID) : dbObject.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveObjectAdditionally(connection, dbObject, l, arrayList);
                if (dbObject.geoDbAreas != null) {
                    if (dbObject.id > 0L) {
                        object3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_OBJECTS_GEODBS_AREAS) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_AREA_ID + ");");
                        object3.setLong(FIELD_OBJECT_ID, dbObject.id);
                        object3.setNull(FIELD_AREA_ID, -5);
                        object3.execute();
                        arrayList.add(object3.getStatement());
                    }
                    object3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_OBJECTS_GEODBS_AREAS) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_AREA_ID + ");");
                    for (DbGeoArea dbGeoArea : dbObject.geoDbAreas.values()) {
                        if (dbGeoArea.id < 1L) continue;
                        object3.clearParameters();
                        object3.setLong(FIELD_OBJECT_ID, l);
                        object3.setLong(FIELD_AREA_ID, dbGeoArea.id);
                        object3.execute();
                        arrayList.add(object3.getStatement());
                    }
                }
                if (bl && map != null && !map.isEmpty()) {
                    if (dbObject.id > 0L) {
                        object3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_OBJECTS_I18N) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_LANGUAGE_ID + ");");
                        for (Long l3 : map.keySet()) {
                            object3.clearParameters();
                            object3.setLong(FIELD_OBJECT_ID, dbObject.id);
                            object3.setLong(FIELD_LANGUAGE_ID, l3.longValue());
                            object3.execute();
                            arrayList.add(object3.getStatement());
                        }
                    }
                    object3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_OBJECTS_I18N) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_LANGUAGE_ID + ", :" + FIELD_I18N_TITLE + ");");
                    for (Map.Entry entry : map.entrySet()) {
                        Long l4 = (Long)entry.getKey();
                        object2 = (String)entry.getValue();
                        if (!dbObject.item.getLanguages().contains(object2)) continue;
                        object = StringUtils.trimToNull((String)dbObject.item.getTitle((String)object2));
                        object3.clearParameters();
                        object3.setLong(FIELD_OBJECT_ID, l);
                        object3.setLong(FIELD_LANGUAGE_ID, l4.longValue());
                        object3.setString(FIELD_I18N_TITLE, StringUtils.abbreviate((String)object, (int)255));
                        object3.execute();
                        arrayList.add(object3.getStatement());
                    }
                }
                if (bl2 && map != null) {
                    object3 = null;
                    for (Map.Entry<Long, String> entry : map.entrySet()) {
                        long l5 = entry.getKey();
                        object = entry.getValue();
                        if (object != null) continue;
                        object3 = l5;
                        break;
                    }
                    if (object3 == null) {
                        throw new SQLException("Can't find NULL-language!");
                    }
                    if (dbObject.id > 0L) {
                        Iterator<Object> iterator = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_OBJECTS_ATTRIBS) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_LANGUAGE_ID + ", :" + FIELD_ATTRIB_NAME + ");");
                        for (Long l6 : map.keySet()) {
                            iterator.clearParameters();
                            iterator.setLong(FIELD_OBJECT_ID, dbObject.id);
                            iterator.setLong(FIELD_LANGUAGE_ID, l6);
                            iterator.setNull(FIELD_ATTRIB_NAME, 12);
                            iterator.execute();
                            arrayList.add(iterator.getStatement());
                        }
                    }
                    for (AbstractAttribImpl abstractAttribImpl : dbObject.item.getAttributes().values()) {
                        if (abstractAttribImpl.hasEmptyValue()) continue;
                        try {
                            ComplexStringAttrib complexStringAttrib;
                            if (abstractAttribImpl instanceof ComplexStringAttrib) {
                                complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
                                object2 = Arrays.asList(complexStringAttrib.getValueLanguages());
                                for (Map.Entry entry : map.entrySet()) {
                                    NamedCallableStatement namedCallableStatement2;
                                    long l7 = (Long)entry.getKey();
                                    String string3 = (String)entry.getValue();
                                    if (string3 == null || !object2.contains(string3) || !dbObject.item.getLanguages().contains(string3) || (namedCallableStatement2 = this.saveObjectAttribute(connection, (AbstractAttribImpl)complexStringAttrib, l, l7, string3, dbObject.item.getCurrency())) == null) continue;
                                    namedCallableStatement2.execute();
                                    arrayList.add(namedCallableStatement2.getStatement());
                                }
                                continue;
                            }
                            complexStringAttrib = this.saveObjectAttribute(connection, abstractAttribImpl, l, (Long)object3, null, dbObject.item.getCurrency());
                            if (complexStringAttrib == null) continue;
                            complexStringAttrib.execute();
                            arrayList.add(complexStringAttrib.getStatement());
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't save attribute value for estate #" + l + "!");
                            LOGGER.warn("> attribute: " + abstractAttribImpl.getGroup().name() + " / " + abstractAttribImpl.getAttrib().name());
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                    }
                }
                connection.commit();
                if (dbObject.id >= 1L) break block40;
                dbObject.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl3);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl3);
    }

    protected void saveObjectAdditionally(Connection connection, DbObject dbObject, long l, List<Statement> list) throws SQLException {
    }

    private NamedCallableStatement saveObjectAttribute(Connection connection, AbstractAttribImpl abstractAttribImpl, long l, long l2, String string, Currency currency) throws SQLException {
        OpenEstateAttrib openEstateAttrib = abstractAttribImpl.getAttrib();
        NamedCallableStatement namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_OBJECTS_ATTRIBS) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_LANGUAGE_ID + ", :" + FIELD_ATTRIB_NAME + ", :" + FIELD_ATTRIB_UNIT + ", :" + FIELD_VALUE_TEXT + ", :" + FIELD_VALUE_STRING + ", :" + FIELD_VALUE_BOOLEAN + ", :" + FIELD_VALUE_NUMERIC + ", :" + FIELD_VALUE_NUMERIC_BASE + ", :" + FIELD_VALUE_DATE + ", :" + FIELD_VALUE_TIME + ", :" + FIELD_VALUE_DATETIME + ");");
        namedCallableStatement.setLong(FIELD_OBJECT_ID, l);
        namedCallableStatement.setLong(FIELD_LANGUAGE_ID, l2);
        namedCallableStatement.setString(FIELD_ATTRIB_NAME, openEstateAttrib != null ? StringUtils.abbreviate((String)openEstateAttrib.name(), (int)255) : null);
        namedCallableStatement.setNull(FIELD_ATTRIB_UNIT, 12);
        namedCallableStatement.setNull(FIELD_VALUE_TEXT, 12);
        namedCallableStatement.setNull(FIELD_VALUE_STRING, 12);
        namedCallableStatement.setNull(FIELD_VALUE_BOOLEAN, 16);
        namedCallableStatement.setNull(FIELD_VALUE_NUMERIC, 3);
        namedCallableStatement.setNull(FIELD_VALUE_NUMERIC_BASE, 3);
        namedCallableStatement.setNull(FIELD_VALUE_DATE, 91);
        namedCallableStatement.setNull(FIELD_VALUE_TIME, 92);
        namedCallableStatement.setNull(FIELD_VALUE_DATETIME, 93);
        if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
            SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)abstractAttribImpl;
            Boolean bl = simpleBooleanAttrib.getValue();
            if (bl != null) {
                namedCallableStatement.setBoolean(FIELD_VALUE_BOOLEAN, bl.booleanValue());
            }
        } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
            SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
            Enum enum_ = simpleEnumAttrib.getValue();
            if (enum_ != null) {
                String string2 = enum_.name();
                if (string2.length() > 255) {
                    namedCallableStatement.setString(FIELD_VALUE_TEXT, string2);
                } else {
                    namedCallableStatement.setString(FIELD_VALUE_STRING, string2);
                }
            }
        } else if (abstractAttribImpl instanceof SimpleNumericAttrib) {
            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)abstractAttribImpl;
            Number number = simpleNumericAttrib.getValue();
            if (number != null) {
                if (number instanceof BigDecimal) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, (BigDecimal)number);
                } else if (number instanceof BigInteger) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, new BigDecimal((BigInteger)number));
                } else if (number instanceof Double) {
                    namedCallableStatement.setDouble(FIELD_VALUE_NUMERIC, ((Double)number).doubleValue());
                } else if (number instanceof Long) {
                    namedCallableStatement.setLong(FIELD_VALUE_NUMERIC, ((Long)number).longValue());
                } else if (simpleNumericAttrib.getPrecision() > 0) {
                    namedCallableStatement.setDouble(FIELD_VALUE_NUMERIC, number.doubleValue());
                } else {
                    namedCallableStatement.setLong(FIELD_VALUE_NUMERIC, number.longValue());
                }
            }
        } else if (abstractAttribImpl instanceof SimpleTimeAttrib) {
            SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)abstractAttribImpl;
            java.util.Date date = simpleTimeAttrib.getValue();
            if (date != null) {
                if (simpleTimeAttrib.isDate()) {
                    namedCallableStatement.setDate(FIELD_VALUE_DATE, new Date(date.getTime()));
                } else if (simpleTimeAttrib.isTime()) {
                    namedCallableStatement.setTime(FIELD_VALUE_TIME, new Time(date.getTime()));
                } else if (simpleTimeAttrib.isDateTime()) {
                    namedCallableStatement.setTimestamp(FIELD_VALUE_DATETIME, new Timestamp(date.getTime()));
                }
            }
        } else if (abstractAttribImpl instanceof ComplexAreaAttrib) {
            ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)abstractAttribImpl;
            AreaValue areaValue = complexAreaAttrib.getValue();
            if (areaValue != null) {
                AreaValue.Unit unit = areaValue.getUnit();
                if (unit == null) {
                    unit = AreaValue.Unit.getBaseUnit();
                }
                namedCallableStatement.setString(FIELD_ATTRIB_UNIT, StringUtils.abbreviate((String)unit.name(), (int)25));
                namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, areaValue.getValue());
                if (unit != AreaValue.Unit.getBaseUnit()) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, AreaValue.convert((AreaValue)areaValue, (AreaValue.Unit)AreaValue.Unit.getBaseUnit()));
                } else {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, areaValue.getValue());
                }
            }
        } else if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
            ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)abstractAttribImpl;
            CurrencyValue currencyValue = complexCurrencyAttrib.getValue();
            if (currencyValue != null) {
                namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, currencyValue.getValue());
            }
        } else if (abstractAttribImpl instanceof ComplexEnergyConsumptionAttrib) {
            ComplexEnergyConsumptionAttrib complexEnergyConsumptionAttrib = (ComplexEnergyConsumptionAttrib)abstractAttribImpl;
            EnergyConsumptionValue energyConsumptionValue = complexEnergyConsumptionAttrib.getValue();
            if (energyConsumptionValue != null) {
                EnergyConsumptionValue.Unit unit = energyConsumptionValue.getUnit();
                if (unit == null) {
                    unit = EnergyConsumptionValue.Unit.getBaseUnit();
                }
                namedCallableStatement.setString(FIELD_ATTRIB_UNIT, StringUtils.abbreviate((String)unit.name(), (int)25));
                namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, energyConsumptionValue.getValue());
                if (unit != EnergyConsumptionValue.Unit.getBaseUnit()) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, EnergyConsumptionValue.convert((EnergyConsumptionValue)energyConsumptionValue, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.getBaseUnit()));
                } else {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, energyConsumptionValue.getValue());
                }
            }
        } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
            Object[] objectArray = complexEnumAttrib.getValue();
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                namedCallableStatement.setString(FIELD_VALUE_TEXT, "[" + StringUtils.join((Object[])objectArray, (String)"][") + "]");
            }
        } else if (abstractAttribImpl instanceof ComplexLengthAttrib) {
            ComplexLengthAttrib complexLengthAttrib = (ComplexLengthAttrib)abstractAttribImpl;
            LengthValue lengthValue = complexLengthAttrib.getValue();
            if (lengthValue != null) {
                LengthValue.Unit unit = lengthValue.getUnit();
                if (unit == null) {
                    unit = LengthValue.Unit.getBaseUnit();
                }
                namedCallableStatement.setString(FIELD_ATTRIB_UNIT, StringUtils.abbreviate((String)unit.name(), (int)25));
                namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, lengthValue.getValue());
                if (unit != LengthValue.Unit.getBaseUnit()) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, LengthValue.convert((LengthValue)lengthValue, (LengthValue.Unit)LengthValue.Unit.getBaseUnit()));
                } else {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, lengthValue.getValue());
                }
            }
        } else if (abstractAttribImpl instanceof ComplexStringAttrib) {
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
            String string3 = complexStringAttrib.getValue(string);
            if (string3 != null) {
                if (string3.length() > 255) {
                    namedCallableStatement.setString(FIELD_VALUE_TEXT, string3);
                } else {
                    namedCallableStatement.setString(FIELD_VALUE_STRING, string3);
                }
            }
        } else if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
            ComplexVolumeAttrib complexVolumeAttrib = (ComplexVolumeAttrib)abstractAttribImpl;
            VolumeValue volumeValue = complexVolumeAttrib.getValue();
            if (volumeValue != null) {
                VolumeValue.Unit unit = volumeValue.getUnit();
                if (unit == null) {
                    unit = VolumeValue.Unit.getBaseUnit();
                }
                namedCallableStatement.setString(FIELD_ATTRIB_UNIT, StringUtils.abbreviate((String)unit.name(), (int)25));
                namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC, volumeValue.getValue());
                if (unit != VolumeValue.Unit.getBaseUnit()) {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, VolumeValue.convert((VolumeValue)volumeValue, (VolumeValue.Unit)VolumeValue.Unit.getBaseUnit()));
                } else {
                    namedCallableStatement.setBigDecimal(FIELD_VALUE_NUMERIC_BASE, volumeValue.getValue());
                }
            }
        } else {
            LOGGER.warn("Can't save unknown attribute-type!");
            if (openEstateAttrib != null) {
                LOGGER.warn("> " + openEstateAttrib.getClass().getName());
            } else {
                LOGGER.warn("> NULL");
            }
            return null;
        }
        return namedCallableStatement;
    }

    public void setObjectContactId(Connection connection, long[] lArray, long l) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SET_OBJECTS_CONTACT) + "(:" + FIELD_OBJECT_ID + ", :" + FIELD_CONTACT_ID + ");");
            for (long l2 : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_OBJECT_ID, l2);
                namedCallableStatement.setLong(FIELD_CONTACT_ID, l);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

