/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.DbContactsHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.gui.AgencyContacListCellRenderer;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyContactDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactDialog.class);
    private boolean submitted = false;
    private String infoText = null;
    private JComboBox<DbAgencyContact> contactBox;

    private AgencyContactDialog(Frame frame) {
        super(frame);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private AgencyContactDialog(Dialog dialog) {
        super(dialog);
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{new SubmitAction()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.contactBox = new JComboBox();
        this.contactBox.setRenderer((ListCellRenderer<DbAgencyContact>)((Object)new AgencyContacListCellRenderer()));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add(this.contactBox, "North");
        return jPanel;
    }

    private void doSubmit() {
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("select contact person"));
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_family.png", 32);
    }

    protected String getHeaderInfo() {
        return StringUtils.trimToEmpty((String)this.infoText);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("select contact person"));
    }

    private long getSelectedContactId() {
        DbAgencyContact dbAgencyContact = (DbAgencyContact)((Object)this.contactBox.getSelectedItem());
        return dbAgencyContact != null ? dbAgencyContact.id : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, Filter filter) throws SQLException {
        Connection connection = null;
        try {
            connection = abstractDbDriver.getConnection();
            this.load(connection, dbContactsHandler, filter);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    private void load(Connection connection, DbContactsHandler dbContactsHandler, Filter filter) throws SQLException {
        DefaultComboBoxModel<DbAgencyContact> defaultComboBoxModel = new DefaultComboBoxModel<DbAgencyContact>();
        defaultComboBoxModel.addElement(null);
        for (DbContact dbContact : dbContactsHandler.getContacts(connection)) {
            DbAgencyContact dbAgencyContact = (DbAgencyContact)dbContact;
            if (filter != null && !filter.canLoadIntoSelection(dbAgencyContact)) continue;
            defaultComboBoxModel.addElement(dbAgencyContact);
        }
        this.contactBox.setModel(defaultComboBoxModel);
        this.contactBox.setSelectedItem(null);
    }

    private void setInfoText(String string) {
        this.infoText = StringUtils.trimToNull((String)string);
        this.updateLocalization();
    }

    public static Long showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(abstractDbDriver, dbContactsHandler, null, null, window);
    }

    public static Long showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, Filter filter, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(abstractDbDriver, dbContactsHandler, filter, null, window);
    }

    public static Long showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, String string, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(abstractDbDriver, dbContactsHandler, null, string, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, Filter filter, String string, Window window) throws SQLException {
        Long l;
        AgencyContactDialog agencyContactDialog = null;
        try {
            agencyContactDialog = window instanceof Dialog ? new AgencyContactDialog((Dialog)window) : (window instanceof Frame ? new AgencyContactDialog((Frame)window) : new AgencyContactDialog((Frame)null));
            agencyContactDialog.load(abstractDbDriver, dbContactsHandler, filter);
            if (!StringUtils.isBlank((CharSequence)string)) {
                agencyContactDialog.setInfoText(string);
                agencyContactDialog.pack();
            }
            agencyContactDialog.setVisible(true);
            l = agencyContactDialog.submitted ? Long.valueOf(agencyContactDialog.getSelectedContactId()) : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(agencyContactDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)agencyContactDialog));
        return l;
    }

    public static Long showDialog(Connection connection, DbContactsHandler dbContactsHandler, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(connection, dbContactsHandler, null, null, window);
    }

    public static Long showDialog(Connection connection, DbContactsHandler dbContactsHandler, Filter filter, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(connection, dbContactsHandler, filter, null, window);
    }

    public static Long showDialog(Connection connection, DbContactsHandler dbContactsHandler, String string, Window window) throws SQLException {
        return AgencyContactDialog.showDialog(connection, dbContactsHandler, null, string, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long showDialog(Connection connection, DbContactsHandler dbContactsHandler, Filter filter, String string, Window window) throws SQLException {
        Long l;
        AgencyContactDialog agencyContactDialog = null;
        try {
            agencyContactDialog = window instanceof Dialog ? new AgencyContactDialog((Dialog)window) : (window instanceof Frame ? new AgencyContactDialog((Frame)window) : new AgencyContactDialog((Frame)null));
            agencyContactDialog.load(connection, dbContactsHandler, filter);
            if (!StringUtils.isBlank((CharSequence)string)) {
                agencyContactDialog.setInfoText(string);
                agencyContactDialog.pack();
            }
            agencyContactDialog.setVisible(true);
            l = agencyContactDialog.submitted ? Long.valueOf(agencyContactDialog.getSelectedContactId()) : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(agencyContactDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)agencyContactDialog));
        return l;
    }

    public static interface Filter {
        public boolean canLoadIntoSelection(DbAgencyContact var1);
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select")));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
        }
    }
}

