/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.gui.AbstractTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactTable.class);

    public AgencyContactTable(String string) {
        super(string);
    }

    public AgencyContactTable(String string, AbstractTable.Model<R> model) {
        super(string);
    }

    public Long getContactIdAt(int n) {
        DbAgencyContact dbAgencyContact = this.getContactAt(n);
        return dbAgencyContact != null ? Long.valueOf(dbAgencyContact.id) : null;
    }

    public DbAgencyContact getContactAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getContact() : null;
    }

    public int getRowForContactId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getContactIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        super.init();
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbAgencyContact contact;

        public Row(DbAgencyContact dbAgencyContact) {
            this.contact = dbAgencyContact;
        }

        public DbAgencyContact getContact() {
            return this.contact;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForEstate((Column)column);
            }
            return null;
        }

        public Object getValueForEstate(Column column) {
            if (this.contact == null) {
                return null;
            }
            AgentContactImpl agentContactImpl = this.contact.item;
            switch (column) {
                case ID: {
                    return this.contact.id;
                }
                case CITY: {
                    return agentContactImpl != null ? agentContactImpl.getCity() : null;
                }
                case COUNTRY: {
                    return agentContactImpl != null ? agentContactImpl.writeCountry() : null;
                }
                case FAX: {
                    return agentContactImpl != null ? agentContactImpl.getPersonFax() : null;
                }
                case MAIL: {
                    return agentContactImpl != null ? agentContactImpl.getPersonMail() : null;
                }
                case LASTNAME: {
                    return agentContactImpl != null ? agentContactImpl.getPersonLastName() : null;
                }
                case FIRSTNAME: {
                    return agentContactImpl != null ? agentContactImpl.getPersonFirstName() : null;
                }
                case PHONE: {
                    return agentContactImpl != null ? agentContactImpl.getPersonPhone() : null;
                }
                case POSTALCODE: {
                    return agentContactImpl != null ? agentContactImpl.getPostalCode() : null;
                }
                case STREET: {
                    return agentContactImpl != null ? agentContactImpl.writeStreet() : null;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        LASTNAME,
        FIRSTNAME,
        STREET,
        POSTALCODE,
        CITY,
        COUNTRY,
        MAIL,
        PHONE,
        FAX;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                default: 
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case LASTNAME: 
                case FIRSTNAME: 
                case STREET: 
                case POSTALCODE: 
                case CITY: 
                case COUNTRY: 
                case MAIL: 
                case PHONE: 
                case FAX: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case LASTNAME: {
                    return StringUtils.capitalize((String)I18N.tr("last name"));
                }
                case FIRSTNAME: {
                    return StringUtils.capitalize((String)I18N.tr("first name"));
                }
                case STREET: {
                    return StringUtils.capitalize((String)I18N.tr("street"));
                }
                case POSTALCODE: {
                    return StringUtils.capitalize((String)I18N.tr("postcode"));
                }
                case CITY: {
                    return StringUtils.capitalize((String)I18N.tr("place"));
                }
                case COUNTRY: {
                    return StringUtils.capitalize((String)I18N.tr("country"));
                }
                case MAIL: {
                    return StringUtils.capitalize((String)I18N.tr("e-mail"));
                }
                case PHONE: {
                    return StringUtils.capitalize((String)I18N.tr("phone"));
                }
                case FAX: {
                    return StringUtils.capitalize((String)I18N.tr("fax"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

