/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.utils.GeoAreaPanel;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.CurrencyRenderer;
import com.openindex.openestate.tool.gui.DefaultAddressPanel;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.FlowPanel;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.forms.FormatterRule;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import com.openindex.openestate.tool.utils.geo.CoordinateFormat;
import com.openindex.openestate.tool.utils.geo.MapDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.java.balloontip.BalloonTip;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewSetupPanel
extends AgencyEstateViewPanel.AbstractTab
implements DisposableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewSetupPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewSetupPanel.class);
    private WeakReference<DbAgencyObject> currentObject = null;
    private MapDialog mapDialog = null;
    private ValidationHandler validationHandler;
    private ModificationHandler modifications;
    private JXTitledSeparator formTitle;
    private List<TitleField> titleFields;
    private JLabel idLabel;
    private JTextField idField;
    private JLabel nrLabel;
    private JTextField nrField;
    private JLabel nrInternLabel;
    private JTextField nrInternField;
    private JLabel groupLabel;
    private JFormattedTextField groupField;
    private JLabel publishBeginLabel;
    private DefaultDatePicker publishBeginField;
    private JLabel publishEndLabel;
    private DefaultDatePicker publishEndField;
    private JLabel currencyLabel;
    private JComboBox<Currency> currencyField;
    private JLabel statusLabel;
    private JComboBox<DbAgencyObject.Status> statusField;
    private JPanel addressPanel;
    private JComboBox<DbGeo> addressSwitchField;
    private DefaultAddressPanel addressMainPanel;
    private JXTitledSeparator addressTitle;
    private JCheckBox addressPublishField;
    private Map<Long, GeoAreaPanel> addressGeoPanels;
    private JXTitledSeparator geoTitle;
    private JCheckBox geoField;
    private JLabel geoLatitudeLabel;
    private JFormattedTextField geoLatitudeField;
    private JLabel geoLongitudeLabel;
    private JFormattedTextField geoLongitudeField;
    private AbstractI18nAction geoLookupAction;

    public AgencyEstateViewSetupPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.addressGeoPanels = new HashMap<Long, GeoAreaPanel>();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.idLabel = new JLabel();
        this.idField = new JTextField();
        this.idField.setColumns(10);
        this.idField.setEditable(false);
        this.nrLabel = new JLabel();
        this.nrField = new JTextField();
        this.nrField.setColumns(10);
        this.nrInternLabel = new JLabel();
        this.nrInternField = new JTextField();
        this.nrInternField.setColumns(10);
        this.nrInternField.setEditable(false);
        this.publishBeginLabel = new JLabel();
        this.publishBeginField = new DefaultDatePicker();
        this.publishEndLabel = new JLabel();
        this.publishEndField = new DefaultDatePicker();
        this.currencyLabel = new JLabel();
        this.currencyField = new JComboBox();
        DefaultComboBoxModel<Currency> defaultComboBoxModel = new DefaultComboBoxModel<Currency>();
        Currency currency = ImmoToolUtils.getDefaultCurrency();
        int n = -1;
        int n2 = -1;
        for (String string : ImmoToolUtils.getCurrencyCodes()) {
            ++n;
            defaultComboBoxModel.addElement(Currency.getInstance(string));
            if (currency == null || !currency.getCurrencyCode().equals(string)) continue;
            n2 = n;
        }
        this.currencyField.setRenderer((ListCellRenderer<Currency>)new DefaultListCellRenderer((Renderer)new CurrencyRenderer()));
        this.currencyField.setModel(defaultComboBoxModel);
        if (n2 > -1) {
            this.currencyField.setSelectedIndex(n2);
        }
        this.statusLabel = new JLabel();
        this.statusField = new JComboBox();
        this.statusField.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS));
        this.statusField.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("no status selected") + " ]";
            }
        }));
        this.statusField.addItem(null);
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            this.statusField.addItem(status);
        }
        this.titleFields = new ArrayList<TitleField>();
        TreeMap treeMap = new TreeMap();
        for (Locale serializable2 : AgencyPlugin.getLocales()) {
            treeMap.put(serializable2.getDisplayLanguage(), serializable2);
        }
        for (Locale locale : treeMap.values()) {
            TitleField titleField = new TitleField(locale);
            this.titleFields.add(titleField);
            this.validationHandler.putRule((JComponent)titleField.textField, ValidationHandler.NOT_BLANK);
        }
        this.groupLabel = new JLabel();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMaximumIntegerDigits(10);
        this.groupField = new JFormattedTextField(numberFormat);
        this.geoTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.geoLookupAction = new GeoLookupAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.geoTitle, (Action[])new Action[]{this.geoLookupAction});
        CoordinateFormat coordinateFormat = new CoordinateFormat();
        this.geoField = new JCheckBox();
        this.geoField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyEstateViewSetupPanel.this.geoLatitudeField.setEnabled(AgencyEstateViewSetupPanel.this.geoField.isSelected());
                AgencyEstateViewSetupPanel.this.geoLongitudeField.setEnabled(AgencyEstateViewSetupPanel.this.geoField.isSelected());
                AgencyEstateViewSetupPanel.this.validationHandler.validate((JComponent)AgencyEstateViewSetupPanel.this.geoLatitudeField);
                AgencyEstateViewSetupPanel.this.validationHandler.validate((JComponent)AgencyEstateViewSetupPanel.this.geoLongitudeField);
            }
        });
        this.geoLatitudeLabel = new JLabel();
        this.geoLatitudeField = new JFormattedTextField((Format)coordinateFormat);
        this.geoLatitudeField.setColumns(10);
        this.geoLongitudeLabel = new JLabel();
        this.geoLongitudeField = new JFormattedTextField((Format)coordinateFormat);
        this.geoLongitudeField.setColumns(10);
        this.addressPublishField = new JCheckBox();
        this.addressPublishField.setVerticalAlignment(1);
        this.addressPublishField.setVerticalTextPosition(1);
        this.addressMainPanel = new DefaultAddressPanel(new AddressImpl(), 1, 50){

            protected void finishAddressPanel(DefaultFormBuilder defaultFormBuilder) {
                FlowPanel flowPanel = FlowPanel.create((JComponent[])new JComponent[]{AgencyEstateViewSetupPanel.this.addressPublishField});
                defaultFormBuilder.add((Component)flowPanel).xyw(3, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns() - 2);
            }

            protected String getTitleForAddressForm() {
                return null;
            }

            protected void init() {
                this.registerValidation(this.addressCityField);
                this.registerValidation(this.addressPostalCodeField);
                this.registerValidation(this.addressCountryField);
                this.addressCountryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = AgencyEstateViewSetupPanel.this.addressMainPanel.getSelectedCountry();
                        String string2 = AgencyEstateViewSetupPanel.this.addressMainPanel.getSelectedCountryName();
                        AgencyEstateViewSetupPanel.this.getViewPanel().setEstateCountry(string);
                        for (GeoAreaPanel geoAreaPanel : AgencyEstateViewSetupPanel.this.addressGeoPanels.values()) {
                            geoAreaPanel.setCountry(string, string2, true);
                        }
                    }
                });
            }
        };
        this.addressMainPanel.setBorder((Border)Paddings.EMPTY);
        this.addressPanel = new JPanel(new BorderLayout());
        this.addressPanel.add((Component)this.addressMainPanel, "Center");
        this.addressSwitchField = new JComboBox();
        this.addressSwitchField.setRenderer((ListCellRenderer<DbGeo>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<DbGeo>(){

            public void render(DbGeo dbGeo, JLabel jLabel) {
                if (dbGeo != null) {
                    jLabel.setText(I18N.tr("regions of {0}", (Object)dbGeo.name));
                } else {
                    jLabel.setText(I18N.tr("property address"));
                }
            }
        }));
        this.addressSwitchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbGeo dbGeo;
                int n = AgencyEstateViewSetupPanel.this.addressSwitchField.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                Object object = (dbGeo = (DbGeo)AgencyEstateViewSetupPanel.this.addressSwitchField.getItemAt(n)) != null ? (AgencyEstateViewSetupPanel.this.addressGeoPanels.containsKey(dbGeo.id) ? (JPanel)AgencyEstateViewSetupPanel.this.addressGeoPanels.get(dbGeo.id) : new JPanel()) : AgencyEstateViewSetupPanel.this.addressMainPanel;
                AgencyEstateViewSetupPanel.this.addressPanel.removeAll();
                AgencyEstateViewSetupPanel.this.addressPanel.add((Component)object, "Center");
                AgencyEstateViewSetupPanel.this.addressPanel.revalidate();
                AgencyEstateViewSetupPanel.this.addressPanel.repaint();
                AgencyEstateViewSetupPanel.this.updateLocalization();
            }
        });
        this.addressTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        jPanel2.add((Component)this.addressTitle, "Center");
        jPanel2.add(this.addressSwitchField, "East");
        this.validationHandler.putRule(this.currencyField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.statusField, (ValidationRule)new NonEmptyComboBoxRule(this.statusField));
        this.validationHandler.putRule((JComponent)this.geoLatitudeField, (ValidationRule)new FormatterRule(this.geoLatitudeField));
        this.validationHandler.putRule((JComponent)this.geoLongitudeField, (ValidationRule)new FormatterRule(this.geoLongitudeField));
        this.validationHandler.putRule((JComponent)this.groupField, (ValidationRule)new FormatterRule(this.groupField));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        for (TitleField titleField : this.titleFields) {
            Locale locale = titleField.getLocale();
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(4);
            jLabel.setToolTipText(locale.getDisplayLanguage() + " / " + locale.getDisplayLanguage(locale));
            ImageIcon imageIcon = ImmoToolUtils.getCountryFlagIcon((Locale)locale);
            if (imageIcon != null) {
                jLabel.setText(" ");
                jLabel.setIcon(imageIcon);
            } else {
                jLabel.setText("<html><b style=\"font-size:1.1em;\">" + locale.getLanguage().toUpperCase() + "</b>&nbsp;</html>");
                jLabel.setIcon(null);
            }
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            jPanel3.add(jLabel);
            jPanel3.add(titleField.languageField);
            defaultFormBuilder.add((Component)jPanel3).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)titleField.textField).xyw(3, defaultFormBuilder.row(), 5);
        }
        defaultFormBuilder.add((Component)this.nrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.nrField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.currencyLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.currencyField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.idLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.idField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.statusField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.nrInternLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.nrInternField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publishBeginLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publishBeginField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.groupField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publishEndLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publishEndField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)jPanel2).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.addressPanel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.geoLatitudeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.geoLatitudeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.geoLongitudeLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.geoLongitudeField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.geoField})).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.setBorder(Paddings.EMPTY);
        this.add(jScrollPane, "Center");
        this.updateLocalization();
    }

    public void dispose() {
        if (this.titleFields != null) {
            for (TitleField titleField : this.titleFields) {
                if (titleField.balloonTip == null) continue;
                titleField.balloonTip.closeBalloon();
            }
            this.titleFields.clear();
        }
    }

    private void doGeoLookup() {
        if (this.mapDialog != null && this.mapDialog.isVisible()) {
            return;
        }
        if (this.mapDialog == null) {
            this.mapDialog = new MapDialog((Frame)ImmoToolEnvironment.getFrame());
            this.mapDialog.setSubmitAction((Action)((Object)new GeoSaveAction()));
            this.mapDialog.setZoom(this.geoField.isSelected() ? 6 : 14);
        }
        EstateAddressImpl estateAddressImpl = new EstateAddressImpl();
        this.addressMainPanel.saveAddress((AddressImpl)estateAddressImpl);
        String string = estateAddressImpl.getCountry();
        String string2 = estateAddressImpl.getPostalCode();
        String string3 = estateAddressImpl.getDistrict();
        if (StringUtils.isBlank((CharSequence)string3)) {
            string3 = estateAddressImpl.getCity();
        }
        if (StringUtils.isBlank((CharSequence)string3)) {
            string3 = estateAddressImpl.getRegion();
        }
        if (this.geoField.isSelected()) {
            this.mapDialog.setSearchPanelVisible(false);
        } else if (StringUtils.isNotBlank((CharSequence)string3)) {
            this.mapDialog.setSearchByName(string3, string);
        } else if (StringUtils.isNotBlank((CharSequence)string2)) {
            this.mapDialog.setSearchByPostal(string2, string);
        } else {
            this.mapDialog.setSearchPanelVisible(false);
        }
        if (!this.geoField.isSelected()) {
            this.mapDialog.setMarkerCoordinates(null);
            double[] dArray = ImmoToolUtils.getCountryCoordinates((String)string);
            if (dArray == null) {
                dArray = new double[]{0.0, 0.0};
            }
            this.mapDialog.setMapCenter(Double.valueOf(dArray[0]), Double.valueOf(dArray[1]));
            this.mapDialog.setZoom(14);
        } else {
            try {
                this.mapDialog.setMarkerCoordinates(((Number)this.geoLatitudeField.getValue()).doubleValue(), ((Number)this.geoLongitudeField.getValue()).doubleValue());
            }
            catch (Exception exception) {
                this.mapDialog.setMarkerCoordinates(null);
                LOGGER.warn("Can't set marker position!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.mapDialog.setVisible(true);
    }

    private void doGeoSave() {
        if (this.mapDialog == null || !this.mapDialog.isVisible()) {
            return;
        }
        Double d = this.mapDialog.getMarkerLatitude();
        Double d2 = this.mapDialog.getMarkerLongitude();
        if (d == null || d2 == null) {
            this.geoField.setSelected(false);
        } else {
            this.geoField.setSelected(true);
            this.geoLatitudeField.setValue(d);
            this.geoLongitudeField.setValue(d2);
        }
        this.geoLatitudeField.setEnabled(this.geoField.isSelected());
        this.geoLongitudeField.setEnabled(this.geoField.isSelected());
        this.mapDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.addressSwitchField.setEnabled(false);
        this.addressSwitchField.removeAllItems();
        this.addressGeoPanels.clear();
        DefaultComboBoxModel<DbGeo> defaultComboBoxModel = new DefaultComboBoxModel<DbGeo>();
        defaultComboBoxModel.addElement(null);
        try {
            DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
            DbAgencyObject dbAgencyObject = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
            String string = this.addressMainPanel.getSelectedCountry();
            String string2 = this.addressMainPanel.getSelectedCountryName();
            for (DbGeo dbGeo : dbGeoHandler.getGeoDbs(connection)) {
                GeoAreaPanel geoAreaPanel = new GeoAreaPanel(dbGeo, 50);
                geoAreaPanel.load(connection, dbGeoHandler, dbAgencyObject);
                geoAreaPanel.setCountry(string, string2, true);
                this.addressGeoPanels.put(dbGeo.id, geoAreaPanel);
                defaultComboBoxModel.addElement(dbGeo);
            }
        }
        finally {
            this.addressSwitchField.setModel(defaultComboBoxModel);
            this.addressSwitchField.setSelectedIndex(0);
            this.addressSwitchField.setEnabled(true);
        }
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("general"));
    }

    public boolean isTabModified() {
        return this.modifications.isModified() || this.addressMainPanel.isModifiedInput();
    }

    public boolean isTabValid() {
        TitleField titleField;
        this.validationHandler.validate();
        this.addressMainPanel.validateInputs();
        boolean bl = false;
        Iterator<TitleField> iterator = this.titleFields.iterator();
        while (iterator.hasNext() && !(bl = (titleField = iterator.next()).isSelected())) {
        }
        return bl && this.addressMainPanel.isValidInput() && this.validationHandler.isValid();
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        boolean bl;
        void var4_9;
        Object object;
        this.modifications.clear();
        this.currentObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        if (dbAgencyObject.id > 0L) {
            this.idField.setText(String.valueOf(dbAgencyObject.id));
            this.idField.setForeground(this.nrField.getForeground());
        } else {
            this.idField.setForeground(Color.GRAY);
            this.idField.setText(I18N.tr("Is generated automatically during the first save."));
        }
        String string = dbAgencyObject.importId;
        if (string != null && string.trim().length() > 0) {
            this.nrInternField.setText(string.trim());
            this.nrInternField.setForeground(this.nrField.getForeground());
        } else {
            this.nrInternField.setForeground(Color.GRAY);
            this.nrInternField.setText(I18N.tr("Is generated during property import."));
        }
        try {
            this.groupField.setValue(Long.valueOf((String)StringUtils.defaultIfBlank((CharSequence)dbAgencyObject.item.getGroupId(), (CharSequence)"0")));
        }
        catch (NumberFormatException numberFormatException) {
            this.groupField.setValue(0L);
        }
        this.nrField.setText(dbAgencyObject.item.getPublicId() != null ? dbAgencyObject.item.getPublicId().trim() : "");
        this.publishBeginField.setDate(dbAgencyObject.item.getPublishBegin());
        this.publishEndField.setDate(dbAgencyObject.item.getPublishEnd());
        if (dbAgencyObject.item.getAddress() == null) {
            this.addressMainPanel.loadAddress((AddressImpl)new EstateAddressImpl());
            this.addressPublishField.setSelected(false);
            this.geoLatitudeField.setValue(Float.valueOf(0.0f));
            this.geoLongitudeField.setValue(Float.valueOf(0.0f));
            this.geoField.setSelected(false);
            this.geoLatitudeField.setEnabled(false);
            this.geoLongitudeField.setEnabled(false);
        } else {
            this.addressMainPanel.loadAddress((AddressImpl)dbAgencyObject.item.getAddress());
            this.addressPublishField.setSelected(dbAgencyObject.item.getAddress().isPublished());
            object = dbAgencyObject.item.getAddress().getLatitude();
            BigDecimal object2 = dbAgencyObject.item.getAddress().getLongitude();
            this.geoField.setSelected(object != null && object2 != null);
            this.geoLatitudeField.setEnabled(this.geoField.isSelected());
            this.geoLatitudeField.setValue(object != null ? object : BigDecimal.ZERO);
            this.geoLongitudeField.setEnabled(this.geoField.isSelected());
            this.geoLongitudeField.setValue(object2 != null ? object2 : BigDecimal.ZERO);
        }
        for (TitleField titleField : this.titleFields) {
            boolean bl2;
            boolean bl3 = bl2 = dbAgencyObject.id < 1L || dbAgencyObject.item.getLanguages().isEmpty() || dbAgencyObject.item.getLanguages().contains(titleField.getLocale().getLanguage().toLowerCase());
            if (titleField.balloonTip.isVisible()) {
                titleField.balloonTip.setVisible(false);
            }
            titleField.setSelected(bl2);
            this.modifications.putValue((JComponent)titleField.languageField);
            String string2 = dbAgencyObject.item.getTitle(titleField.locale.getLanguage());
            titleField.setTitle(StringUtils.trimToEmpty((String)string2));
            this.modifications.putValue((JComponent)titleField.textField);
        }
        this.currencyField.setSelectedIndex(-1);
        object = dbAgencyObject.item.getCurrency() != null ? dbAgencyObject.item.getCurrency() : Currency.getInstance(new Locale(SystemUtils.USER_LANGUAGE, SystemUtils.USER_COUNTRY));
        boolean bl4 = false;
        while (var4_9 < this.currencyField.getItemCount()) {
            String string3 = this.currencyField.getItemAt((int)var4_9).getCurrencyCode();
            if (((Currency)object).getCurrencyCode().equals(string3)) {
                this.currencyField.setSelectedIndex((int)var4_9);
                break;
            }
            ++var4_9;
        }
        this.statusField.removeAllItems();
        this.statusField.addItem(null);
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            this.statusField.addItem(status);
        }
        if (!DbAgencyObject.Status.PUBLISHED.equals((Object)dbAgencyObject.status) && !AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING)) {
            this.statusField.removeItem((Object)DbAgencyObject.Status.PUBLISHED);
        }
        this.statusField.setSelectedItem((Object)(dbAgencyObject.status != null ? dbAgencyObject.status : DbAgencyObject.Status.DRAFT));
        boolean bl5 = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS);
        if (DbAgencyObject.Status.PUBLISHED.equals((Object)dbAgencyObject.status)) {
            bl = bl5 && AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_UNPUBLISHING);
        }
        this.statusField.setEnabled(bl);
        if (dbAgencyObject.id > 0L) {
            this.validationHandler.validate();
        } else {
            this.validationHandler.init();
        }
        this.modifications.putValue((JComponent)this.addressPublishField);
        this.modifications.putValue((JComponent)this.groupField);
        this.modifications.putValue((JComponent)this.idField);
        this.modifications.putValue((JComponent)this.nrField);
        this.modifications.putValue((JComponent)this.nrInternField);
        this.modifications.putValue((JComponent)this.publishBeginField);
        this.modifications.putValue((JComponent)this.publishEndField);
        this.modifications.putValue(this.currencyField);
        this.modifications.putValue(this.statusField);
        this.modifications.putValue((JComponent)this.geoField);
        this.modifications.putValue((JComponent)this.geoLatitudeField);
        this.modifications.putValue((JComponent)this.geoLongitudeField);
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) {
        dbAgencyObject.item.setPublicId(this.nrField.getText().trim());
        dbAgencyObject.item.setPublishBegin(this.publishBeginField.isEditValid() ? this.publishBeginField.getDate() : null);
        dbAgencyObject.item.setPublishEnd(this.publishEndField.isEditValid() ? this.publishEndField.getDate() : null);
        dbAgencyObject.item.setCurrency((Currency)this.currencyField.getSelectedItem());
        dbAgencyObject.status = (DbAgencyObject.Status)((Object)this.statusField.getSelectedItem());
        try {
            this.groupField.commitEdit();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't commit modified group-nr!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        Number number = (Number)this.groupField.getValue();
        dbAgencyObject.item.setGroupId(String.valueOf(number != null ? number.intValue() : 0));
        dbAgencyObject.item.getLanguages().clear();
        for (TitleField object : this.titleFields) {
            boolean bl = object.isSelected();
            if (bl) {
                dbAgencyObject.item.getLanguages().add(object.getLocale().getLanguage());
            }
            String string = bl ? object.getTitle() : null;
            dbAgencyObject.item.setTitle(StringUtils.trimToNull((String)string), object.getLocale().getLanguage());
        }
        this.addressMainPanel.saveAddress((AddressImpl)dbAgencyObject.item.getAddress());
        dbAgencyObject.item.getAddress().setPublished(this.addressPublishField.isSelected());
        if (!this.geoField.isSelected()) {
            dbAgencyObject.item.getAddress().setLatitude(null);
            dbAgencyObject.item.getAddress().setLongitude(null);
        } else {
            try {
                this.geoLatitudeField.commitEdit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't commit modified latitude!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.geoLongitudeField.commitEdit();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't commit modified longitude!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            Iterator<GeoAreaPanel> iterator = (Number)this.geoLatitudeField.getValue();
            Number number2 = (Number)this.geoLongitudeField.getValue();
            dbAgencyObject.item.getAddress().setLatitude(iterator != null && number2 != null ? new BigDecimal(((Number)((Object)iterator)).doubleValue()) : null);
            dbAgencyObject.item.getAddress().setLongitude(iterator != null && number2 != null ? new BigDecimal(number2.doubleValue()) : null);
        }
        for (GeoAreaPanel geoAreaPanel : this.addressGeoPanels.values()) {
            geoAreaPanel.save(dbAgencyObject);
        }
    }

    public void setStatus(String string) {
        this.statusField.setSelectedItem(string);
    }

    protected void updateLocalization() {
        TitleField titleField2;
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general information")));
        this.idLabel.setText(StringUtils.capitalize((String)I18N.tr("property-ID")) + ":");
        this.idField.setToolTipText(I18N.tr("The property-ID is generated automatically when the property is saved and can't be modified directly."));
        this.nrLabel.setText(StringUtils.capitalize((String)I18N.tr("property-nr")) + ":");
        this.nrField.setToolTipText(I18N.tr("The property number may be chosen freely if required. The number must be unique and cannot be used twice."));
        this.nrInternLabel.setText(StringUtils.capitalize((String)I18N.tr("import-ID")) + ":");
        this.nrInternField.setToolTipText(I18N.tr("The import-ID is generated automatically during a property import and can't be modified directly."));
        this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group-nr")) + ":");
        this.groupField.setToolTipText(I18N.tr("Several properties may be summarized by assigning identical group numbers."));
        this.publishBeginLabel.setText(StringUtils.capitalize((String)I18N.tr("valid from")) + ":");
        this.publishBeginField.setToolTipText(I18N.tr("Select the point in time, when the publishing of the property begins."));
        this.publishEndLabel.setText(StringUtils.capitalize((String)I18N.tr("valid until")) + ":");
        this.publishEndField.setToolTipText(I18N.tr("Select the point in time, when the publishing of the property ends."));
        this.currencyLabel.setText(StringUtils.capitalize((String)I18N.tr("currency")) + ":");
        this.currencyField.setToolTipText(I18N.tr("The selected currency is used for all price values of the property."));
        this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
        this.statusField.setToolTipText(I18N.tr("The status describes the current state of marketing for the property."));
        for (TitleField titleField2 : this.titleFields) {
            titleField2.languageField.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
            titleField2.languageField.setToolTipText(I18N.tr("Select the languages, in which you want to specify the property."));
            titleField2.textField.setToolTipText(I18N.tr("Enter a headline for this property."));
        }
        Object object = StringUtils.capitalize((String)I18N.tr("address"));
        titleField2 = (DbGeo)this.addressSwitchField.getSelectedItem();
        if (titleField2 != null && !StringUtils.isBlank((CharSequence)((DbGeo)titleField2).name)) {
            object = (String)object + " / " + StringUtils.trimToEmpty((String)((DbGeo)titleField2).name);
        }
        this.addressTitle.setTitle((String)object);
        this.addressSwitchField.setToolTipText(I18N.tr("Assign geographic data to the property, that were imported into the program beforehand."));
        this.addressPublishField.setText(I18N.tr("Publish the complete address."));
        this.addressPublishField.setToolTipText(I18N.tr("Enable this options to publish the complete address - e.g. in real estate portals."));
        this.geoTitle.setTitle(StringUtils.capitalize((String)I18N.tr("geo coordinates")));
        this.geoLatitudeLabel.setText(StringUtils.capitalize((String)I18N.tr("latitude")) + ":");
        this.geoLatitudeField.setToolTipText(I18N.tr("latitude of the property"));
        this.geoLongitudeLabel.setText(StringUtils.capitalize((String)I18N.tr("longitude")) + ":");
        this.geoLongitudeField.setToolTipText(I18N.tr("longitude of the property"));
        this.geoField.setText(StringUtils.capitalize((String)I18N.tr("enable geo coordinates")));
        this.geoField.setToolTipText(I18N.tr("Enable this option, if you want to provide geo coordinates for this property."));
    }

    private class TitleField {
        private final Locale locale;
        private JTextField textField;
        private JCheckBox languageField;
        private BalloonTip balloonTip;
        private JLabel balloonTipLabel;

        private TitleField(Locale locale) {
            this.locale = locale;
            this.textField = new JTextField();
            this.textField.setColumns(20);
            this.languageField = new JCheckBox();
            this.languageField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TitleField.this.textField.setEnabled(TitleField.this.languageField.isSelected());
                    AgencyEstateViewSetupPanel.this.validationHandler.validate((JComponent)TitleField.this.textField);
                    AgencyEstateViewSetupPanel.this.getViewPanel().setLanguageEnabled(TitleField.this.locale, TitleField.this.languageField.isSelected());
                }
            });
            this.balloonTipLabel = new JLabel();
            this.balloonTipLabel.setForeground(Color.DARK_GRAY);
            this.balloonTip = new BalloonTip((JComponent)this.textField, (JComponent)this.balloonTipLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
            this.balloonTip.setVisible(false);
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (!TitleField.this.textField.isEnabled()) {
                        return;
                    }
                    TitleField.this.updateBalloonTip();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (TitleField.this.balloonTip.isVisible()) {
                        TitleField.this.balloonTip.setVisible(false);
                    }
                }
            });
            this.textField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (!TitleField.this.textField.isEnabled()) {
                        return;
                    }
                    TitleField.this.updateBalloonTip();
                }
            });
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getTitle() {
            return StringUtils.trimToNull((String)this.textField.getText());
        }

        public boolean isSelected() {
            return this.languageField.isSelected();
        }

        public void setSelected(boolean bl) {
            this.languageField.setSelected(bl);
            this.textField.setEnabled(this.languageField.isSelected());
        }

        public void setTitle(String string) {
            try {
                this.textField.setEnabled(false);
                this.textField.setText(string);
                this.textField.setCaretPosition(0);
            }
            finally {
                this.textField.setEnabled(this.languageField.isSelected());
            }
        }

        private void updateBalloonTip() {
            int n = this.textField.getText().trim().length();
            String string = I18N.trn("{0} character", "{0} characters", (long)n, (Object)n);
            int n2 = this.balloonTipLabel.getText().length();
            this.balloonTipLabel.setText(string);
            if (!this.balloonTip.isVisible()) {
                this.balloonTip.setVisible(true);
            }
            if (n2 != string.length()) {
                this.balloonTip.refreshLocation();
            }
        }
    }

    private class GeoSaveAction
    extends AbstractI18nAction {
        private GeoSaveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewSetupPanel.this.doGeoSave();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit geo coordinates for the property."));
        }
    }

    private class GeoLookupAction
    extends AbstractI18nAction {
        private GeoLookupAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewSetupPanel.this.doGeoLookup();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("lookup coordinates")));
            this.setShortDescription(I18N.tr("Lookup geo coordinates for the property."));
        }
    }
}

