/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportDialogPanel;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyExportPool;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.java.balloontip.BalloonTip;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportDialog
extends AbstractDialog
implements DisposableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportDialog.class);
    private Map<Long, DbAgencyExport> exports = new HashMap<Long, DbAgencyExport>();
    private Map<Long, ExportForm> exportForms = new LinkedHashMap<Long, ExportForm>();
    private List<Long> loadingExports = new ArrayList<Long>();
    private List<ExportContext> result = null;
    private AbstractDbDriver dbDriver = null;
    private DbAgencyExtension dbExtension = null;
    private File tempBaseDir = null;
    private AgencyExportPool preparationPool = null;
    private JPanel mainPanel;
    private JPanel infoPanel;
    private JLabel infoLabel;
    private JPanel exportContainerPanel;
    private DefaultFormBuilder exportContainerBuilder;
    private JXBusyLabel loadDialogLabel;
    private BalloonTip exportAddBalloonTip;
    private JLabel exportAddBalloonLabel;
    private ShowExportAddActionsAction exportAddAction;
    private SubmitAction submitAction;
    private CancelAction cancelAction;
    private AbstractI18nAction helpAction;

    private AgencyExportDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(frame);
    }

    private AgencyExportDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        this.exportAddAction = new ShowExportAddActionsAction();
        this.helpAction = this.createDefaultHelpAction();
        JButton jButton = new JButton((Action)((Object)this.exportAddAction));
        this.exportAddBalloonLabel = new JLabel();
        this.exportAddBalloonLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
        this.exportAddBalloonTip = new BalloonTip((JComponent)jButton, (JComponent)this.exportAddBalloonLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
        this.exportAddBalloonTip.setVisible(false);
        buttonBarBuilder.addFixed((JComponent)jButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.submitAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.cancelAction)));
    }

    protected JComponent buildMainComponent() {
        this.loadDialogLabel = new JXBusyLabel();
        this.loadDialogLabel.setOpaque(false);
        this.loadDialogLabel.setBusy(false);
        this.loadDialogLabel.setVisible(false);
        this.exportContainerPanel = new JPanel();
        this.exportContainerPanel.setOpaque(false);
        this.exportContainerBuilder = DefaultFormBuilder.create((String)"pref:grow", (JPanel)this.exportContainerPanel);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.mainPanel.add((Component)this.loadDialogLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel);
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.infoPanel = new JPanel(new BorderLayout(10, 10));
        this.infoPanel.setBackground(new Color(255, 254, 225));
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.infoPanel.getBorder()));
        this.infoPanel.setVisible(false);
        this.infoLabel = new JLabel();
        this.infoLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)32));
        this.infoPanel.add((Component)this.infoLabel, "Center");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.infoPanel, "South");
        return jPanel;
    }

    public void dispose() {
        if (this.exportAddBalloonTip != null) {
            this.exportAddBalloonTip.closeBalloon();
        }
    }

    private void doExportAdd(DbAgencyExport dbAgencyExport) {
        if (AgencyExportHandler.isJobRunning(dbAgencyExport.id) || dbAgencyExport.isLocked()) {
            return;
        }
        if (this.exportForms.containsKey(dbAgencyExport.id)) {
            return;
        }
        if (this.loadingExports.contains(dbAgencyExport.id)) {
            return;
        }
        this.loadingExports.add(dbAgencyExport.id);
        ExportForm exportForm = new ExportForm(dbAgencyExport, this.preparationPool);
        this.exportForms.put(dbAgencyExport.id, exportForm);
        this.exportContainerBuilder.add((Component)((Object)exportForm)).xy(1, this.exportContainerBuilder.nextRow());
        this.exportContainerPanel.revalidate();
        this.exportContainerPanel.repaint();
        exportForm.load(this.dbDriver, this.dbExtension);
        this.updateExportSelection();
        this.updateFullTransferInfo();
    }

    private void doShowExportAddActions(Component component, int n, int n2) {
        Object object;
        JMenu jMenu = new JMenu(I18N.tr("specific interface"));
        TreeMap<String, DbAgencyExport> treeMap = new TreeMap<String, DbAgencyExport>();
        for (DbAgencyExport dbAgencyExport : this.exports.values()) {
            if (this.exportForms.containsKey(dbAgencyExport.id)) continue;
            object = StringUtils.trimToEmpty((String)dbAgencyExport.name).toLowerCase();
            int n3 = 0;
            while (treeMap.containsKey(object)) {
                object = StringUtils.trimToEmpty((String)dbAgencyExport.name).toLowerCase() + "_" + ++n3;
            }
            treeMap.put((String)object, dbAgencyExport);
        }
        for (DbAgencyExport dbAgencyExport : treeMap.values()) {
            object = new ExportAddAction(dbAgencyExport);
            object.setEnabled(!dbAgencyExport.isLocked() && !AgencyExportHandler.isJobRunning(dbAgencyExport.id));
            jMenu.add(new JMenuItem((Action)object));
        }
        jMenu.setEnabled(!this.exports.isEmpty());
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ExportAddAction(true, true))));
        jPopupMenu.add(new JMenuItem((Action)((Object)new ExportAddAction(true, false))));
        jPopupMenu.add(new JMenuItem((Action)((Object)new ExportAddAction(false, true))));
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        jPopupMenu.show(component, n, n2);
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.export.send", (Window)((Object)this));
    }

    private void doSubmit() {
        try {
            this.result = new ArrayList<ExportContext>();
            for (ExportForm exportForm : this.exportForms.values()) {
                long l = exportForm.getExportId();
                DbAgencyExport dbAgencyExport = this.exports.get(l);
                ExportContext exportContext = new ExportContext(dbAgencyExport, this.tempBaseDir, this.dbDriver, this.dbExtension);
                exportForm.save(exportContext);
                this.result.add(exportContext);
            }
        }
        catch (Exception exception) {
            this.result = null;
            LOGGER.error("Can't prepare export!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't prepare export!"), (Throwable)exception, (Window)((Object)this));
            return;
        }
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("export properties"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32);
    }

    protected String getHeaderTitle() {
        return I18N.tr("Prepare the export process.");
    }

    private void load(long[] lArray, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, File file) {
        this.result = null;
        this.dbDriver = abstractDbDriver;
        this.dbExtension = dbAgencyExtension;
        this.tempBaseDir = file;
        this.preparationPool = new AgencyExportPool(new File(file, "preparation"), dbAgencyExtension);
        this.loadDialogLabel.setBusy(true);
        this.loadDialogLabel.setVisible(true);
        this.submitAction.setEnabled(false);
        this.exportAddAction.setEnabled(false);
        this.exports.clear();
        this.exportForms.clear();
        this.exportContainerPanel.removeAll();
        this.loadingExports.clear();
        ImmoToolUtils.executeTask((ImmoToolTask)new LoadInBackgroundTask(lArray));
    }

    public static ExportContext[] showDialog(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, File file, Window window) {
        return AgencyExportDialog.showDialog(null, abstractDbDriver, dbAgencyExtension, file, window);
    }

    public static ExportContext[] showDialog(long l, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, File file, Window window) {
        return l > 0L ? AgencyExportDialog.showDialog(new long[]{l}, abstractDbDriver, dbAgencyExtension, file, window) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportContext[] showDialog(long[] lArray, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, File file, Window window) {
        ExportContext[] exportContextArray;
        block4: {
            if (lArray != null && ArrayUtils.isEmpty((long[])lArray)) {
                return null;
            }
            AgencyExportDialog agencyExportDialog = null;
            try {
                agencyExportDialog = window instanceof Dialog ? new AgencyExportDialog((Dialog)window) : (window instanceof Frame ? new AgencyExportDialog((Frame)window) : new AgencyExportDialog((Frame)null));
                agencyExportDialog.load(lArray, abstractDbDriver, dbAgencyExtension, file);
                agencyExportDialog.setVisible(true);
                ExportContext[] exportContextArray2 = exportContextArray = agencyExportDialog.result != null ? agencyExportDialog.result.toArray(new ExportContext[0]) : null;
                if (agencyExportDialog == null) break block4;
                agencyExportDialog.preparationPool.cleanup();
            }
            catch (Throwable throwable) {
                if (agencyExportDialog != null) {
                    agencyExportDialog.preparationPool.cleanup();
                    SwingUtils.disposeRecursively(agencyExportDialog);
                }
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)agencyExportDialog));
        }
        return exportContextArray;
    }

    private void updateExportContainerPanel() {
        this.exportContainerPanel.removeAll();
        this.exportContainerBuilder = DefaultFormBuilder.create((String)"pref:grow", (JPanel)this.exportContainerPanel);
        for (ExportForm exportForm : this.exportForms.values()) {
            this.exportContainerBuilder.add((Component)((Object)exportForm)).xy(1, this.exportContainerBuilder.nextRow());
        }
        this.exportContainerPanel.revalidate();
        this.exportContainerPanel.repaint();
        this.updateExportSelection();
    }

    private void updateExportSelection() {
        if (this.exportForms.isEmpty()) {
            this.submitAction.setEnabled(false);
            if (!this.exportAddBalloonTip.isVisible()) {
                this.exportAddBalloonTip.setVisible(true);
            }
        } else if (!this.loadingExports.isEmpty()) {
            this.submitAction.setEnabled(false);
            if (this.exportAddBalloonTip.isVisible()) {
                this.exportAddBalloonTip.setVisible(false);
            }
        } else {
            this.submitAction.setEnabled(true);
            if (this.exportAddBalloonTip.isVisible()) {
                this.exportAddBalloonTip.setVisible(false);
            }
        }
    }

    private void updateFullTransferInfo() {
        boolean bl = false;
        for (ExportForm exportForm : this.exportForms.values()) {
            if (!AbstractFormat.TransferMode.FULL.equals((Object)exportForm.getTransferMode())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.infoPanel.setVisible(false);
            return;
        }
        this.infoLabel.setText("<html><b>" + I18N.tr("At least one export uses a full transfer!") + "</b> " + I18N.tr("Please consider that all your properties will be deleted at recipient side, that were neither inserted nor updated during a full transfer.") + "</html>");
        this.infoPanel.setVisible(true);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.loadDialogLabel.setText(I18N.tr("Loading interfaces."));
        this.exportAddBalloonLabel.setText(I18N.tr("Click this button and select one or more interfaces for the export process."));
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Start the export process."));
        }
    }

    private class ShowExportAddActionsAction
    extends AbstractI18nAction {
        private ShowExportAddActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyExportDialog.this.doShowExportAddActions(jButton, 0, jButton.getSize().height);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add")));
            this.setShortDescription(I18N.tr("Add an interface to the export process."));
        }
    }

    private class ExportAddAction
    extends AbstractI18nAction {
        final DbAgencyExport export;
        final boolean addActive;
        final boolean addInactive;

        private ExportAddAction(DbAgencyExport dbAgencyExport) {
            this.export = dbAgencyExport;
            this.addActive = false;
            this.addInactive = false;
            this.updateLocalization();
        }

        private ExportAddAction(boolean bl, boolean bl2) {
            if (!bl && !bl2) {
                throw new IllegalArgumentException("One of the parameters must be true!");
            }
            this.export = null;
            this.addActive = bl;
            this.addInactive = bl2;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                block6: {
                    block5: {
                        block3: {
                            if (this.export == null) break block3;
                            AgencyExportDialog.this.doExportAdd(this.export);
                            break block4;
                        }
                        if (!this.addActive || !this.addInactive) break block5;
                        for (DbAgencyExport dbAgencyExport : AgencyExportDialog.this.exports.values()) {
                            AgencyExportDialog.this.doExportAdd(dbAgencyExport);
                        }
                        break block4;
                    }
                    if (!this.addActive || this.addInactive) break block6;
                    for (DbAgencyExport dbAgencyExport : AgencyExportDialog.this.exports.values()) {
                        if (!dbAgencyExport.enabled) continue;
                        AgencyExportDialog.this.doExportAdd(dbAgencyExport);
                    }
                    break block4;
                }
                if (this.addActive || !this.addInactive) break block4;
                for (DbAgencyExport dbAgencyExport : AgencyExportDialog.this.exports.values()) {
                    if (dbAgencyExport.enabled) continue;
                    AgencyExportDialog.this.doExportAdd(dbAgencyExport);
                }
            }
        }

        protected void updateLocalization() {
            if (this.export != null) {
                String string = StringUtils.trimToNull((String)this.export.name);
                this.setName(string != null ? StringUtils.abbreviate((String)string, (int)30) : "#" + this.export.id);
                this.setShortDescription(I18N.tr("Add interface {0} to the export process.", (Object)("'" + StringUtils.abbreviate((String)string, (int)50) + "'")));
            } else if (this.addActive && this.addInactive) {
                this.setName(I18N.tr("all interfaces"));
                this.setShortDescription(I18N.tr("Add all interfaces to the export process."));
            } else if (this.addActive && !this.addInactive) {
                this.setName(I18N.tr("active interfaces"));
                this.setShortDescription(I18N.tr("Add all active interfaces to the export process."));
            } else if (!this.addActive && this.addInactive) {
                this.setName(I18N.tr("inactive interfaces"));
                this.setShortDescription(I18N.tr("Add all inactive interfaces to the export process."));
            } else {
                this.setName("???");
                this.setShortDescription("???");
            }
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window and cancel the export process."));
        }
    }

    private class ExportForm
    extends AgencyExportDialogPanel {
        private ExportForm(DbAgencyExport dbAgencyExport, AgencyExportPool agencyExportPool) {
            super(dbAgencyExport, agencyExportPool);
        }

        @Override
        protected void doRemove() {
            ExportForm.super.doRemove();
            long l = this.getExportId();
            if (!AgencyExportDialog.this.exportForms.containsKey(l)) {
                return;
            }
            AgencyExportDialog.this.exportForms.remove(l);
            AgencyExportDialog.this.updateExportContainerPanel();
            AgencyExportDialog.this.updateFullTransferInfo();
        }

        @Override
        protected void loadingFinished(boolean bl) {
            super.loadingFinished(bl);
            long l = this.getExportId();
            if (AgencyExportDialog.this.loadingExports.contains(l)) {
                AgencyExportDialog.this.loadingExports.remove(l);
                AgencyExportDialog.this.updateExportSelection();
            }
        }

        @Override
        protected void updateTransferMode() {
            super.updateTransferMode();
            AgencyExportDialog.this.updateFullTransferInfo();
        }
    }

    private class LoadInBackgroundTask
    extends ImmoToolTask<DbAgencyExport[], Void> {
        private long[] exportIds;

        private LoadInBackgroundTask(long[] lArray) {
            this.exportIds = lArray != null ? ArrayUtils.clone((long[])lArray) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyExport[] doInBackground() throws Exception {
            DbAgencyExport[] dbAgencyExportArray;
            File file = AgencyExportDialog.this.preparationPool.getPoolFolder();
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException("Temp directory is invalid!");
                }
                FileUtils.deleteDirectory((File)file);
            }
            if (!file.mkdirs()) {
                throw new IOException("Can't create temp directory!");
            }
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyExportDialog.this.dbExtension.getExportsHandler();
            Connection connection = null;
            try {
                connection = AgencyExportDialog.this.dbDriver.getConnection();
                dbAgencyExportArray = dbAgencyExportsHandler.getExports(connection);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return dbAgencyExportArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportDialog.this.loadDialogLabel.setBusy(false);
            AgencyExportDialog.this.loadDialogLabel.setText(I18N.tr("An error occurred!"));
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load interfaces!", (Throwable)throwable, (Window)((Object)AgencyExportDialog.this));
        }

        protected void succeeded(DbAgencyExport[] dbAgencyExportArray) {
            super.succeeded((Object)dbAgencyExportArray);
            AgencyExportDialog.this.exportAddAction.setEnabled(true);
            AgencyExportDialog.this.loadDialogLabel.setBusy(false);
            AgencyExportDialog.this.loadDialogLabel.setVisible(false);
            AgencyExportDialog.this.mainPanel.removeAll();
            AgencyExportDialog.this.mainPanel.add((Component)AgencyExportDialog.this.exportContainerPanel, "North");
            AgencyExportDialog.this.exports.clear();
            for (DbAgencyExport dbAgencyExport : dbAgencyExportArray) {
                AgencyExportDialog.this.exports.put(dbAgencyExport.id, dbAgencyExport);
                if (this.exportIds == null) {
                    if (!dbAgencyExport.enabled) continue;
                    AgencyExportDialog.this.doExportAdd(dbAgencyExport);
                    continue;
                }
                if (!ArrayUtils.contains((long[])this.exportIds, (long)dbAgencyExport.id)) continue;
                AgencyExportDialog.this.doExportAdd(dbAgencyExport);
            }
            AgencyExportDialog.this.updateExportSelection();
        }
    }
}

