/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySearchCriteriaPanel;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportViewSearchPanel
extends AgencyExportViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewSearchPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewSearchPanel.class);
    private long currentSearchId = 0L;
    private AgencySearchCriteriaPanel criteriaPanel;

    public AgencyExportViewSearchPanel() {
        this.build();
    }

    private void build() {
        this.criteriaPanel = new AgencySearchCriteriaPanel();
        this.criteriaPanel.setBorder((Border)Paddings.DIALOG);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.criteriaPanel));
        jScrollPane.setBorder(Paddings.EMPTY);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(10, 10));
        this.add(jScrollPane, "Center");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        block5: {
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            this.criteriaPanel.loadTemplates(connection, dbAgencySearchesHandler);
            if (this.currentSearchId > 0L) {
                DbAgencySearch dbAgencySearch;
                block6: {
                    DbAgencySearch dbAgencySearch2 = null;
                    try {
                        dbAgencySearch2 = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, this.currentSearchId);
                        dbAgencySearchesHandler.loadAttribConditions(connection, dbAgencySearch2);
                        dbAgencySearchesHandler.loadParameters(connection, dbAgencySearch2);
                        dbAgencySearchesHandler.loadValueConditions(connection, dbAgencySearch2);
                        if (dbAgencySearch2 == null) break block5;
                        dbAgencySearch = dbAgencySearch2;
                        if (dbAgencySearch.item != null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (dbAgencySearch2 != null) {
                            DbAgencySearch dbAgencySearch3 = dbAgencySearch2;
                            if (dbAgencySearch3.item == null) {
                                dbAgencySearch3.item = new SearchImpl();
                            }
                            SwingUtilities.invokeLater(new Runnable(dbAgencySearch3){
                                final /* synthetic */ DbAgencySearch val$search;
                                {
                                    this.val$search = dbAgencySearch;
                                }

                                @Override
                                public void run() {
                                    AgencyExportViewSearchPanel.this.criteriaPanel.load(this.val$search);
                                }
                            });
                        }
                        throw throwable;
                    }
                    dbAgencySearch.item = new SearchImpl();
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.trc("search (noun)", "search"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport) {
        this.currentSearchId = dbAgencyExport != null ? dbAgencyExport.searchId : 0L;
        this.criteriaPanel.setDefaultSearch();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport) {
    }

    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyExport dbAgencyExport) throws SQLException {
        DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
        DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
        DbAgencySearch dbAgencySearch = new DbAgencySearch();
        this.criteriaPanel.save(dbAgencySearch);
        if (dbAgencyExport.searchId > 0L) {
            dbAgencySearch.id = dbAgencyExport.searchId;
        }
        dbAgencySearchesHandler.saveSearch(connection, dbAgencySearch, true, true);
        if (dbAgencyExport.searchId < 1L && dbAgencySearch.id > 0L) {
            dbAgencyExport.searchId = dbAgencySearch.id;
            dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, false, false);
        }
    }
}

