/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.gui.ImportFormatRenderer;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.SwingUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyImportDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyImportDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyImportDialog.class);
    private static Class lastFormat = null;
    private static String lastFormatVersion = null;
    private static AgencyImportTask.Settings lastSettings = null;
    private static File lastFolder = null;
    private boolean submitted = false;
    private JComboBox<AbstractImport> formatBox;
    private JComboBox<String> formatVersionBox;
    private JTabbedPane tabbedPane;
    private FileSelectionTab fileSelectionTab;
    private GeneralOptionsTab generalOptionsTab;
    private AbstractImportTab formatOptionsTab;
    private JXBusyLabel busyLabel;
    private SubmitAction submitAction;
    private CancelAction cancelAction;
    private ValidationAction validationAction;
    private AbstractImport currentFormat;
    private String currentFormatVersion;
    private File currentFile;
    private AgencyImportTask.Settings currentSettings = null;

    private AgencyImportDialog(Frame frame) {
        super(frame);
        this.setCurrentFile(null);
        this.setCurrentFormat(null);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private AgencyImportDialog(Dialog dialog) {
        super(dialog);
        this.setCurrentFile(null);
        this.setCurrentFormat(null);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        this.validationAction = new ValidationAction();
        buttonBarBuilder.addButton(new Action[]{this.validationAction});
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.formatBox = new JComboBox();
        this.formatBox.setFont(this.formatBox.getFont().deriveFont(1));
        this.formatBox.setRenderer((ListCellRenderer<AbstractImport>)new DefaultListCellRenderer((Renderer)new ImportFormatRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select a format for import") + " ]";
            }

            @Override
            public void render(AbstractImport abstractImport, JLabel jLabel) {
                super.render(abstractImport, jLabel);
                jLabel.setFont(abstractImport != null ? jLabel.getFont().deriveFont(0) : jLabel.getFont().deriveFont(1));
            }
        }));
        this.formatBox.setPrototypeDisplayValue(null);
        this.formatBox.addItem(null);
        TreeMap<String, AbstractImport> treeMap = new TreeMap<String, AbstractImport>();
        for (AbstractImport object2 : AbstractImport.getImports().values()) {
            String string = StringUtils.trimToEmpty((String)object2.getTitle()).toLowerCase();
            int n = 0;
            String string2 = string;
            while (treeMap.containsKey(string2)) {
                string2 = string + "_" + ++n;
            }
            treeMap.put(string2, object2);
        }
        for (AbstractImport abstractImport : treeMap.values()) {
            this.formatBox.addItem(abstractImport);
        }
        this.formatBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyImportDialog.this.formatBox.isEnabled()) {
                    return;
                }
                AgencyImportDialog.this.setCurrentFormat((AbstractImport)AgencyImportDialog.this.formatBox.getSelectedItem());
            }
        });
        this.formatVersionBox = new JComboBox();
        this.formatVersionBox.setPrototypeDisplayValue(null);
        this.formatVersionBox.setRenderer((ListCellRenderer<String>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<String>(){

            public void render(String string, JLabel jLabel) {
                if (string != null) {
                    jLabel.setText(I18N.tr("version") + " " + string);
                } else {
                    jLabel.setText("[ " + I18N.tr("select a version") + " ]");
                }
            }
        }));
        this.formatVersionBox.setEnabled(false);
        this.formatVersionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyImportDialog.this.formatVersionBox.isEnabled()) {
                    return;
                }
                AgencyImportDialog.this.setCurrentFormatVersion((String)AgencyImportDialog.this.formatVersionBox.getSelectedItem());
            }
        });
        Iterator<AbstractImport> iterator = DefaultFormBuilder.create((String)"pref:grow, 3dlu, pref");
        iterator.opaque(false);
        iterator.add(this.formatBox).xy(1, iterator.nextRow());
        iterator.add(this.formatVersionBox).xy(3, iterator.row());
        this.tabbedPane = new JTabbedPane();
        this.fileSelectionTab = (FileSelectionTab)ImmoToolUtils.addTab((AbstractTab)new FileSelectionTab(), (JTabbedPane)this.tabbedPane);
        this.generalOptionsTab = (GeneralOptionsTab)ImmoToolUtils.addTab((AbstractTab)new GeneralOptionsTab(), (JTabbedPane)this.tabbedPane);
        this.formatOptionsTab = null;
        this.busyLabel = new JXBusyLabel();
        ImmoToolUtils.configureWarningComponent((JComponent)this.busyLabel);
        this.busyLabel.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout(15, 15));
        jPanel.setOpaque(false);
        jPanel.add((Component)iterator.getPanel(), "North");
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.busyLabel, "South");
        return jPanel;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Writing static variables is not problematic.")
    private void doSubmit() {
        this.currentSettings = new AgencyImportTask.Settings();
        this.generalOptionsTab.save(this.currentSettings);
        if (this.formatOptionsTab != null) {
            this.formatOptionsTab.save(this.currentSettings);
        }
        lastFormat = this.currentFormat.getClass();
        lastFormatVersion = this.currentFormatVersion;
        lastSettings = this.currentSettings;
        lastFolder = this.currentFile.getParentFile();
        this.submitted = true;
        this.setVisible(false);
    }

    private void doValidate() {
        if (this.currentFile == null || !this.currentFile.isFile()) {
            return;
        }
        this.busyLabel.setText(I18N.tr("Validating the selected file."));
        this.busyLabel.setBusy(true);
        this.busyLabel.setVisible(true);
        ImmoToolUtils.executeTask((ImmoToolTask)new ValidationTask(this.currentFile));
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("import properties"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("import properties into the project"));
    }

    private ImmoToolTask getTask(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser) {
        return this.currentFormat.createTask(this.currentFile, this.currentFormatVersion, this.currentSettings, abstractDbDriver, dbAgencyExtension, dbUser);
    }

    private void setCurrentFile(File file) {
        this.currentFile = file != null && file.isFile() ? file : null;
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentFormat(AbstractImport abstractImport) {
        int n = this.tabbedPane.getSelectedIndex();
        this.tabbedPane.remove((Component)((Object)this.generalOptionsTab));
        this.tabbedPane.remove((Component)((Object)this.formatOptionsTab));
        if (this.formatOptionsTab != null) {
            this.formatOptionsTab = null;
        }
        this.currentFormat = abstractImport;
        this.currentFormatVersion = null;
        this.formatBox.setEnabled(false);
        this.formatVersionBox.setEnabled(false);
        try {
            this.formatBox.setSelectedItem(this.currentFormat);
            this.formatVersionBox.setSelectedItem(-1);
            this.formatVersionBox.removeAllItems();
            if (this.currentFormat != null) {
                AgencyImportTask.Settings settings;
                boolean bl = this.currentFormat.isIncrementalTransferSupported();
                for (String string : this.currentFormat.getVersions()) {
                    this.formatVersionBox.addItem(string);
                }
                if (this.formatVersionBox.getItemCount() > 0) {
                    this.formatVersionBox.setSelectedIndex(0);
                    this.setCurrentFormatVersion((String)this.formatVersionBox.getSelectedItem());
                }
                boolean bl2 = this.currentFormat.isSingleLanguageFormat();
                this.generalOptionsTab.languageLabel.setEnabled(bl2);
                this.generalOptionsTab.languageBox.setEnabled(bl2);
                if (!this.generalOptionsTab.languageBox.isEnabled()) {
                    this.generalOptionsTab.languageBox.setSelectedItem(null);
                } else {
                    this.generalOptionsTab.languageBox.setSelectedItem(Locale.getDefault());
                }
                this.generalOptionsTab.updateDeleteMethods(bl);
                this.generalOptionsTab.importDeletedBox.setEnabled(bl);
                if (!bl) {
                    this.generalOptionsTab.importDeletedBox.setSelected(false);
                }
                ImmoToolUtils.addTab((AbstractTab)this.generalOptionsTab, (JTabbedPane)this.tabbedPane);
                this.formatOptionsTab = this.currentFormat.createOptionsTab();
                if (this.formatOptionsTab != null) {
                    ImmoToolUtils.addTab((AbstractTab)this.formatOptionsTab, (JTabbedPane)this.tabbedPane);
                }
                if ((settings = this.currentFormat.getPreferredSettings()) != null) {
                    this.generalOptionsTab.load(settings);
                    this.formatOptionsTab.load(settings);
                }
            }
            this.formatBox.setEnabled(true);
            this.formatVersionBox.setEnabled(this.currentFormat != null);
            this.updateButtons();
        }
        catch (Throwable throwable) {
            this.formatBox.setEnabled(true);
            this.formatVersionBox.setEnabled(this.currentFormat != null);
            this.updateButtons();
            throw throwable;
        }
        if (this.tabbedPane.getTabCount() > n) {
            this.tabbedPane.setSelectedIndex(n);
        }
        this.fileSelectionTab.fileChooser.resetChoosableFileFilters();
        if (this.currentFormat != null) {
            FormatFileFilter formatFileFilter = new FormatFileFilter(this.currentFormat);
            this.fileSelectionTab.fileChooser.addChoosableFileFilter(formatFileFilter);
            this.fileSelectionTab.fileChooser.setFileFilter(formatFileFilter);
        }
        this.fileSelectionTab.fileChooser.rescanCurrentDirectory();
    }

    private void setCurrentFormatClass(Class clazz) {
        if (clazz == null) {
            this.setCurrentFormat(null);
            return;
        }
        for (int i = 0; i < this.formatBox.getItemCount(); ++i) {
            AbstractImport abstractImport = this.formatBox.getItemAt(i);
            if (abstractImport == null || !abstractImport.getClass().equals(clazz)) continue;
            this.setCurrentFormat(abstractImport);
            return;
        }
        this.setCurrentFormat(null);
    }

    private void setCurrentFormatVersion(String string) {
        this.currentFormatVersion = StringUtils.trimToNull((String)string);
        if (this.currentFormatVersion != null) {
            this.formatVersionBox.setSelectedItem(this.currentFormatVersion);
        } else if (this.formatVersionBox.getItemCount() > 0) {
            this.formatVersionBox.setSelectedIndex(0);
        } else {
            this.formatVersionBox.setSelectedIndex(-1);
        }
    }

    public static ImmoToolTask showDialog(ImmoToolProject immoToolProject, File file, String string, Window window) {
        return immoToolProject != null ? AgencyImportDialog.showDialog(immoToolProject.getDbDriver(), AgencyPlugin.getDbAgencyExtension(), immoToolProject.getUser(), file, string, window) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmoToolTask showDialog(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser, File file, String string, Window window) {
        ImmoToolTask immoToolTask;
        AbstractImport abstractImport;
        if (file != null && file.isDirectory()) {
            lastFolder = file;
        }
        if ((abstractImport = AbstractImport.getImport(string)) != null) {
            lastFormat = abstractImport.getClass();
        }
        AgencyImportDialog agencyImportDialog = null;
        try {
            agencyImportDialog = window instanceof Dialog ? new AgencyImportDialog((Dialog)window) : (window instanceof Frame ? new AgencyImportDialog((Frame)window) : new AgencyImportDialog((Frame)null));
            agencyImportDialog.setCurrentFormatClass(lastFormat);
            agencyImportDialog.setCurrentFormatVersion(lastFormatVersion);
            if (lastSettings != null) {
                agencyImportDialog.generalOptionsTab.load(lastSettings);
                if (agencyImportDialog.formatOptionsTab != null) {
                    agencyImportDialog.formatOptionsTab.load(lastSettings);
                }
            }
            agencyImportDialog.setVisible(true);
            immoToolTask = agencyImportDialog.submitted ? agencyImportDialog.getTask(abstractDbDriver, dbAgencyExtension, dbUser) : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(agencyImportDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)agencyImportDialog));
        return immoToolTask;
    }

    private void updateButtons() {
        this.submitAction.setEnabled(this.currentFile != null && this.currentFile.isFile() && this.currentFormat != null && this.currentFormatVersion != null);
        this.validationAction.setEnabled(this.currentFile != null && this.currentFile.isFile());
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formatBox.setToolTipText(I18N.tr("Please select the format of the import file."));
        this.formatVersionBox.setToolTipText(I18N.tr("Please select the version of the import file."));
    }

    private static class FormatFileFilter
    extends FileFilter {
        private final AbstractImport format;
        private final List<String> extensions;

        private FormatFileFilter(AbstractImport abstractImport) {
            this.format = abstractImport;
            this.extensions = new ArrayList<String>();
            this.extensions.addAll(Arrays.asList(abstractImport.getFileExtensions()));
            this.extensions.add("zip");
        }

        @Override
        public boolean accept(File file) {
            if (file.isFile()) {
                for (String string : this.extensions) {
                    if (!StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)("." + string))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            return I18N.tr("supported files by {0}", (Object)this.format.getTitle()) + " (*." + StringUtils.join(this.extensions, (String)", *.") + ")";
        }
    }

    private class ValidationTask
    extends ImmoToolTask<Boolean, Void> {
        private final File file;
        private AbstractImport validatedFormat = null;
        private String validatedVersion = null;

        private ValidationTask(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            File file;
            File file2;
            block8: {
                block9: {
                    Boolean bl;
                    ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                    if (immoToolProject == null) {
                        throw new Exception("No project loaded!");
                    }
                    file2 = null;
                    try {
                        file2 = new File(immoToolProject.getTempDirectory(), "import-" + System.currentTimeMillis());
                        file = null;
                        if (StringUtils.endsWithIgnoreCase((CharSequence)this.file.getName(), (CharSequence)".zip")) {
                            if (!file2.mkdirs()) {
                                throw new IOException("Can't create temp directory!");
                            }
                            ImmoToolUtils.unzip((File)this.file, (File)file2);
                        } else {
                            file = this.file;
                        }
                        if (AgencyImportDialog.this.currentFormat == null) break block8;
                        boolean bl2 = this.doValidate(AgencyImportDialog.this.currentFormat, file, file2);
                        if (!bl2) break block9;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        FileUtils.deleteQuietly(file2);
                        throw throwable;
                    }
                    FileUtils.deleteQuietly((File)file2);
                    return bl;
                }
                String string = "<html>" + I18N.tr("The file is not supported by the selected {0} format.", (Object)AgencyImportDialog.this.currentFormat.getTitle()) + "<br>" + I18N.tr("Should we try to detect the format automatically?") + "</html>";
                if (ImmoToolUtils.showQuestionDialog((String)string, (Component)((Object)AgencyImportDialog.this))) break block8;
                Boolean bl = false;
                FileUtils.deleteQuietly((File)file2);
                return bl;
            }
            Boolean bl = this.doValidateAll(file, file2);
            FileUtils.deleteQuietly((File)file2);
            return bl;
        }

        private boolean doValidate(AbstractImport abstractImport, File file, File file2) {
            if (file == null) {
                if (file2 == null || !file2.isDirectory()) {
                    return false;
                }
                for (File file3 : FileUtils.listFiles((File)file2, (String[])abstractImport.getFileExtensions(), (boolean)true)) {
                    boolean bl = this.doValidate(abstractImport, file3, null);
                    if (!bl) continue;
                    return true;
                }
            } else if (file.isFile()) {
                LOGGER.info("validating '" + file.getName() + "' against " + abstractImport.getName() + " format");
                try {
                    String string = abstractImport.validateFile(file);
                    this.validatedFormat = abstractImport;
                    this.validatedVersion = StringUtils.trimToNull((String)string);
                    LOGGER.info("> successfully validated");
                    LOGGER.info("> found version " + StringUtils.trimToNull((String)string));
                    return true;
                }
                catch (IOException iOException) {
                    LOGGER.info("> validation failed");
                    LOGGER.info("> " + iOException.getLocalizedMessage());
                }
            }
            return false;
        }

        private boolean doValidateAll(File file, File file2) {
            for (AbstractImport abstractImport : AbstractImport.getImports().values()) {
                boolean bl = this.doValidate(abstractImport, file, file2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyImportDialog.this.busyLabel.setText("<html><b>" + I18N.tr("The validation failed!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
        }

        protected void finished() {
            super.finished();
            AgencyImportDialog.this.busyLabel.setBusy(false);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (Boolean.TRUE.equals(bl)) {
                String string = this.validatedFormat == null ? I18N.tr("The selected file contains an unknown format.") : (this.validatedVersion == null ? I18N.tr("The selected file contains the {0} format in an unknown version.", (Object)("<b>" + this.validatedFormat.getTitle() + "</b>")) : I18N.tr("The selected file contains the {0} format in version {1}.", (Object)("<b>" + this.validatedFormat.getTitle() + "</b>"), (Object)("<b>" + this.validatedVersion + "</b>")));
                AgencyImportDialog.this.busyLabel.setText("<html><b>" + I18N.tr("The selected file is valid!") + "</b><br>" + StringUtils.trimToEmpty((String)string) + "</html>");
                if (this.validatedFormat != null) {
                    AgencyImportDialog.this.setCurrentFormatClass(this.validatedFormat.getClass());
                }
                if (this.validatedVersion != null) {
                    AgencyImportDialog.this.setCurrentFormatVersion(this.validatedVersion);
                }
            } else {
                AgencyImportDialog.this.busyLabel.setText("<html><b>" + I18N.tr("The validation failed!") + "</b><br>" + I18N.tr("The selected file seems to be not importable.") + "</html>");
            }
        }
    }

    private class ValidationAction
    extends AbstractI18nAction {
        private ValidationAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"launch.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyImportDialog.this.doValidate();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("validate")));
            this.setShortDescription(I18N.tr("Validate the selected file."));
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyImportDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("start import")));
            this.setShortDescription(I18N.tr("Start the import procedure with the provided settings."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyImportDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window and cancel the import procedure."));
        }
    }

    private class GeneralOptionsTab
    extends AbstractImportTab {
        private JXTitledSeparator title;
        private JLabel statusLabel;
        private JComboBox<DbAgencyObject.Status> statusBox;
        private JLabel languageLabel;
        private JComboBox<Locale> languageBox;
        private JLabel updateMethodLabel;
        private JComboBox<AgencyImportTask.UpdateMethod> updateMethodBox;
        private JCheckBox dontUpdateAttachmentsBox;
        private JCheckBox dontUpdateLinksBox;
        private JCheckBox dontUpdateContactBox;
        private JCheckBox dontUpdateStatusBox;
        private JLabel deleteMethodLabel;
        private JComboBox<AgencyImportTask.DeleteMethod> deleteMethodBox;
        private JCheckBox importDeletedBox;

        private GeneralOptionsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.statusLabel = new JLabel();
            this.statusBox = new JComboBox();
            this.statusBox.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.statusBox.addItem(null);
            for (DbAgencyObject.Status enum_ : DbAgencyObject.Status.values()) {
                this.statusBox.addItem(enum_);
            }
            this.statusBox.setSelectedItem((Object)DbAgencyObject.Status.TRAY);
            this.languageLabel = new JLabel();
            this.languageLabel.setEnabled(false);
            this.languageBox = new LocaleComboBox(AgencyPlugin.getLocales(), true);
            this.languageBox.setEnabled(false);
            this.languageBox.setSelectedItem(Locale.getDefault());
            this.updateMethodLabel = new JLabel();
            this.updateMethodBox = new JComboBox();
            this.updateMethodBox.setRenderer((ListCellRenderer<AgencyImportTask.UpdateMethod>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<AgencyImportTask.UpdateMethod>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.updateMethodBox.addItem(null);
            for (Enum enum_ : AgencyImportTask.UpdateMethod.values()) {
                this.updateMethodBox.addItem((AgencyImportTask.UpdateMethod)enum_);
            }
            this.updateMethodBox.setSelectedItem((Object)AgencyImportTask.UpdateMethod.UPDATE_NOTHING);
            this.updateMethodBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyImportTask.UpdateMethod updateMethod = (AgencyImportTask.UpdateMethod)((Object)GeneralOptionsTab.this.updateMethodBox.getSelectedItem());
                    boolean bl = updateMethod != null && !AgencyImportTask.UpdateMethod.UPDATE_NOTHING.equals((Object)updateMethod);
                    GeneralOptionsTab.this.dontUpdateAttachmentsBox.setEnabled(bl);
                    GeneralOptionsTab.this.dontUpdateLinksBox.setEnabled(bl);
                    GeneralOptionsTab.this.dontUpdateContactBox.setEnabled(bl);
                    GeneralOptionsTab.this.dontUpdateStatusBox.setEnabled(bl);
                }
            });
            this.deleteMethodLabel = new JLabel();
            this.deleteMethodBox = new JComboBox();
            this.deleteMethodBox.setRenderer((ListCellRenderer<AgencyImportTask.DeleteMethod>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<AgencyImportTask.DeleteMethod>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.deleteMethodBox.addItem(null);
            this.deleteMethodBox.addItem(AgencyImportTask.DeleteMethod.DELETE_NOTHING);
            this.deleteMethodBox.setSelectedItem((Object)AgencyImportTask.DeleteMethod.DELETE_NOTHING);
            this.dontUpdateAttachmentsBox = new JCheckBox();
            this.dontUpdateLinksBox = new JCheckBox();
            this.dontUpdateContactBox = new JCheckBox();
            this.dontUpdateStatusBox = new JCheckBox();
            this.importDeletedBox = new JCheckBox();
            this.importDeletedBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralOptionsTab.this.deleteMethodBox.setEnabled(!GeneralOptionsTab.this.importDeletedBox.isSelected());
                    if (GeneralOptionsTab.this.importDeletedBox.isSelected()) {
                        GeneralOptionsTab.this.deleteMethodBox.setSelectedItem((Object)AgencyImportTask.DeleteMethod.DELETE_NOTHING);
                    }
                }
            });
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 50dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.title).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.statusLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.statusBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.languageLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.languageBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.updateMethodLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.updateMethodBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.dontUpdateStatusBox).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.dontUpdateContactBox).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.dontUpdateAttachmentsBox).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.dontUpdateLinksBox).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.deleteMethodLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.deleteMethodBox).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.importDeletedBox).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(10, 10));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("options"));
        }

        @Override
        public void load(AgencyImportTask.Settings settings) {
            this.deleteMethodBox.setSelectedItem((Object)settings.getDeleteMethod());
            this.importDeletedBox.setSelected(settings.isImportRemovedObjects());
            this.languageBox.setSelectedItem(settings.getLanguage());
            this.statusBox.setSelectedItem((Object)settings.getAgencyObjectStatus());
            this.dontUpdateAttachmentsBox.setSelected(!settings.isUpdateAttachments());
            this.dontUpdateLinksBox.setSelected(!settings.isUpdateLinks());
            this.dontUpdateContactBox.setSelected(!settings.isUpdateContact());
            this.updateMethodBox.setSelectedItem((Object)settings.getUpdateMethod());
            this.dontUpdateStatusBox.setSelected(!settings.isUpdateStatus());
        }

        @Override
        public void save(AgencyImportTask.Settings settings) {
            settings.setAgencyObjectStatus((DbAgencyObject.Status)((Object)this.statusBox.getSelectedItem()));
            settings.setDeleteMethod((AgencyImportTask.DeleteMethod)((Object)this.deleteMethodBox.getSelectedItem()));
            settings.setImportRemovedObjects(this.importDeletedBox.isSelected());
            settings.setLanguage((Locale)this.languageBox.getSelectedItem());
            settings.setUpdateAttachments(!this.dontUpdateAttachmentsBox.isSelected());
            settings.setUpdateLinks(!this.dontUpdateLinksBox.isSelected());
            settings.setUpdateContact(!this.dontUpdateContactBox.isSelected());
            settings.setUpdateMethod((AgencyImportTask.UpdateMethod)((Object)this.updateMethodBox.getSelectedItem()));
            settings.setUpdateStatus(!this.dontUpdateStatusBox.isSelected());
        }

        private void updateDeleteMethods(boolean bl) {
            this.deleteMethodBox.setSelectedIndex(-1);
            this.deleteMethodBox.removeAllItems();
            this.deleteMethodBox.addItem(null);
            for (AgencyImportTask.DeleteMethod deleteMethod : AgencyImportTask.DeleteMethod.values()) {
                if (AgencyImportTask.DeleteMethod.DELETE_EXPLICITLY.equals((Object)deleteMethod) && !bl) continue;
                this.deleteMethodBox.addItem(deleteMethod);
            }
            this.deleteMethodBox.setSelectedItem((Object)AgencyImportTask.DeleteMethod.DELETE_NOTHING);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("general options")));
            this.statusLabel.setText(StringUtils.capitalize((String)(I18N.tr("status") + ":")));
            this.statusBox.setToolTipText(I18N.tr("Please select the status, that is assigned to imported properties."));
            this.languageLabel.setText(StringUtils.capitalize((String)(I18N.tr("language") + ":")));
            this.languageBox.setToolTipText(I18N.tr("Please select the language, that is used for the imported properties."));
            this.updateMethodLabel.setText(StringUtils.capitalize((String)(I18N.tr("updates") + ":")));
            this.updateMethodBox.setToolTipText(I18N.tr("Please select, how to proceed with updated properties during the import."));
            this.deleteMethodLabel.setText(StringUtils.capitalize((String)(I18N.tr("removals") + ":")));
            this.deleteMethodBox.setToolTipText(I18N.tr("Please select, how to proceed with removed properties during the import."));
            this.dontUpdateAttachmentsBox.setText(I18N.tr("Don't update attachments."));
            this.dontUpdateAttachmentsBox.setToolTipText(I18N.tr("Don't replace the attachments of updated properties."));
            this.dontUpdateLinksBox.setText(I18N.tr("Don't update web links."));
            this.dontUpdateLinksBox.setToolTipText(I18N.tr("Don't replace the web links of updated properties."));
            this.dontUpdateContactBox.setText(I18N.tr("Don't update contact persons."));
            this.dontUpdateContactBox.setToolTipText(I18N.tr("Don't replace the contact person of updated properties."));
            this.dontUpdateStatusBox.setText(I18N.tr("Don't update the property status."));
            this.dontUpdateStatusBox.setToolTipText(I18N.tr("Don't replace the status of updated properties."));
            this.importDeletedBox.setText(I18N.tr("Import properties designated for removal."));
            this.importDeletedBox.setToolTipText(I18N.tr("Also import properties, that are designated for removal in the import file."));
        }
    }

    private class FileSelectionTab
    extends AbstractImportTab
    implements PropertyChangeListener {
        private JFileChooser fileChooser;

        private FileSelectionTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(10, 10));
            this.setOpaque(true);
            this.fileChooser = new JFileChooser();
            this.fileChooser.setOpaque(false);
            this.fileChooser.setBorder(Paddings.EMPTY);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.addPropertyChangeListener(this);
            if (lastFolder != null && lastFolder.isDirectory()) {
                this.fileChooser.setCurrentDirectory(lastFolder);
            }
            this.add(this.fileChooser, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("select file"));
        }

        @Override
        public void load(AgencyImportTask.Settings settings) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                File file = (File)propertyChangeEvent.getNewValue();
                AgencyImportDialog.this.setCurrentFile(file);
            }
        }

        @Override
        public void save(AgencyImportTask.Settings settings) {
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    public static abstract class AbstractImportTab
    extends AbstractTab {
        protected AbstractImportTab() {
        }

        public abstract void load(AgencyImportTask.Settings var1);

        public abstract void save(AgencyImportTask.Settings var1);
    }
}

