/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.extensions.ProjectAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyProjectExtension
extends ProjectAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyProjectExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyProjectExtension.class);

    public void clean(ImmoToolProject immoToolProject) {
    }

    public void close(ImmoToolProject immoToolProject) {
        AgencyExportHandler.stop(true);
        AgencyPlugin.unloadSettings();
        AgencyPlugin.setDbAgencyExtension(null);
    }

    public void open(ImmoToolProject immoToolProject) throws ImmoToolException {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(immoToolProject);
        if (dbAgencyExtension == null) {
            throw new ImmoToolException("Can't find a usable DbAgencyExtension!");
        }
        AgencyPlugin.setDbAgencyExtension(dbAgencyExtension);
        try {
            AgencyPlugin.loadSettings(immoToolProject);
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load agency settings!", (Throwable)exception);
        }
        AgencyExportHandler.start();
    }
}

