/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSettings;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySearchCriteriaPanel;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.gui.AgencySearchRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.Permission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencySetupSearchPanel
extends ImmoToolSetupDialog.AbstractForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySetupSearchPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySetupSearchPanel.class);
    private DbAgencySearch currentTemplate = null;
    private DbUser currentUser = null;
    private JXTitledSeparator templateTitle;
    private JLabel templateInfoLabel;
    private JLabel templateLabel;
    private JComboBox<DbAgencySearch> templateField;
    private JCheckBox publicPermissionField;
    private AgencySearchCriteriaPanel criteriaPanel;
    private AbstractI18nAction templateAddAction;
    private AbstractI18nAction templateCopyAction;
    private AbstractI18nAction templateRemoveAction;

    public AgencySetupSearchPanel() {
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.templateTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.templateAddAction = new TemplateAddAction();
        this.templateCopyAction = new TemplateCopyAction();
        this.templateRemoveAction = new TemplateRemoveAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.templateTitle, (Action[])new Action[]{this.templateAddAction, this.templateCopyAction, this.templateRemoveAction});
        this.templateInfoLabel = new JLabel();
        this.templateLabel = new JLabel();
        this.templateField = new JComboBox();
        this.templateField.setRenderer((ListCellRenderer<DbAgencySearch>)new DefaultListCellRenderer((Renderer)new AgencySearchRenderer()));
        this.templateField.setEditor(new SearchEditor());
        this.templateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencySetupSearchPanel.this.templateField.isEnabled()) {
                    return;
                }
                try {
                    if (AgencySetupSearchPanel.this.currentTemplate != null) {
                        AgencySetupSearchPanel.this.criteriaPanel.save(AgencySetupSearchPanel.this.currentTemplate);
                    }
                    AgencySetupSearchPanel.this.currentTemplate = (DbAgencySearch)((Object)AgencySetupSearchPanel.this.templateField.getSelectedItem());
                    if (AgencySetupSearchPanel.this.currentTemplate != null) {
                        AgencySetupSearchPanel.this.criteriaPanel.setCurrentSearch(AgencySetupSearchPanel.this.currentTemplate);
                    }
                    AgencySetupSearchPanel.this.criteriaPanel.setVisible(AgencySetupSearchPanel.this.currentTemplate != null);
                    AgencySetupSearchPanel.this.templateField.setEditable(AgencySetupSearchPanel.this.currentTemplate != null);
                    AgencySetupSearchPanel.this.templateCopyAction.setEnabled(AgencySetupSearchPanel.this.currentTemplate != null);
                    AgencySetupSearchPanel.this.publicPermissionField.setEnabled(AgencySetupSearchPanel.this.currentTemplate != null && AgencySetupSearchPanel.this.currentUser != null && (((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentUser.isAdmin || ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.ownerUserId == ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentUser.id));
                    AgencySetupSearchPanel.this.publicPermissionField.setSelected(AgencySetupSearchPanel.this.currentTemplate != null && ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.permission != null && ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.permission.canReadByGroup());
                    AgencySetupSearchPanel.this.templateRemoveAction.setEnabled(AgencySetupSearchPanel.this.currentTemplate != null && AgencySetupSearchPanel.this.currentUser != null && ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.permission != null && ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.permission.canDelete(AgencySetupSearchPanel.this.currentUser, ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.ownerUserId, ((AgencySetupSearchPanel)AgencySetupSearchPanel.this).currentTemplate.ownerGroupId));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load search criteria!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        });
        this.publicPermissionField = new JCheckBox();
        this.criteriaPanel = new AgencySearchCriteriaPanel();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.criteriaPanel));
        jScrollPane.setBorder(Paddings.EMPTY);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[30dlu,pref], 3dlu, pref:grow, 3dlu, pref");
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.templateInfoLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.templateLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.templateField).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.publicPermissionField).xyw(3, defaultFormBuilder.nextRow(), 3);
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(jScrollPane, "Center");
    }

    private void doTemplateAdd(DbAgencySearch dbAgencySearch) {
        DbAgencySearch dbAgencySearch2;
        try {
            this.saveCurrentTemplate();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't save current search template!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        String string = StringUtils.capitalize((String)I18N.tr("new search template"));
        int n = 0;
        for (int i = 0; i < this.templateField.getItemCount(); ++i) {
            dbAgencySearch2 = this.templateField.getItemAt(i);
            if (!dbAgencySearch2.item.getName().toLowerCase().startsWith(string.toLowerCase())) continue;
            ++n;
        }
        DbUser dbUser = ImmoToolProject.getAppUser();
        dbAgencySearch2 = AgencySearchCriteriaPanel.getDefaultSearch(n > 0 ? string + " (" + n + ")" : string, DbAgencySearch.Type.TEMPLATE);
        if (dbAgencySearch != null) {
            dbAgencySearch2.item = new SearchImpl();
            dbAgencySearch2.item.getAttribConditions().addAll(dbAgencySearch.item.getAttribConditions());
            dbAgencySearch2.item.getParams().putAll(dbAgencySearch.item.getParams());
            for (SearchImpl.SimpleConditionType simpleConditionType : SearchImpl.SimpleConditionType.values()) {
                dbAgencySearch2.item.getSimpleConditions(simpleConditionType).addAll(dbAgencySearch.item.getSimpleConditions(simpleConditionType));
            }
            dbAgencySearch2.item.setName(dbAgencySearch.item.getName() + " (" + I18N.tr("copied") + ")");
        }
        dbAgencySearch2.ownerUserId = dbUser != null ? dbUser.id : 0L;
        dbAgencySearch2.permission = new Permission(0);
        dbAgencySearch2.permission.putFlag(1);
        dbAgencySearch2.permission.putFlag(2);
        dbAgencySearch2.permission.putFlag(4);
        dbAgencySearch2.permission.putFlag(8);
        dbAgencySearch2.permission.putFlag(16);
        this.templateField.setEnabled(false);
        this.templateField.addItem(dbAgencySearch2);
        this.templateField.setEnabled(true);
        this.templateField.setSelectedItem((Object)dbAgencySearch2);
        this.templateField.requestFocus();
        this.templateField.getEditor().selectAll();
    }

    private void doTemplateRemove() {
        DbAgencySearch dbAgencySearch = (DbAgencySearch)((Object)this.templateField.getSelectedItem());
        if (dbAgencySearch == null) {
            return;
        }
        this.templateField.setEnabled(false);
        this.templateField.removeItem((Object)dbAgencySearch);
        this.templateField.setEnabled(true);
        this.templateField.setSelectedItem(null);
        this.templateField.setEnabled(this.templateField.getItemCount() > 0);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("search templates"));
    }

    public boolean isProjectRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
        this.currentUser = immoToolProject.getUser();
        DefaultComboBoxModel<DbAgencySearch> defaultComboBoxModel = new DefaultComboBoxModel<DbAgencySearch>();
        try {
            DbSearch[] dbSearchArray = dbAgencySearchesHandler.getSearches(connection, (Boolean)true, DbAgencySearch.Type.TEMPLATE);
            dbAgencySearchesHandler.loadAttribConditions(connection, dbSearchArray);
            dbAgencySearchesHandler.loadValueConditions(connection, dbSearchArray);
            for (DbSearch dbSearch : dbSearchArray) {
                defaultComboBoxModel.addElement((DbAgencySearch)dbSearch);
            }
            this.currentTemplate = null;
            this.templateField.setEnabled(false);
            this.templateField.setModel(defaultComboBoxModel);
            this.templateField.setEnabled(true);
            this.templateField.setSelectedItem(null);
            this.templateField.setEnabled(defaultComboBoxModel.getSize() > 0);
        }
        catch (Throwable throwable) {
            this.currentTemplate = null;
            this.templateField.setEnabled(false);
            this.templateField.setModel(defaultComboBoxModel);
            this.templateField.setEnabled(true);
            this.templateField.setSelectedItem(null);
            this.templateField.setEnabled(defaultComboBoxModel.getSize() > 0);
            this.publicPermissionField.setVisible(immoToolProject.isRemoteProject());
            throw throwable;
        }
        this.publicPermissionField.setVisible(immoToolProject.isRemoteProject());
    }

    public void save(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
        try {
            this.saveCurrentTemplate();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't save current search template!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        long[] lArray = dbAgencySearchesHandler.getSearchIds(connection, (Boolean)true, DbAgencySearch.Type.TEMPLATE);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.templateField.getItemCount(); ++i) {
            DbAgencySearch dbAgencySearch = this.templateField.getItemAt(i);
            if (dbAgencySearch == null) continue;
            dbAgencySearchesHandler.saveSearch(connection, dbAgencySearch, false, true);
            arrayList.add(dbAgencySearch.id);
        }
        for (long l : lArray) {
            if (arrayList.contains(l)) continue;
            dbAgencySearchesHandler.removeSearch(connection, l);
        }
    }

    private void saveCurrentTemplate() {
        DbAgencySearch dbAgencySearch = (DbAgencySearch)((Object)this.templateField.getSelectedItem());
        if (dbAgencySearch != null) {
            this.criteriaPanel.save(dbAgencySearch);
            if (this.publicPermissionField.isEnabled()) {
                dbAgencySearch.permission = new Permission(0);
                dbAgencySearch.permission.putFlag(1);
                dbAgencySearch.permission.putFlag(2);
                dbAgencySearch.permission.putFlag(4);
                if (this.publicPermissionField.isSelected()) {
                    dbAgencySearch.permission.putFlag(8);
                    dbAgencySearch.permission.putFlag(16);
                }
            }
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.templateTitle.setTitle(StringUtils.capitalize((String)I18N.tr("templates for property search")));
        this.templateInfoLabel.setText("<html>" + I18N.tr("Frequently used search requests can be saved as template.") + "</html>");
        this.templateLabel.setText(StringUtils.capitalize((String)I18N.tr("template")) + ":");
        this.publicPermissionField.setText(StringUtils.capitalize((String)I18N.tr("available for other users")));
    }

    private static class SearchEditor
    extends JTextField
    implements ComboBoxEditor {
        private DbAgencySearch currentSearch = null;
        private String currentName = null;

        private SearchEditor() {
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    String string = SearchEditor.this.getText().trim();
                    if (!string.equals(SearchEditor.this.currentName)) {
                        SearchEditor.this.currentSearch = (DbAgencySearch)((Object)SearchEditor.this.getItem());
                    }
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            if (object instanceof DbAgencySearch) {
                this.currentSearch = (DbAgencySearch)((Object)object);
                this.currentName = this.currentSearch.item.getName();
                this.setText(this.currentName);
            } else {
                this.currentSearch = null;
                this.currentName = null;
                this.setText("");
            }
        }

        @Override
        public Object getItem() {
            if (this.currentSearch == null) {
                return null;
            }
            this.currentName = this.getText().trim();
            this.currentSearch.item.setName(this.currentName);
            return this.currentSearch;
        }
    }

    private class TemplateRemoveAction
    extends AbstractI18nAction {
        private TemplateRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySetupSearchPanel.this.doTemplateRemove();
        }

        protected final void updateLocalization() {
            this.setShortDescription(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the current search template."));
        }
    }

    private class TemplateCopyAction
    extends AbstractI18nAction {
        private TemplateCopyAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_copy.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySetupSearchPanel.this.doTemplateAdd(AgencySetupSearchPanel.this.currentTemplate);
        }

        protected final void updateLocalization() {
            this.setShortDescription(StringUtils.capitalize((String)I18N.tr("copy")));
            this.setShortDescription(I18N.tr("Copy the current search template."));
        }
    }

    private class TemplateAddAction
    extends AbstractI18nAction {
        private TemplateAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySetupSearchPanel.this.doTemplateAdd(null);
        }

        protected final void updateLocalization() {
            this.setShortDescription(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Create a new search template."));
        }
    }
}

