/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyExportLog
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyExportLog.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyExportLog.class);
    public static final String REQUEST_NR_PREFIX = "REQUEST-NR";
    public long id = 0L;
    public long exportId = 0L;
    public String format = null;
    public String transport = null;
    public AbstractFormat.TransferMode transferMode = null;
    public int limit = 0;
    public int countInserts = 0;
    public int countUpdates = 0;
    public int countDeletes = 0;
    public int countErrors = 0;
    public int countWarnings = 0;
    public int countNotices = 0;
    public Date time = null;
    public Map<Long, DbAgencyExportLogEntry> entries = null;
    public List<DbAgencyExportLogMessage> messages = null;

    public DbAgencyExportLogMessage[] getGeneralMessages() {
        return this.getMessages(0L);
    }

    public DbAgencyExportLogMessage[] getMessages(long l) {
        if (this.messages == null) {
            return null;
        }
        if (this.messages.isEmpty()) {
            return new DbAgencyExportLogMessage[0];
        }
        ArrayList<DbAgencyExportLogMessage> arrayList = new ArrayList<DbAgencyExportLogMessage>();
        for (DbAgencyExportLogMessage dbAgencyExportLogMessage : this.messages) {
            if (l > 0L && dbAgencyExportLogMessage.objectId == l) {
                arrayList.add(dbAgencyExportLogMessage);
                continue;
            }
            if (l >= 1L || dbAgencyExportLogMessage.objectId >= 1L) continue;
            arrayList.add(dbAgencyExportLogMessage);
        }
        return arrayList.toArray(new DbAgencyExportLogMessage[0]);
    }

    public String writeHtmlReport(String string) {
        String string2;
        Object object;
        int n;
        String string3 = System.lineSeparator();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
        AbstractTransport abstractTransport = AbstractTransport.getTransport(this.transport);
        AbstractFormat abstractFormat = AbstractFormat.getFormat(this.format);
        String string4 = "";
        string4 = string4 + "<html>" + string3;
        string4 = string4 + "<head>" + string3;
        string4 = string4 + "<style>" + string3;
        string4 = string4 + "body {" + string3;
        string4 = string4 + "  font-family: sans-serif;" + string3;
        string4 = string4 + "  color: #" + ImmoToolUtils.writeHexColor((Color)Color.BLACK) + ";" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "h1 {" + string3;
        string4 = string4 + "  font-weight: normal;" + string3;
        string4 = string4 + "  font-size: 18px;" + string3;
        string4 = string4 + "  margin: 15px 0 10px 0;" + string3;
        string4 = string4 + "  padding: 0;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "h2 {" + string3;
        string4 = string4 + "  font-weight: normal;" + string3;
        string4 = string4 + "  font-size: 16px;" + string3;
        string4 = string4 + "  margin: 20px 0 10px 0;" + string3;
        string4 = string4 + "  padding: 0;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "table {" + string3;
        string4 = string4 + "  width: 100%;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "th, td {" + string3;
        string4 = string4 + "  margin: 0;" + string3;
        string4 = string4 + "  padding: 4px;" + string3;
        string4 = string4 + "  font-size: 12px;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "td, th {" + string3;
        string4 = string4 + "  border-bottom: 1px solid #" + ImmoToolUtils.writeHexColor((Color)Color.DARK_GRAY) + ";" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "th.title, td.title {" + string3;
        string4 = string4 + "  background-color: #" + ImmoToolUtils.writeHexColor((Color)ImmoToolUtils.TABLE_HIGHLIGHT_COLOR) + ";" + string3;
        string4 = string4 + "  border-top: 1px solid #" + ImmoToolUtils.writeHexColor((Color)Color.DARK_GRAY) + ";" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + ".center {" + string3;
        string4 = string4 + "  text-align: center;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "p {" + string3;
        string4 = string4 + "  font-size: 12px;" + string3;
        string4 = string4 + "  margin: 0 0 5px 0;" + string3;
        string4 = string4 + "  padding: 0;" + string3;
        string4 = string4 + "}" + string3;
        string4 = string4 + "</style>" + string3;
        string4 = string4 + "</head>" + string3;
        string4 = string4 + "<body>" + string3;
        String string5 = I18N.tr("export via interface {0} at {1}", (Object)("<b>" + StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)string)) + "</b>"), (Object)("<b>" + StringEscapeUtils.escapeXml11((String)dateFormat.format(this.time)) + "</b>"));
        string4 = string4 + "<h1>" + StringUtils.capitalize((String)string5) + "</h1>" + string3;
        string4 = string4 + "<h2>" + StringUtils.capitalize((String)I18N.tr("settings")) + "</h2>" + string3;
        string4 = string4 + "<table cellpadding=\"0\" cellspacing=\"0\">" + string3;
        string4 = string4 + "<tr>" + string3;
        String string6 = abstractFormat != null ? StringEscapeUtils.escapeXml11((String)abstractFormat.getTitle()) : StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)this.format));
        string4 = string4 + "  <td class=\"title\"><b>" + StringUtils.capitalize((String)I18N.tr("format")) + "</b><br/>" + string6 + "</td>" + string3;
        String string7 = abstractTransport != null ? StringEscapeUtils.escapeXml11((String)abstractTransport.getTitle()) : StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)this.transport));
        string4 = string4 + "  <td class=\"title\"><b>" + StringUtils.capitalize((String)I18N.tr("transport")) + "</b><br/>" + string7 + "</td>" + string3;
        String string8 = this.transferMode != null ? StringEscapeUtils.escapeXml11((String)this.transferMode.getTranslation()) : "<i>" + StringEscapeUtils.escapeXml11((String)I18N.tr("unknown")) + "</i>";
        string4 = string4 + "  <td class=\"title\"><b>" + StringUtils.capitalize((String)I18N.tr("mode")) + "</b><br/>" + string8 + "</td>" + string3;
        String string9 = this.limit > 0 ? numberFormat.format(this.limit) : StringEscapeUtils.escapeXml11((String)I18N.tr("unlimited"));
        string4 = string4 + "  <td class=\"title\"><b>" + StringUtils.capitalize((String)I18N.tr("limit")) + "</b><br/>" + string9 + "</td>" + string3;
        string4 = string4 + "</tr>" + string3;
        string4 = string4 + "</table>" + string3;
        string4 = string4 + "<h2>" + StringUtils.capitalize((String)I18N.tr("summary")) + "</h2>" + string3;
        if (this.entries == null || this.entries.isEmpty()) {
            string4 = string4 + "<p>" + I18N.tr("No properties were transferred.") + "</p>" + string3;
        } else {
            string4 = string4 + "<table cellpadding=\"0\" cellspacing=\"0\">" + string3;
            string4 = string4 + "<tr>" + string3;
            string4 = string4 + "  <th class=\"title\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("property"))) + "</th>" + string3;
            string4 = string4 + "  <th class=\"title\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("action"))) + "</th>" + string3;
            string4 = string4 + "  <th class=\"title center\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("errors"))) + "</th>" + string3;
            string4 = string4 + "  <th class=\"title center\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("warnings"))) + "</th>" + string3;
            string4 = string4 + "  <th class=\"title center\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("notices"))) + "</th>" + string3;
            string4 = string4 + "  <th class=\"title center\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("exported"))) + "</th>" + string3;
            string4 = string4 + "</tr>" + string3;
            for (DbAgencyExportLogEntry dbAgencyExportLogEntry : this.entries.values()) {
                n = 0;
                int n2 = 0;
                int n3 = 0;
                if (this.messages != null && !this.messages.isEmpty()) {
                    for (DbAgencyExportLogMessage dbAgencyExportLogMessage : this.messages) {
                        if (dbAgencyExportLogMessage.objectId != dbAgencyExportLogEntry.objectId) continue;
                        if (DbAgencyExportLogMessage.Level.ERROR.equals((Object)dbAgencyExportLogMessage.level)) {
                            ++n;
                            continue;
                        }
                        if (DbAgencyExportLogMessage.Level.WARNING.equals((Object)dbAgencyExportLogMessage.level)) {
                            ++n2;
                            continue;
                        }
                        if (!DbAgencyExportLogMessage.Level.NOTICE.equals((Object)dbAgencyExportLogMessage.level)) continue;
                        ++n3;
                    }
                }
                string4 = string4 + "<tr valign=\"top\">" + string3;
                object = "#" + dbAgencyExportLogEntry.objectId;
                if (!StringUtils.isBlank((CharSequence)dbAgencyExportLogEntry.objectNr)) {
                    object = (String)object + " / " + StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)dbAgencyExportLogEntry.objectNr));
                }
                string4 = string4 + "  <td><a href=\"#" + dbAgencyExportLogEntry.objectId + "\">" + (String)object + "</a></td>" + string3;
                String object22 = dbAgencyExportLogEntry.action != null ? StringEscapeUtils.escapeXml11((String)dbAgencyExportLogEntry.action.getTranslation()) : "<i>" + StringEscapeUtils.escapeXml11((String)I18N.tr("unknown")) + "</i>";
                string4 = string4 + "  <td>" + object22 + "</td>" + string3;
                string4 = string4 + "  <td class=\"center\">" + numberFormat.format(n) + "</td>" + string3;
                string4 = string4 + "  <td class=\"center\">" + numberFormat.format(n2) + "</td>" + string3;
                string4 = string4 + "  <td class=\"center\">" + numberFormat.format(n3) + "</td>" + string3;
                string2 = dbAgencyExportLogEntry.exported ? StringEscapeUtils.escapeXml11((String)OpenEstateConstant.YES.getTranslation()) : StringEscapeUtils.escapeXml11((String)OpenEstateConstant.NO.getTranslation());
                string4 = string4 + "  <td class=\"center\">" + string2 + "</td>" + string3;
                string4 = string4 + "</tr>" + string3;
            }
            string4 = string4 + "</table>" + string3;
        }
        string4 = string4 + "<h2>" + StringUtils.capitalize((String)I18N.tr("messages")) + "</h2>" + string3;
        if (this.messages != null) {
            int n4 = 0;
            int n5 = 0;
            n = 0;
            if (!this.messages.isEmpty()) {
                for (DbAgencyExportLogMessage dbAgencyExportLogMessage : this.messages) {
                    if (DbAgencyExportLogMessage.Level.ERROR.equals((Object)dbAgencyExportLogMessage.level)) {
                        ++n4;
                        continue;
                    }
                    if (DbAgencyExportLogMessage.Level.WARNING.equals((Object)dbAgencyExportLogMessage.level)) {
                        ++n5;
                        continue;
                    }
                    if (!DbAgencyExportLogMessage.Level.NOTICE.equals((Object)dbAgencyExportLogMessage.level)) continue;
                    ++n;
                }
            }
            string4 = string4 + "<p>" + I18N.trn("{0} error", "{0} errors", (long)n4, (Object)("<b style=\"font-size:1.2em;\">" + numberFormat.format(n4) + "</b>")) + ", " + I18N.trn("{0} warning", "{0} warnings", (long)n5, (Object)("<b style=\"font-size:1.2em;\">" + numberFormat.format(n5) + "</b>")) + ", " + I18N.trn("{0} notice", "{0} notices", (long)n, (Object)("<b style=\"font-size:1.2em;\">" + numberFormat.format(n) + "</b>")) + "</p>" + string3;
            if (!this.messages.isEmpty()) {
                string4 = string4 + "<table cellpadding=\"0\" cellspacing=\"0\">" + string3;
                string4 = string4 + "<tr>" + string3;
                string4 = string4 + "  <th class=\"title\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("property"))) + "</th>" + string3;
                string4 = string4 + "  <th class=\"title\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("type"))) + "</th>" + string3;
                string4 = string4 + "  <th class=\"title\">" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)I18N.tr("message"))) + "</th>" + string3;
                string4 = string4 + "</tr>" + string3;
                for (DbAgencyExportLogMessage dbAgencyExportLogMessage : this.messages) {
                    String string10;
                    String[] stringArray;
                    string4 = string4 + "<tr valign=\"top\">" + string3;
                    object = "-";
                    if (dbAgencyExportLogMessage.objectId > 0L) {
                        object = "<a href=\"#" + dbAgencyExportLogMessage.objectId + "\">";
                        object = (String)object + "#" + dbAgencyExportLogMessage.objectId;
                        DbAgencyExportLogEntry dbAgencyExportLogEntry = this.entries.get(dbAgencyExportLogMessage.objectId);
                        if (dbAgencyExportLogEntry != null && !StringUtils.isBlank((CharSequence)dbAgencyExportLogEntry.objectNr)) {
                            object = (String)object + " / " + StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)dbAgencyExportLogEntry.objectNr));
                        }
                        object = (String)object + "</a>";
                    }
                    string4 = string4 + "  <td>" + (String)object + "</td>" + string3;
                    String string11 = dbAgencyExportLogMessage.level != null ? StringEscapeUtils.escapeXml11((String)dbAgencyExportLogMessage.level.getTranslation()) : "<i>" + StringEscapeUtils.escapeXml11((String)I18N.tr("unknown")) + "</i>";
                    string4 = string4 + "  <td>" + string11 + "</td>" + string3;
                    string4 = string4 + "  <td>";
                    string2 = null;
                    if (string2 == null && abstractFormat != null) {
                        string2 = StringUtils.trimToNull((String)abstractFormat.getMessageCodeTranslation(dbAgencyExportLogMessage.code));
                    }
                    if (string2 == null && abstractTransport != null) {
                        string2 = StringUtils.trimToNull((String)abstractTransport.getMessageCodeTranslation(dbAgencyExportLogMessage.code));
                    }
                    if (string2 == null) {
                        string2 = StringUtils.trimToNull((String)dbAgencyExportLogMessage.code);
                    }
                    if (string2 != null) {
                        string4 = string4 + "<b style=\"letter-spacing:1px;\">" + StringEscapeUtils.escapeXml11((String)string2) + "</b><br/>";
                    }
                    if ((stringArray = StringUtils.split((String)StringUtils.trimToEmpty((String)dbAgencyExportLogMessage.text), (String)"|", (int)2))[0].startsWith(REQUEST_NR_PREFIX)) {
                        string10 = "<b style=\"color:red;\">" + StringUtils.upperCase((String)I18N.tr("request")) + " " + StringUtils.trimToEmpty((String)StringUtils.substring((String)stringArray[0], (int)REQUEST_NR_PREFIX.length())) + "</b>";
                        if (StringUtils.isNotBlank((CharSequence)stringArray[1])) {
                            string10 = string10 + " | " + StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)stringArray[1]));
                        }
                    } else {
                        string10 = StringEscapeUtils.escapeXml11((String)dbAgencyExportLogMessage.text);
                    }
                    string4 = string4 + StringUtils.trimToEmpty((String)string10);
                    string4 = string4 + "</td>" + string3;
                    string4 = string4 + "</tr>" + string3;
                }
                string4 = string4 + "</table>" + string3;
            }
        }
        string4 = string4 + "</body>" + string3;
        string4 = string4 + "</html>";
        return StringUtils.replace((String)string4, (String)"&apos;", (String)"&#39;");
    }
}

