/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportProcess;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractPhpFormat
extends AbstractFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPhpFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractPhpFormat.class);

    @Override
    public ExportProcess createExportProcess() {
        return new PhpExportProcess(this.getThumbnailWidth(), this.getThumbnailHeight());
    }

    @Override
    public AbstractTransportRequest[] createExportRequests(AbstractTransport abstractTransport, File file, AbstractFormat.TransferMode transferMode) {
        if (abstractTransport instanceof FtpTransport) {
            return new AbstractTransportRequest[]{this.createExportRequestForFtp((FtpTransport)abstractTransport, file)};
        }
        if (abstractTransport instanceof SftpTransport) {
            return new AbstractTransportRequest[]{this.createExportRequestForSftp((SftpTransport)abstractTransport, file)};
        }
        return super.createExportRequests(abstractTransport, file, transferMode);
    }

    protected abstract FtpTransport.Request createExportRequestForFtp(FtpTransport var1, File var2);

    protected abstract SftpTransport.Request createExportRequestForSftp(SftpTransport var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAgencyExpose createExpose(ExportContext exportContext) throws SQLException {
        DbAgencyExpose dbAgencyExpose = null;
        long l = exportContext.export.exposeId;
        if (l > 0L) {
            DbAgencyExposesHandler dbAgencyExposesHandler = exportContext.dbExtension.getExposeHandler();
            Connection connection = null;
            try {
                connection = exportContext.dbDriver.getConnection();
                dbAgencyExpose = dbAgencyExposesHandler.getExpose(connection, l);
                dbAgencyExposesHandler.loadExposeSettings(connection, dbAgencyExpose);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        return dbAgencyExpose;
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public AbstractTransport[] getSupportedTransports() {
        return new AbstractTransport[]{new FtpTransport(), new SftpTransport(), new LocalTransport()};
    }

    protected abstract int getThumbnailHeight();

    protected abstract int getThumbnailWidth();

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
        this.setCompression(AbstractFormat.Compression.UNCOMPRESSED);
        this.setLanguages(new Locale[]{Locale.getDefault()});
        this.setPhpSaveScripts(true);
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }

    public abstract boolean isPhpSaveScripts();

    public abstract void setPhpSaveScripts(boolean var1);

    protected static class PhpExportProcess
    extends ExportProcess {
        private int thumbnailWidth;
        private int thumbnailHeight;

        protected PhpExportProcess(int n, int n2) {
            this.thumbnailWidth = n;
            this.thumbnailHeight = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected File storeAttachment(Connection connection, EstateAttachmentImpl estateAttachmentImpl, File file, ExportContext exportContext, String[] stringArray) throws SQLException, IOException {
            File file2 = super.storeAttachment(connection, estateAttachmentImpl, file, exportContext, stringArray);
            if (file2 == null) {
                return null;
            }
            String string = StringUtils.trimToEmpty((String)estateAttachmentImpl.getMimeType()).toLowerCase();
            if (string.startsWith("image/")) {
                BufferedImage bufferedImage;
                BufferedImage bufferedImage2;
                BufferedImage bufferedImage3;
                File file3;
                block5: {
                    File file4;
                    file3 = new File(file2.getParentFile(), FilenameUtils.getBaseName((String)file2.getName()) + ".thumb.jpg");
                    bufferedImage3 = null;
                    bufferedImage2 = null;
                    bufferedImage = null;
                    try {
                        bufferedImage3 = ImageUtils.readAsRgb((File)file2);
                        if (bufferedImage3 != null) break block5;
                        LOGGER.warn("Image file '" + file2.getAbsolutePath() + "' is not readable!");
                        FileUtils.deleteQuietly((File)file2);
                        file4 = null;
                    }
                    catch (Throwable throwable) {
                        ImageUtils.flush((Image)bufferedImage3);
                        ImageUtils.flush(bufferedImage2);
                        ImageUtils.flush(bufferedImage);
                        throw throwable;
                    }
                    ImageUtils.flush((Image)bufferedImage3);
                    ImageUtils.flush((Image)bufferedImage2);
                    ImageUtils.flush((Image)bufferedImage);
                    return file4;
                }
                bufferedImage2 = ImageUtils.cropToRatio((BufferedImage)bufferedImage3, (int)this.thumbnailWidth, (int)this.thumbnailHeight);
                bufferedImage = ImageUtils.scaleToFit((BufferedImage)bufferedImage2, (int)this.thumbnailWidth, (int)this.thumbnailHeight);
                ImageUtils.writeJpg((BufferedImage)bufferedImage, (File)file3);
                ImageUtils.flush((Image)bufferedImage3);
                ImageUtils.flush((Image)bufferedImage2);
                ImageUtils.flush((Image)bufferedImage);
            }
            return file2;
        }
    }
}

