/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExportProcess {
    private static final I18n I18N = I18nFactory.getI18n(ExportProcess.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportProcess.class);
    private File preparedExportFile = null;

    protected TransferImpl buildTransfer(Connection connection, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, SQLException {
        callback.checkCancelled();
        TransferImpl transferImpl = new TransferImpl();
        transferImpl.setSenderSoftwareMail("dev@openestate.org");
        transferImpl.setSenderSoftwareName(ImmoToolEnvironment.getApplicationTitle());
        transferImpl.setSenderSoftwareVersion(ImmoToolEnvironment.getApplicationVersion());
        transferImpl.getAgencies().add(this.buildTransferAgency(connection, exportContext, callback));
        transferImpl.getCustomValues().getValueMap().clear();
        return transferImpl;
    }

    /*
     * WARNING - void declaration
     */
    protected TransferAgencyImpl buildTransferAgency(Connection connection, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, SQLException {
        Object object;
        callback.checkCancelled();
        AbstractFormat abstractFormat = exportContext.getFormat();
        String[] stringArray = abstractFormat.getAttachmentMimeTypes();
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setRemoveUnmodifiedEstates(exportContext.isFullTranfer());
        transferAgencyImpl.getCustomValues().getValueMap().clear();
        if (exportContext.agent != null) {
            exportContext.agent.setId(StringUtils.trimToNull((String)abstractFormat.getAgentId()));
            object = StringUtils.trimToNull((String)abstractFormat.getAgentMail());
            if (object != null) {
                exportContext.agent.getCompany().setCompanyMail((String)object);
            }
            transferAgencyImpl.setAgent(exportContext.agent);
        }
        object = new ArrayList();
        for (ExportEntry estateImpl : exportContext.entries) {
            Object object2;
            if (DbAgencyExportAction.DELETE.equals((Object)estateImpl.action)) {
                void var10_16;
                void var10_14;
                Object var10_12 = null;
                if (exportContext.export.publishings.containsKey(estateImpl.objectId)) {
                    object2 = exportContext.export.publishings.get(estateImpl.objectId);
                    String string = StringUtils.trimToNull((String)((DbAgencyExportPublishing)object2).objectKey);
                }
                if (var10_14 == null) {
                    String string = abstractFormat.getObjectKey(estateImpl);
                }
                if (var10_16 == null) continue;
                transferAgencyImpl.getEstateIdsToRemove().add(var10_16);
                continue;
            }
            if (DbAgencyExportAction.INSERT.equals((Object)estateImpl.action) || DbAgencyExportAction.UPDATE.equals((Object)estateImpl.action)) {
                EstateImpl estateImpl2;
                try {
                    estateImpl2 = this.buildTransferAgencyObject(connection, estateImpl, exportContext, stringArray, callback);
                }
                catch (AbstractFormat.NotExportableException notExportableException) {
                    LOGGER.warn("Can't build property #" + estateImpl.objectId + " for export!");
                    LOGGER.warn("> " + notExportableException.getLocalizedMessage(), (Throwable)notExportableException);
                    continue;
                }
                if (estateImpl2 == null) {
                    LOGGER.warn("Can't load property #" + estateImpl.objectId + " for export!");
                    continue;
                }
                transferAgencyImpl.getEstatesToSave().add(estateImpl2);
                try {
                    Long l;
                    object2 = StringUtils.trimToNull((String)estateImpl2.getContactId());
                    if (object2 == null || object.contains(l = Long.valueOf((String)object2))) continue;
                    object.add(l);
                }
                catch (Exception exception) {
                    estateImpl2.setContactId(null);
                    LOGGER.warn("Can't load contact id for property #" + estateImpl.objectId + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                continue;
            }
            throw new IOException("Unknown export action for property #" + estateImpl.objectId + "!");
        }
        if (!object.isEmpty()) {
            DbContact[] dbContactArray;
            Object object4 = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
            for (DbContact dbContact : dbContactArray = exportContext.dbExtension.getContactsHandler().getContacts(connection, (long[])object4)) {
                AgentContactImpl agentContactImpl = this.buildTransferAgencyContact(connection, dbContact, exportContext, callback);
                if (agentContactImpl == null) continue;
                transferAgencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
            }
        }
        return transferAgencyImpl;
    }

    protected AgentContactImpl buildTransferAgencyContact(Connection connection, DbContact dbContact, ExportContext exportContext, ImmoToolTask.Callback callback) {
        callback.checkCancelled();
        return dbContact.item;
    }

    protected EstateImpl buildTransferAgencyObject(Connection connection, ExportEntry exportEntry, ExportContext exportContext, String[] stringArray, ImmoToolTask.Callback callback) throws IOException, AbstractFormat.NotExportableException {
        EstateImpl estateImpl;
        callback.checkCancelled();
        AbstractFormat abstractFormat = exportContext.getFormat();
        File file = exportContext.getWorkDir();
        try {
            estateImpl = exportContext.getEstate(exportEntry.objectId);
        }
        catch (DocumentException documentException) {
            throw new IOException("Can't load xml object for property #" + exportEntry.objectId + "!", documentException);
        }
        if (estateImpl == null) {
            throw new IOException("Can't find xml object for property #" + exportEntry.objectId + "!");
        }
        if (!abstractFormat.prepareObjectForExport(exportEntry.objectId, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Property #" + exportEntry.objectId + " is not exportable!");
        }
        ArrayList arrayList = new ArrayList(estateImpl.getAttachments());
        for (EstateAttachmentImpl estateAttachmentImpl : arrayList) {
            File file2;
            callback.checkCancelled();
            File file3 = abstractFormat.getAttachmentDirectory(exportEntry.objectId, estateAttachmentImpl, file);
            if (file3 == null) {
                file3 = file;
            }
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Can't create attachment directory: " + file3.getAbsolutePath());
            }
            try {
                file2 = this.storeAttachment(connection, estateAttachmentImpl, file3, exportContext, stringArray);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't store attachment '" + estateAttachmentImpl.getHash() + "' for property #" + exportEntry.objectId + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                estateImpl.getAttachments().remove(estateAttachmentImpl);
                continue;
            }
            if (file2 == null) {
                LOGGER.warn("Can't store attachment '" + estateAttachmentImpl.getHash() + "' for property #" + exportEntry.objectId + "!");
                estateImpl.getAttachments().remove(estateAttachmentImpl);
                continue;
            }
            String string = file.getAbsolutePath();
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            String string2 = file2.getAbsolutePath().substring(string.length() + 1);
            estateAttachmentImpl.setFile(string2);
        }
        return estateImpl;
    }

    protected final BufferedImage convertImage(File file, ExportContext exportContext) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            BufferedImage bufferedImage = this.convertImage(fileInputStream, exportContext);
            return bufferedImage;
        }
    }

    protected final BufferedImage convertImage(InputStream inputStream, ExportContext exportContext) throws IOException {
        BufferedImage bufferedImage = ImageUtils.read((InputStream)inputStream);
        return this.convertImage(bufferedImage, exportContext);
    }

    protected BufferedImage convertImage(BufferedImage object, ExportContext exportContext) {
        Object object2;
        int n;
        int n2;
        int n3;
        int n4;
        AbstractFormat abstractFormat = exportContext.getFormat();
        if (abstractFormat.isAttachmentImageScale()) {
            n4 = ((BufferedImage)object).getWidth();
            n3 = ((BufferedImage)object).getHeight();
            n2 = abstractFormat.getAttachmentImageScaleWidth();
            n = abstractFormat.getAttachmentImageScaleHeight();
            if (n2 > 0 && n > 0 && (n4 > n2 || n3 > n)) {
                object2 = ImageUtils.scaleToFit((BufferedImage)object, (int)n2, (int)n);
                ((Image)object).flush();
                object = object2;
            }
        }
        if (abstractFormat.isPropertyImageWatermark()) {
            BufferedImage bufferedImage;
            n4 = abstractFormat.getPropertyImageWatermarkMargin();
            n3 = abstractFormat.getPropertyImageWatermarkWidth();
            n2 = abstractFormat.getPropertyImageWatermarkHeight();
            n = abstractFormat.getPropertyImageWatermarkAlpha();
            object2 = abstractFormat.getPropertyImageWatermarkPosition();
            if (object2 == null) {
                object2 = AbstractFormat.ImageWatermarkPosition.BOTTOM_RIGHT;
            }
            if ((bufferedImage = exportContext.getAgentLogo()) != null) {
                int n5;
                int n6;
                int n7;
                int n8;
                BufferedImage bufferedImage2 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                graphics2D.drawImage((Image)object, 0, 0, null);
                if (n2 > 0 && n3 > 0) {
                    n8 = ((BufferedImage)object).getWidth() > n3 + n4 ? n3 : ((BufferedImage)object).getWidth() - n4 * 2;
                    n7 = ((BufferedImage)object).getHeight() > n2 + n4 ? n2 : ((BufferedImage)object).getHeight() - n4 * 2;
                } else {
                    n8 = (int)((double)((BufferedImage)object).getWidth() * 0.5);
                    n7 = (int)((double)((BufferedImage)object).getHeight() * 0.5);
                }
                BufferedImage bufferedImage3 = bufferedImage.getWidth() <= n8 && bufferedImage.getHeight() <= n7 ? bufferedImage : ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)n8, (int)n7);
                int n9 = ((BufferedImage)object).getWidth() - bufferedImage3.getWidth();
                int n10 = ((BufferedImage)object).getHeight() - bufferedImage3.getHeight();
                switch (object2) {
                    case TOP_LEFT: {
                        n6 = n4;
                        n5 = n4;
                        break;
                    }
                    case TOP_CENTER: {
                        n6 = n9 / 2;
                        n5 = n4;
                        break;
                    }
                    case TOP_RIGHT: {
                        n6 = n9 - n4;
                        n5 = n4;
                        break;
                    }
                    case CENTER_LEFT: {
                        n6 = n4;
                        n5 = n10 / 2;
                        break;
                    }
                    case CENTER_CENTER: {
                        n6 = n9 / 2;
                        n5 = n10 / 2;
                        break;
                    }
                    case CENTER_RIGHT: {
                        n6 = n9 - n4;
                        n5 = n10 / 2;
                        break;
                    }
                    case BOTTOM_LEFT: {
                        n6 = n4;
                        n5 = n10 - n4;
                        break;
                    }
                    case BOTTOM_CENTER: {
                        n6 = n9 / 2;
                        n5 = n10 - n4;
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        n6 = n9 - n4;
                        n5 = n10 - n4;
                        break;
                    }
                    default: {
                        n6 = n4;
                        n5 = n4;
                    }
                }
                if (n6 < 0) {
                    n6 = 0;
                } else if (n6 > n9) {
                    n6 = n9;
                }
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 > n10) {
                    n5 = n10;
                }
                if (n > 0 && n < 100) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)n / 100.0f));
                }
                graphics2D.drawImage((Image)bufferedImage3, n6, n5, null);
                ((Image)object).flush();
                object = bufferedImage2;
            }
        }
        return object;
    }

    protected File compress(AbstractFormat.Compression compression, String string, File file) throws IOException {
        if (AbstractFormat.Compression.ZIP.equals((Object)compression)) {
            File file2 = new File(file.getParentFile(), string);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));){
                for (File file3 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                    ImmoToolUtils.loadFileIntoZipStream((File)file3, (ZipOutputStream)zipOutputStream);
                }
                zipOutputStream.flush();
            }
            return file2;
        }
        if (AbstractFormat.Compression.GZIP.equals((Object)compression)) {
            throw new UnsupportedOperationException("GZIP is not implemented yet!");
        }
        if (compression != null && !AbstractFormat.Compression.UNCOMPRESSED.equals((Object)compression)) {
            throw new UnsupportedOperationException("Unsupported compression '" + compression.name() + "'!");
        }
        return null;
    }

    protected File doPrepare(TransferImpl transferImpl, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, SQLException, CancellationException {
        callback.checkCancelled();
        AbstractFormat abstractFormat = exportContext.getFormat();
        File file = exportContext.getWorkDir();
        File file2 = abstractFormat.writeToDisk(file, transferImpl, exportContext);
        if (file2 == null || !file2.exists()) {
            throw new IOException("The files were not properly exported!");
        }
        AbstractFormat.Compression compression = abstractFormat.getCompression();
        if (compression != null && !AbstractFormat.Compression.UNCOMPRESSED.equals((Object)compression)) {
            return this.compress(compression, abstractFormat.getCompressedFileName(compression, exportContext), file2);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTransport(File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
        callback.checkCancelled();
        AbstractFormat abstractFormat = exportContext.getFormat();
        AbstractTransport abstractTransport = exportContext.getTransport();
        Object[] objectArray = abstractFormat.createExportRequests(abstractTransport, file, exportContext.transferMode);
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            LOGGER.info("No transport requests found for export #" + exportContext.export.id + " (" + exportContext.export.name + ").");
            return;
        }
        int n = 0;
        try {
            int n2 = objectArray.length;
            callback.setProgress(0, 0, n2);
            abstractTransport.doInitTransport(exportContext, file, callback);
            for (Object object : objectArray) {
                int n3 = this.sendRequest((AbstractTransportRequest)object, file, exportContext, callback, n, n2, !abstractTransport.isUpdatingMessage(), !abstractTransport.isUpdatingProgress());
                if (n3 < 1) {
                    break;
                }
                n += n3;
                n2 += n3 - 1;
            }
        }
        finally {
            abstractTransport.doFinishTransport(exportContext, callback);
        }
    }

    protected synchronized File getPreparedExportFile() {
        return this.preparedExportFile;
    }

    protected void initWorkDir(File file) throws IOException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Can't create work directory!");
        }
    }

    public final PreparationTask prepare(ExportContext exportContext) {
        this.setPreparedExportFile(null);
        return new PreparationTask(exportContext);
    }

    private int sendRequest(AbstractTransportRequest abstractTransportRequest, File file, ExportContext exportContext, ImmoToolTask.Callback callback, int n, int n2, boolean bl, boolean bl2) throws IOException, CancellationException {
        int n3 = 1;
        callback.checkCancelled();
        if (bl) {
            callback.setMessage(abstractTransportRequest.getTitle());
        }
        if (bl2) {
            callback.setProgress(n, 0, n2);
        }
        LOGGER.info("Execute transport request #" + (n3 + n) + " of export '" + exportContext.export.name + "' (#" + exportContext.export.id + ").");
        try {
            abstractTransportRequest.send(exportContext, callback);
        }
        catch (AbstractTransportRequest.TransferException transferException) {
            LOGGER.error("Can't send transport request #" + (n3 + n) + " of export '" + exportContext.export.name + "' (#" + exportContext.export.id + ")!");
            LOGGER.error("> Remaining transport requests are cancelled.");
            throw new IOException("Transport failed!", transferException);
        }
        Object[] objectArray = abstractTransportRequest.getChildRequests();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            n2 += objectArray.length;
            for (Object object : objectArray) {
                int n4 = this.sendRequest((AbstractTransportRequest)object, file, exportContext, callback, n + n3, n2, bl, bl2);
                if (n4 < 1) {
                    return 0;
                }
                n3 += n4;
                n2 += n4 - 1;
            }
        }
        return n3;
    }

    protected synchronized void setPreparedExportFile(File file) {
        this.preparedExportFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected File storeAttachment(Connection connection, EstateAttachmentImpl estateAttachmentImpl, File file, ExportContext exportContext, String[] stringArray) throws SQLException, IOException {
        Object object;
        Object object2;
        boolean bl;
        String string;
        AbstractFormat abstractFormat = exportContext.getFormat();
        DbFilesHandler dbFilesHandler = exportContext.dbExtension.getFilesHandler();
        DbFile dbFile = dbFilesHandler.getFile(connection, string = StringUtils.trimToNull((String)estateAttachmentImpl.getHash()));
        if (dbFile == null) {
            return null;
        }
        String string2 = StringUtils.lowerCase((String)estateAttachmentImpl.getMimeType());
        boolean bl2 = string2.toLowerCase().startsWith("image/");
        boolean bl3 = bl = bl2 && ImageUtils.isReadableMimeType((String)string2);
        String string3 = bl && !ArrayUtils.contains((Object[])stringArray, (Object)string2) ? (ArrayUtils.contains((Object[])stringArray, (Object)"image/jpeg") ? "jpg" : (ArrayUtils.contains((Object[])stringArray, (Object)"image/png") ? "png" : null)) : null;
        String string4 = "image/bmp".equals(string2) ? "bmp" : ("image/gif".equals(string2) ? "gif" : ("image/jpeg".equals(string2) ? "jpg" : ("image/png".equals(string2) ? "png" : ("application/pdf".equals(string2) ? "pdf" : ((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)FilenameUtils.getExtension((String)dbFile.name)), (CharSequence)"bin")).toLowerCase()))));
        File file2 = new File(file, string + "." + (string3 != null ? string3 : string4));
        if (file2.isFile()) {
            return file2;
        }
        if (bl && (string3 != null || abstractFormat.isAttachmentImageScale() || abstractFormat.isPropertyImageWatermark())) {
            object2 = new File(exportContext.tempDir, "temp_" + dbFile.id + "." + string4);
            Object object3 = new FileOutputStream((File)object2);
            object = null;
            try {
                dbFilesHandler.downloadContent(connection, dbFile.id, (OutputStream)object3);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object != null) {
                        try {
                            ((OutputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)object3).close();
                    }
                }
            }
            object3 = this.convertImage((File)object2, exportContext);
            if ("png".equals(string3)) {
                object3 = ImageUtils.convertToRgb((BufferedImage)object3, (boolean)true);
                ImageUtils.writePng((BufferedImage)object3, (File)file2);
                estateAttachmentImpl.setMimeType("image/png");
            } else if ("jpg".equals(string3)) {
                object3 = ImageUtils.convertToRgb((BufferedImage)object3, (boolean)true);
                ImageUtils.writeJpg((BufferedImage)object3, (File)file2);
                estateAttachmentImpl.setMimeType("image/jpeg");
            } else if ("image/png".equals(string2)) {
                ImageUtils.writePng((BufferedImage)object3, (File)file2);
                estateAttachmentImpl.setMimeType("image/png");
            } else {
                ImageUtils.writeJpg((BufferedImage)object3, (File)file2);
                estateAttachmentImpl.setMimeType("image/jpeg");
            }
            object = new FileInputStream(file2);
            Throwable throwable = null;
            try {
                estateAttachmentImpl.setHash(DigestUtils.sha1Hex((InputStream)object));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            object = file2;
            FileUtils.deleteQuietly((File)object2);
            return object;
            {
                catch (Exception exception) {
                    try {
                        LOGGER.warn("Can't convert image attachment #" + dbFile.id + "!");
                        LOGGER.warn("> The image is exported without conversion.");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        FileUtils.deleteQuietly((File)object2);
                    }
                }
            }
        }
        object2 = new FileOutputStream(file2);
        Throwable throwable = null;
        try {
            dbFilesHandler.downloadContent(connection, dbFile.id, (OutputStream)object2);
            object = file2;
            return object;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (object2 != null) {
                if (throwable != null) {
                    try {
                        ((OutputStream)object2).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    ((OutputStream)object2).close();
                }
            }
        }
    }

    public final TransportTask transport(ExportContext exportContext) {
        return new TransportTask(exportContext);
    }

    public final class TransportTask
    extends ImmoToolTask<Boolean, Void> {
        private final ExportContext context;

        private TransportTask(ExportContext exportContext) {
            super(I18N.tr("Transporting properties for {0}.", (Object)("'" + exportContext.export.name + "'")));
            this.context = exportContext;
        }

        protected Boolean doInBackground() throws Exception {
            File file = ExportProcess.this.getPreparedExportFile();
            if (file == null || !file.exists()) {
                throw new Exception("Export was not prepared before transport!");
            }
            this.checkCancelled();
            ExportProcess.this.doTransport(file, this.context, this.createCallback());
            return true;
        }

        public ExportContext getContext() {
            return this.context;
        }
    }

    public final class PreparationTask
    extends ImmoToolTask<Boolean, Void> {
        private final ExportContext context;

        private PreparationTask(ExportContext exportContext) {
            super(I18N.tr("Exporting properties for {0}.", (Object)("'" + exportContext.export.name + "'")));
            this.context = exportContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            this.checkCancelled();
            ImmoToolTask.Callback callback = this.createCallback();
            ExportProcess.this.initWorkDir(this.context.getWorkDir());
            TransferImpl transferImpl = null;
            Connection connection = null;
            try {
                this.checkCancelled();
                connection = this.context.dbDriver.getConnection();
                this.checkCancelled();
                transferImpl = ExportProcess.this.buildTransfer(connection, this.context, callback);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            this.checkCancelled();
            File file = ExportProcess.this.doPrepare(transferImpl, this.context, callback);
            if (file == null) {
                throw new Exception("No export file was created!");
            }
            ExportProcess.this.setPreparedExportFile(file);
            return true;
        }

        public ExportContext getContext() {
            return this.context;
        }

        protected void finished() {
            super.finished();
            this.context.flushAgentLogo();
        }
    }
}

