/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ImmobilienNetFormatPanel;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmobilienNetFormat
extends OpenImmoXmlFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobilienNetFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmobilienNetFormat.class);
    private static final String NAME = "immobilien_net";

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new ImmobilienNetFormatPanel();
    }

    @Override
    protected String getCompressedFileName(AbstractFormat.Compression compression, ExportContext exportContext) {
        String string = this.getAgentId();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = "";
        }
        if (AbstractFormat.Compression.GZIP.equals((Object)compression)) {
            return string.replaceAll("\\W", "") + "_" + exportContext.stamp.getTime() + ".gzip";
        }
        if (AbstractFormat.Compression.ZIP.equals((Object)compression)) {
            return string.replaceAll("\\W", "") + "_" + exportContext.stamp.getTime() + ".zip";
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected String[] getPreferredMimeTypes() {
        return new String[]{"image/jpeg", "image/png"};
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "Portal: Immobilien.net";
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        return "openimmo.xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
        this.setLanguages(new Locale[]{Locale.GERMAN});
        this.setOpenImmoPropertyPublicIdExported(true);
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }
}

