/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.openimmo.OpenImmoWriter;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.MultiVersionSupport;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormatPanel;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.Aktion;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Anhang;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.Uebertragung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OpenImmoXmlFormat
extends AbstractXmlFormat<Openimmo>
implements MultiVersionSupport {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(OpenImmoXmlFormat.class);
    private static final String NAME = "openimmo";
    private static final String OPENIMMO_AGENT_ID = "openimmo.agent.id";
    private static final String OPENIMMO_ATTACHMENT_LOCATION = "openimmo.attachment.location";
    private static final String OPENIMMO_EXTENSIONS_AT10 = "openimmo.extensions.at10";
    private static final String OPENIMMO_PROPERTY_PUBLIC_ID_EXPORTED = "openimmo.property.publicId.exported";
    private static final String OPENIMMO_TECHNICS_MAIL = "openimmo.technics.mail";
    private static final String OPENIMMO_VERSION = "openimmo.version";

    protected OpenImmoWriter buildWriter() {
        Writer writer = new Writer(this.getLanguage(), this.getPropertyPricePublication(), this.getOpenImmoAttachmentLocation(), this.isOpenImmoExtensionAt10Enabled());
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        AbstractXmlFormat.LineBreakMode lineBreakMode = this.getXmlLineBreak();
        if (lineBreakMode != null) {
            writer.setXmlLineSeparator(lineBreakMode.getSeparator());
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        Openimmo openimmo;
        Object object2;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object2 = this.buildWriter();
            object2.setXmlLineSeparator("<br/>");
            openimmo = (Openimmo)object2.writeToObject(agencyImpl);
            string = object2.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (openimmo == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        openimmo.setUebertragung(null);
        for (Object object322 : openimmo.getAnbieter()) {
            object322.setAnbieternr(null);
            object322.setAnhang(null);
            object322.setFirma(null);
            object322.setImpressum(null);
            object322.setImpressumStrukt(null);
            object322.setLizenzkennung(null);
            object322.setOpenimmoAnid(null);
            for (String string2 : object322.getImmobilie()) {
                if (string2.getVerwaltungTechn() == null) continue;
                string2.getVerwaltungTechn().setStandVom(null);
            }
        }
        try {
            Object object322;
            object2 = new StringWriter();
            object322 = null;
            try {
                String string2;
                OpenImmoUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)openimmo, (java.io.Writer)object2);
                String string3 = ((StringWriter)object2).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                string2 = DigestUtils.sha1Hex((String)string3);
                return string2;
            }
            catch (Throwable throwable) {
                object322 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object322 != null) {
                        try {
                            ((StringWriter)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object322).addSuppressed(throwable);
                        }
                    } else {
                        ((StringWriter)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new OpenImmoXmlFormatPanel();
    }

    @Override
    protected Openimmo convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        boolean bl = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
        OpenImmoWriter openImmoWriter = this.buildWriter();
        Openimmo openimmo = (Openimmo)openImmoWriter.writeToObject(transferImpl);
        if (openimmo == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)this.getOpenImmoTechnicsMail());
        if (string == null && exportContext.agent != null) {
            try {
                string = StringUtils.trimToNull((String)exportContext.agent.getCompany().getCompanyMail());
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load 'techn_mail'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        openimmo.getUebertragung().setTechnEmail(string);
        openimmo.getUebertragung().setUmfang(bl ? Uebertragung.Umfang.TEIL : Uebertragung.Umfang.VOLL);
        String string2 = StringUtils.trimToNull((String)this.getAgentId());
        String string3 = StringUtils.trimToNull((String)this.getOpenImmoAgentId());
        if (string2 != null || string3 != null) {
            for (Object object : openimmo.getAnbieter()) {
                if (string2 != null) {
                    object.setAnbieternr(string2);
                }
                if (string3 == null) continue;
                object.setOpenimmoAnid(string3);
            }
        }
        if (!this.isOpenImmoPropertyPublicIdExported()) {
            for (Object object : openimmo.getAnbieter()) {
                for (Object object2 : object.getImmobilie()) {
                    if (object2.getVerwaltungTechn() == null) continue;
                    object2.getVerwaltungTechn().setObjektnrExtern(object2.getVerwaltungTechn().getObjektnrIntern());
                }
            }
        }
        if (this.isOpenImmoPropertyPublicIdExported()) {
            Object object = StringUtils.trimToNull((String)this.getPropertyPrefix());
            object = object != null ? (String)object + "-" : "";
            for (Anbieter anbieter : openimmo.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    try {
                        String string4;
                        if (immobilie.getVerwaltungTechn() == null || immobilie.getVerwaltungTechn().getAktion() == null || !Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart()) || StringUtils.isBlank((CharSequence)(string4 = immobilie.getVerwaltungTechn().getObjektnrIntern()))) continue;
                        if (((String)object).length() > 0) {
                            string4 = string4.substring(((String)object).length());
                        }
                        long l = Long.parseLong(string4.trim());
                        for (ExportEntry exportEntry : exportContext.entries) {
                            if (exportEntry.objectId != l || StringUtils.isBlank((CharSequence)exportEntry.objectNr)) continue;
                            immobilie.getVerwaltungTechn().setObjektnrExtern((String)object + exportEntry.objectNr);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't update public estate-id!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
        }
        exportContext.addErrorMessages(openImmoWriter.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return openimmo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getOpenImmoAgentId() {
        return (String)this.get(OPENIMMO_AGENT_ID);
    }

    public AbstractFormat.AttachmentMarker getOpenImmoAttachmentLocation() {
        String string = StringUtils.trimToNull((String)((String)this.get(OPENIMMO_ATTACHMENT_LOCATION)));
        return string != null ? AbstractFormat.AttachmentMarker.valueOf(string.toUpperCase()) : null;
    }

    public String getOpenImmoTechnicsMail() {
        return StringUtils.trimToNull((String)((String)this.get(OPENIMMO_TECHNICS_MAIL)));
    }

    public OpenImmoVersion getOpenImmoVersion() {
        if (this.isLatestVersion()) {
            return OpenImmoUtils.VERSION;
        }
        String string = StringUtils.trimToNull((String)((String)this.get(OPENIMMO_VERSION)));
        OpenImmoVersion openImmoVersion = null;
        try {
            if (string != null) {
                openImmoVersion = OpenImmoVersion.valueOf((String)string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't determine OpenImmo version from '" + string + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return openImmoVersion != null ? openImmoVersion : OpenImmoUtils.VERSION;
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public String getTitle() {
        return "OpenImmo-XML";
    }

    @Override
    public String getVersion() {
        OpenImmoVersion openImmoVersion = this.getOpenImmoVersion();
        if (openImmoVersion == null) {
            openImmoVersion = OpenImmoUtils.VERSION;
        }
        return openImmoVersion.toReadableVersion();
    }

    @Override
    public String[] getVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = OpenImmoVersion.values();
        ArrayUtils.reverse((Object[])objectArray);
        for (Object object : objectArray) {
            arrayList.add(object.toReadableVersion());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setOpenImmoPropertyPublicIdExported(true);
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
        this.setLanguages(new Locale[]{Locale.GERMAN});
        this.setPropertyAddressHiddenIfUnpublished(true);
    }

    @Override
    public boolean isLatestVersion() {
        String string = StringUtils.trimToNull((String)((String)this.get(OPENIMMO_VERSION)));
        return string == null || "latest".equalsIgnoreCase(string);
    }

    public boolean isOpenImmoExtensionAt10Enabled() {
        String string = StringUtils.trimToNull((String)((String)this.get(OPENIMMO_EXTENSIONS_AT10)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isOpenImmoPropertyPublicIdExported() {
        String string = StringUtils.trimToNull((String)((String)this.get(OPENIMMO_PROPERTY_PUBLIC_ID_EXPORTED)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    public final boolean isPropertyPublicId() {
        return false;
    }

    @Override
    public void setLatestVersion() {
        this.setOpenImmoVersion(null);
    }

    public void setOpenImmoAgentId(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(OPENIMMO_AGENT_ID);
        } else {
            this.put(OPENIMMO_AGENT_ID, string);
        }
    }

    public void setOpenImmoAttachmentLocation(AbstractFormat.AttachmentMarker attachmentMarker) {
        if (attachmentMarker == null) {
            this.remove(OPENIMMO_ATTACHMENT_LOCATION);
        } else {
            this.put(OPENIMMO_ATTACHMENT_LOCATION, attachmentMarker.name());
        }
    }

    public void setOpenImmoExtensionAt10Enabled(boolean bl) {
        this.put(OPENIMMO_EXTENSIONS_AT10, String.valueOf(bl));
    }

    public void setOpenImmoPropertyPublicIdExported(boolean bl) {
        this.put(OPENIMMO_PROPERTY_PUBLIC_ID_EXPORTED, String.valueOf(bl));
    }

    public void setOpenImmoTechnicsMail(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(OPENIMMO_TECHNICS_MAIL);
        } else {
            this.put(OPENIMMO_TECHNICS_MAIL, string);
        }
    }

    public void setOpenImmoVersion(OpenImmoVersion openImmoVersion) {
        this.put(OPENIMMO_VERSION, openImmoVersion != null ? openImmoVersion.name() : "latest");
    }

    @Override
    public void setVersion(String string) {
        this.setOpenImmoVersion(OpenImmoVersion.detectFromString((String)string));
    }

    @Override
    protected void writeXmlObject(Openimmo openimmo, java.io.Writer writer) throws IOException, JAXBException {
        try {
            openimmo.getUebertragung().setTimestamp(Calendar.getInstance());
            OpenImmoTransferDocument openImmoTransferDocument = OpenImmoTransferDocument.newDocument((Openimmo)openimmo);
            openImmoTransferDocument.downgrade((XmlVersion)this.getOpenImmoVersion());
            openImmoTransferDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends OpenImmoWriter {
        private final PublishingMode priceMode;
        private final AbstractFormat.AttachmentMarker attachmentMarker;

        public Writer(Locale locale, boolean bl) {
            this(locale, null, null, bl);
        }

        public Writer(Locale locale, PublishingMode publishingMode, AbstractFormat.AttachmentMarker attachmentMarker, boolean bl) {
            super(locale);
            this.priceMode = publishingMode != null ? publishingMode : PublishingMode.DEFAULT;
            this.attachmentMarker = attachmentMarker;
            this.setAt10ExtensionEnabled(bl);
            AgencyPluginUtils.initJAXB(OpenImmoUtils.class);
        }

        protected Anbieter convertAgent(AgentImpl agentImpl) {
            Anbieter anbieter = super.convertAgent(agentImpl);
            if (agentImpl instanceof ImmoToolAgent) {
                ImmoToolAgent immoToolAgent = (ImmoToolAgent)agentImpl;
                if (anbieter.getImpressumStrukt() == null) {
                    anbieter.setImpressumStrukt(OpenImmoUtils.getFactory().createImpressumStrukt());
                }
                anbieter.getImpressumStrukt().setBerufsaufsichtsbehoerde(immoToolAgent.getAufsichtsBehoerde());
                anbieter.getImpressumStrukt().setHandelsregister(immoToolAgent.getHandelsRegister());
                anbieter.getImpressumStrukt().setUmsstId(immoToolAgent.getUstId());
                anbieter.getImpressumStrukt().setVertretungsberechtigter(immoToolAgent.getVertretung());
            }
            return anbieter;
        }

        protected Immobilie convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
            boolean bl;
            Immobilie immobilie = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
            boolean bl2 = bl = PublishingMode.NEVER.equals((Object)this.priceMode) || PublishingMode.DEFAULT.equals((Object)this.priceMode) && estateImpl.isHiddenPrices();
            if (bl) {
                immobilie.setPreise(OpenImmoUtils.getFactory().createPreise());
            }
            return immobilie;
        }

        protected Anhang createAnhang(EstateAttachmentImpl estateAttachmentImpl) {
            Anhang anhang = super.createAnhang(estateAttachmentImpl);
            if (anhang == null) {
                return null;
            }
            if (AbstractFormat.AttachmentMarker.EXTERN.equals((Object)this.attachmentMarker)) {
                anhang.setLocation(Anhang.Location.EXTERN);
            } else if (AbstractFormat.AttachmentMarker.INTERN.equals((Object)this.attachmentMarker)) {
                anhang.setLocation(Anhang.Location.INTERN);
            } else if (AbstractFormat.AttachmentMarker.REMOTE.equals((Object)this.attachmentMarker)) {
                anhang.setLocation(Anhang.Location.REMOTE);
            }
            return anhang;
        }

        protected Openimmo createRoot() {
            Openimmo openimmo = super.createRoot();
            openimmo.getUebertragung().setSendersoftware(ImmoToolEnvironment.getApplicationTitle());
            openimmo.getUebertragung().setSenderversion(ImmoToolEnvironment.getApplicationVersion());
            return openimmo;
        }
    }
}

