/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyObjectListCellRenderer
extends DefaultListCellRenderer<DbAgencyObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyObjectListCellRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyObjectListCellRenderer.class);
    private final String emptyText;

    public AgencyObjectListCellRenderer() {
        this(null);
    }

    public AgencyObjectListCellRenderer(String string) {
        this.emptyText = string;
    }

    public String getEmptyText() {
        return StringUtils.trimToEmpty((String)this.emptyText);
    }

    public Component getRenderedComponent(JList<? extends DbAgencyObject> jList, DbAgencyObject dbAgencyObject, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getRenderedComponent(jList, (Object)dbAgencyObject, n, bl, bl2);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (dbAgencyObject == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + StringEscapeUtils.escapeXml11((String)this.getEmptyText()) + " ]</div></html>");
        } else {
            String string;
            String string2 = dbAgencyObject.item.getPublicId();
            if (string2 == null) {
                string2 = "";
            }
            if (string2.length() > 0) {
                string2 = " / " + StringEscapeUtils.escapeXml11((String)string2);
            }
            if ((string = dbAgencyObject.item.getTitle(Locale.getDefault())) == null) {
                string = "";
            }
            if (string.length() > 50) {
                string = string.substring(0, 50) + "...";
            }
            String string3 = (String)StringUtils.defaultIfBlank((CharSequence)dbAgencyObject.item.getType().getTranslation(), (CharSequence)dbAgencyObject.item.getType().name());
            String string4 = (String)StringUtils.defaultIfBlank((CharSequence)dbAgencyObject.item.getAction().getTranslation(), (CharSequence)dbAgencyObject.item.getAction().name());
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + dbAgencyObject.id + string2 + "</b> | " + string3 + " / " + string4 + "<br><font size=\"-1\"><i>" + StringEscapeUtils.escapeXml11((String)string) + "</i></font></div></html>");
        }
        return jLabel;
    }

    protected void init() {
        super.init();
        this.setOpaque(true);
    }
}

