/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.tool.gui.AbstractRenderer;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class RoomCountRenderer
extends AbstractRenderer<Number> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoomCountRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(RoomCountRenderer.class);
    private final NumberFormat format;

    public RoomCountRenderer() {
        this(null, null);
    }

    public RoomCountRenderer(String string) {
        this(string, null);
    }

    public RoomCountRenderer(NumberFormat numberFormat) {
        this(null, numberFormat);
    }

    public RoomCountRenderer(String string, NumberFormat numberFormat) {
        super(string);
        if (numberFormat != null) {
            this.format = numberFormat;
        } else {
            this.format = NumberFormat.getNumberInstance(Locale.getDefault());
            this.format.setMaximumFractionDigits(1);
            this.format.setMinimumFractionDigits(0);
        }
    }

    public void render(Number number, JLabel jLabel) {
        jLabel.setHorizontalAlignment(0);
        if (number != null) {
            jLabel.setText(this.format.format(number));
        } else {
            jLabel.setText(this.getEmptyText());
        }
    }
}

