/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.extensions.ImportExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImport.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractImport.class);

    public AgencyImportDialog.AbstractImportTab createOptionsTab() {
        return null;
    }

    public ImmoToolTask createTask(File file, String string, AgencyImportTask.Settings settings, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser) {
        return new AgencyImportTask(file, this, string, settings, abstractDbDriver, dbAgencyExtension, dbUser);
    }

    public File getAttachedFile(String string, File file) {
        return new File(file, string);
    }

    public static AbstractImport getImport(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (ImportExtension importExtension : AgencyPluginUtils.getImportExtensions()) {
            Object[] objectArray = importExtension.createImports();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((AbstractImport)object).getName().equalsIgnoreCase(string)) continue;
                return object;
            }
        }
        return null;
    }

    public static Map<String, AbstractImport> getImports() {
        HashMap<String, AbstractImport> hashMap = new HashMap<String, AbstractImport>();
        for (ImportExtension importExtension : AgencyPluginUtils.getImportExtensions()) {
            Object[] objectArray = importExtension.createImports();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                hashMap.put(((AbstractImport)object).getName(), (AbstractImport)object);
            }
        }
        return hashMap;
    }

    public abstract String[] getFileExtensions();

    public abstract String getName();

    public AgencyImportTask.Settings getPreferredSettings() {
        return null;
    }

    public abstract String getTitle();

    public abstract String[] getVersions();

    public boolean isIncrementalTransferSupported() {
        return false;
    }

    public boolean isSingleLanguageFormat() {
        return true;
    }

    public abstract TransferImpl parseFile(File var1, String var2, AgencyImportTask.Settings var3) throws IOException;

    public abstract String validateFile(File var1) throws IOException;
}

