/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.immobiliare_it.ImmobiliareItReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItVersion;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmobiliareItImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItImport.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmobiliareItImport.class);
    private static final String NAME = "immobiliare";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Immobiliare-XML";
    }

    @Override
    public String[] getVersions() {
        return new String[]{ImmobiliareItUtils.VERSION.toReadableVersion()};
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        try {
            ImmobiliareItImportReader immobiliareItImportReader = new ImmobiliareItImportReader();
            immobiliareItImportReader.setOpenEstateLanguage(settings.getLanguage());
            return immobiliareItImportReader.readTransfer(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't load parser!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Can't parse document!", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't process document!", jAXBException);
        }
    }

    @Override
    public String validateFile(File file) throws IOException {
        ImmobiliareItDocument immobiliareItDocument = null;
        try {
            immobiliareItDocument = ImmobiliareItUtils.createDocument((File)file);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        if (immobiliareItDocument == null) {
            throw new IOException("The file does not contain a supported document.");
        }
        ImmobiliareItVersion immobiliareItVersion = immobiliareItDocument.getDocumentVersion();
        return immobiliareItVersion != null ? immobiliareItVersion.toReadableVersion() : null;
    }

    public static class ImmobiliareItImportReader
    extends ImmobiliareItReader {
        public ImmobiliareItImportReader() {
            ImmobiliareItImportReader.initJAXB();
        }

        protected EstateImpl convertImmobilie(Feed.Properties.Property property, Map<String, AgentContactImpl> map) throws OpenEstateException {
            EstateImpl estateImpl = super.convertImmobilie(property, map);
            if (estateImpl == null) {
                return null;
            }
            return estateImpl;
        }

        public static void initJAXB() {
            AgencyPluginUtils.initJAXB(ImmobiliareItUtils.class);
        }
    }
}

